<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-2">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('compras_create')): ?>
                    <a href="<?php echo e(route('compras.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Nova Compra
                    </a>
                    <?php endif; ?>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-4">
                            <?php echo Form::select('fornecedor_id', 'Fornecedor', ['' => 'Selecione'] + $fornecedores->pluck('razao_social', 'id')->all())
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::select('estado', 'Estado',
                            ['novo' => 'Novas',
                            'rejeitado' => 'Rejeitadas',
                            'cancelado' => 'Canceladas',
                            'aprovado' => 'Aprovadas',
                            '' => 'Todos'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <?php if(__countLocalAtivo() > 1): ?>
                        <div class="col-md-2">
                            <?php echo Form::select('local_id', 'Local', ['' => 'Selecione'] + __getLocaisAtivoUsuario()->pluck('descricao', 'id')->all())
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        <?php endif; ?>
                        <div class="col-md-4 col-xl-2 col-12">
                            <br>

                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('compras.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <?php if($contigencia != null): ?>
                <div class="row">
                    <div class="col-md-3">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="text-danger">Contigência ativada</h4>
                                <p class="text-danger">Tipo: <strong><?php echo e($contigencia->tipo); ?></strong></p>
                                <p class="text-danger">Data de ínicio: <strong><?php echo e(__data_pt($contigencia->created_at)); ?></strong></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <div class="col-md-12 mt-3">
                    <div class="table-responsive">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Ações</th>
                                    <th>#</th>
                                    <th>Fornecedor</th>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <th>Local</th>
                                    <?php endif; ?>
                                    <th>CPF/CNPJ</th>
                                    <th>Número</th>
                                    <th>XML Importado</th>
                                    <th>Valor</th>
                                    <th>Estado</th>
                                    <th>Ambiente</th>
                                    <th>Data</th>
                                    <th>Data de emissão</th>
                                    <th>Local de emissão</th>
                                    <th>Tipo</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <form action="<?php echo e(route('nfe.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>" style="width: 330px;">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>
                                            <?php if($item->estado == 'cancelado'): ?>
                                            <a class="btn btn-danger btn-sm" target="_blank" href="<?php echo e(route('nfe.imprimir-cancela', [$item->id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>
                                            <?php endif; ?>
                                            <?php if($item->estado == 'aprovado'): ?>
                                            <a class="btn btn-primary btn-sm" target="_blank" href="<?php echo e(route('nfe.imprimir', [$item->id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfe_transmitir')): ?>
                                            <button title="Cancelar NFe" type="button" class="btn btn-danger btn-sm" onclick="cancelar('<?php echo e($item->id); ?>', '<?php echo e($item->numero); ?>')">
                                                <i class="ri-close-circle-line"></i>
                                            </button>
                                            <button title="Corrigir NFe" type="button" class="btn btn-warning btn-sm" onclick="corrigir('<?php echo e($item->id); ?>', '<?php echo e($item->numero); ?>')">
                                                <i class="ri-file-warning-line"></i>
                                            </button>
                                            <?php endif; ?>

                                            <?php endif; ?>

                                            <?php if($item->estado == 'aprovado' || $item->estado == 'rejeitado'): ?>
                                            <button type="button" class="btn btn-dark btn-sm" onclick="info('<?php echo e($item->motivo_rejeicao); ?>', '<?php echo e($item->chave); ?>', '<?php echo e($item->estado); ?>', '<?php echo e($item->recibo); ?>')">
                                                <i class="ri-file-line"></i>
                                            </button>
                                            <?php endif; ?>
                                            <?php if($item->estado == 'novo' || $item->estado == 'rejeitado'): ?>

                                            <?php if($item->chave_importada == ''): ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('compras_edit')): ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('nfe.edit', $item->id)); ?>">
                                                <i class="ri-edit-line"></i>
                                            </a>
                                            <?php endif; ?>
                                            <?php endif; ?>

                                            <a target="_blank" title="XML temporário" class="btn btn-light btn-sm" href="<?php echo e(route('nfe.xml-temp', $item->id)); ?>">
                                                <i class="ri-file-line"></i>
                                            </a>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('compras_delete')): ?>
                                            <button type="button" class="btn btn-danger btn-sm btn-delete"><i class="ri-delete-bin-line"></i></button>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfe_transmitir')): ?>
                                            <button title="Transmitir NFe" type="button" class="btn btn-success btn-sm" onclick="transmitir('<?php echo e($item->id); ?>')">
                                                <i class="ri-send-plane-fill"></i>
                                            </button>
                                            <?php endif; ?>
                                            
                                            <?php endif; ?>

                                            <?php if($item->estado == 'aprovado' || $item->estado == 'cancelado'): ?>
                                            <button title="Consultar NFe" type="button" class="btn btn-light btn-sm" onclick="consultar('<?php echo e($item->id); ?>', '<?php echo e($item->numero); ?>')">
                                                <i class="ri-file-search-line"></i>
                                            </button>
                                            <?php endif; ?>

                                            <?php if($item->isItemValidade()): ?>
                                            <a href="<?php echo e(route('compras.info-validade', $item->id)); ?>" title="Editar Validade" type="button" class="btn btn-info btn-sm"><i class="ri-pencil-line"></i></a>
                                            <?php endif; ?>

                                            <!-- <a class="btn btn-info btn-sm" title="Imprimir Pedido" target="_blank" href="<?php echo e(route('nfe.imprimirVenda', [$item->id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a> -->
                                            <a class="btn btn-info btn-sm" title="Imprimir Pedido" onclick="printPedido('<?php echo e($item->id); ?>')">
                                                <i class="ri-printer-line"></i>
                                            </a>

                                            <a class="btn btn-light btn-sm" title="Gerar etiqueta" target="_blank" href="<?php echo e(route('compras.etiqueta', [$item->id])); ?>">
                                                <i class="ri-barcode-box-line"></i>
                                            </a>
                                            <?php if($item->chave_importada): ?>
                                            <a class="btn btn-dark btn-sm" title="Download XML importado" target="_blank" href="<?php echo e(route('compras.download-xml-importado', [$item->id])); ?>">
                                                <i class="ri-download-line"></i>
                                            </a>
                                            <?php endif; ?>
                                        </form>
                                    </td>
                                    <td><?php echo e($item->numero_sequencial); ?></td>
                                    <td><?php echo e($item->fornecedor ? $item->fornecedor->razao_social : "--"); ?></td>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <td class="text-danger"><?php echo e($item->localizacao->descricao); ?></td>
                                    <?php endif; ?>
                                    <td><?php echo e($item->fornecedor ? $item->fornecedor->cpf_cnpj : "--"); ?></td>
                                    <td><?php echo e($item->numero ? $item->numero : ''); ?></td>
                                    <td>
                                        <?php if($item->chave_importada): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(number_format($item->total, 2, ',', '.')); ?></td>
                                    <td width="150">
                                        <?php if($item->estado == 'aprovado'): ?>
                                        <span class="btn btn-success text-white btn-sm w-100">Aprovado</span>
                                        <?php elseif($item->estado == 'cancelado'): ?>
                                        <span class="btn btn-danger text-white btn-sm w-100">Cancelado</span>
                                        <?php elseif($item->estado == 'rejeitado'): ?>
                                        <span class="btn btn-warning text-white btn-sm w-100">Rejeitado</span>
                                        <?php else: ?>
                                        <span class="btn btn-info text-white btn-sm w-100">Novo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($item->ambiente == 2 ? 'Homologação' : 'Produção'); ?></td>
                                    <td><?php echo e(\Carbon\Carbon::parse($item->created_at)->format('d/m/Y H:i')); ?></td>
                                    <td><label style="width: 120px"><?php echo e($item->data_emissao ? __data_pt($item->data_emissao, 1) : '--'); ?></label></td>

                                    <td>
                                        <?php if($item->api): ?>
                                        <span class="text-success">API</span>
                                        <?php else: ?>
                                        <span class="text-primary">Painel</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($item->tpNF): ?>
                                        <span class="text-success">Saída</span>
                                        <?php else: ?>
                                        <span class="text-primary">Entrada</span>
                                        <?php endif; ?>
                                    </td>
                                    
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="11" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <br>
                    <?php echo $data->appends(request()->all())->links(); ?>

                </div>
                <h5 class="mt-2">Soma: <strong class="text-success">R$ <?php echo e(__moeda($data->sum('total'))); ?></strong></h5>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-cancelar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Cancelar NFe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">

                    <div class="col-md-12">
                        <?php echo Form::text('motivo-cancela', 'Motivo')
                        ->required(); ?>

                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                <button type="button" id="btn-cancelar" class="btn btn-danger">Cancelar</button>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal-corrigir" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Corrigir NFe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">

                    <div class="col-md-12">
                        <?php echo Form::text('motivo-corrigir', 'Motivo')
                        ->required(); ?>

                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                <button type="button" id="btn-corrigir" class="btn btn-warning">Corrigir</button>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    function info(motivo_rejeicao, chave, estado, recibo) {

        if (estado == 'rejeitado') {
            let text = "Motivo: " + motivo_rejeicao + "\n"
            text += "Chave: " + chave + "\n"
            swal("", text, "warning")
        } else {
            let text = "Chave: " + chave + "\n"
            text += "Recibo: " + recibo + "\n"
            swal("", text, "success")
        }
    }

    function printPedido(id){
        var disp_setting="toolbar=yes,location=no,";
        disp_setting+="directories=yes,menubar=yes,";
        disp_setting+="scrollbars=yes,width=850, height=600, left=100, top=25";

        var docprint=window.open(path_url+"nfe/imprimirVenda/"+id, "",disp_setting);

        docprint.focus();
    }
</script>
<script type="text/javascript" src="/js/nfe_transmitir.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Compras'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/erp.royalsistema.com.br/resources/views/compras/index.blade.php ENDPATH**/ ?>