<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('funcionario_create')): ?>
                    <div class="col-md-2">
                        <a href="<?php echo e(route('funcionarios.create')); ?>" class="btn btn-success">
                            <i class="ri-add-circle-fill"></i>
                            Novo Funcionário
                        </a>
                    </div>

                    <div class="col-md-8"></div>
                    <div class="col-md-2">
                        <a href="<?php echo e(route('comissao.index')); ?>" class="btn btn-dark float-end">
                            <i class="ri-wallet-2-fill"></i>
                            Comissão de vendas
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-4">
                            <?php echo Form::text('nome', 'Pesquisar por nome'); ?>

                        </div>
                        <div class="col-md-3 text-left">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('funcionarios.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Nome</th>
                                    <th>Departamento</th>
                                    <th>Salário</th>
                                    <th>Comissão</th>
                                    <th>Data de cadastro</th>
                                    <th>Status</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->nome); ?></td>
                                    <td><?php echo e($item->departamento?->nome ?? '-'); ?></td>
                                    <td><?php echo e(__moeda($item->salario)); ?></td>
                                    <td><?php echo e(__moeda($item->comissao)); ?></td>
                                    <td><?php echo e(__data_pt($item->created_at, 1)); ?></td>
                                    <td>
                                        <?php if($item->status): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <form action="<?php echo e(route('funcionarios.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('funcionario_edit')): ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('funcionarios.edit', [$item->id])); ?>">
                                                <i class="ri-pencil-fill"></i>
                                            </a>
                                            <?php endif; ?>

                                            <?php echo csrf_field(); ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('funcionario_delete')): ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('funcionario_edit')): ?>
                                            <a href="<?php echo e(route('funcionarios.atribuir', [$item->id])); ?>" class="btn btn-dark btn-sm" title="Atribuir Funcionário a Serviço"><i class="ri-user-settings-fill"></i></a>
                                            <?php endif; ?>
                                            
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', ['title' => 'Funcionários'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\kenne\OneDrive\Documentos\Meu ERP\__MACOSX (1)\resources\views/funcionario/index.blade.php ENDPATH**/ ?>