<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\VendiZapConfig;
use App\Models\Produto;
use App\Models\CategoriaVendiZap;
use App\Models\Localizacao;
use App\Models\ProdutoLocalizacao;
use Illuminate\Support\Str;

class VendiZapProdutoController extends Controller
{
    protected $url = "https://app.vendizap.com/api";

    public function index(Request $request){

        $config = VendiZapConfig::where('empresa_id', $request->empresa_id)->first();
        if($config == null){
            session()->flash("flash_error", "Configure as credenciais!");
            return redirect()->route('vendizap-config.index');
        }

        $ch = curl_init();
        $headers = [
            "X-Auth-Id: " . $config->auth_id,
            "X-Auth-Secret: " . $config->auth_secret,
        ];

        $nome = $request->nome;

        $urlFilter = $this->url . "/produtos";
        if($nome){
            $urlFilter .= "?descricao=$nome";
        }
        curl_setopt($ch, CURLOPT_URL, $urlFilter);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_ENCODING, '');
        $data = json_decode(curl_exec($ch));
        curl_close($ch);
        // dd($data);

        if(is_array($data)){
            foreach($data as $c){
                $item = Produto::where('empresa_id', $request->empresa_id)
                ->where('vendizap_id', $c->id)->first();

                if($item == null){
                    $this->cadastrarProduto($c);
                }
            }
        }
        return view('vendizap_produtos.index', compact('data'));

    }

    private function cadastrarProduto($p){
        $produto = Produto::create([
            'vendizap_id' => $p->id,
            'empresa_id' => request()->empresa_id,
            'nome' => $p->descricao,
            'valor_unitario' => isset($p->preco) ? $p->preco : 0,
        ]);

        $locais = Localizacao::where('empresa_id', request()->empresa_id)->get();
        foreach($locais as $l){
            ProdutoLocalizacao::updateOrCreate([
                'produto_id' => $produto->id, 
                'localizacao_id' => $l->id
            ]);
        }
    }

    public function edit($id){

        $item = Produto::where('vendizap_id', $id)->first();
        $config = VendiZapConfig::where('empresa_id', request()->empresa_id)->first();

        $ch = curl_init();
        $headers = [
            "X-Auth-Id: " . $config->auth_id,
            "X-Auth-Secret: " . $config->auth_secret,
        ];

        curl_setopt($ch, CURLOPT_URL, $this->url . '/produtos/'.$id);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_ENCODING, '');
        $data = json_decode(curl_exec($ch));
        curl_close($ch);
        dd($data);
        if($item == null){
            //cadastrar item
            $this->cadastrarProduto($data);
        }

        $item->estoque = '';
        $item->promocao = '';
        if(isset($data->estoque->_produto)){
            $item->estoque = $data->estoque->_produto;
        }

        if(isset($data->promocao->precoPromocional)){
            $item->promocao = $data->promocao->precoPromocional;
        }

        $categorias = CategoriaVendiZap::where('empresa_id', request()->empresa_id)->get();

        $categoriaSelect = [];
        foreach($data->categorias as $c){
            $categoriaSelect[] = $c->id;
        }

        return view('vendizap_produtos.edit', compact('item', 'data', 'categorias', 'categoriaSelect'));
    }

    public function update(Request $request, $id){
        $item = Produto::findOrFail($id);
        $config = VendiZapConfig::where('empresa_id', request()->empresa_id)->first();

        $ch = curl_init();
        $headers = [
            "X-Auth-Id: " . $config->auth_id,
            "X-Auth-Secret: " . $config->auth_secret,
            'Content-Type: application/json'
        ];

        $data = [
            'descricao' => $request->nome,
            'preco' => __convert_value_bd($request->preco),
            'exibir' => (bool)$request->exibir,
            'destaque' => (bool)$request->destaque,
            'codigo' => $request->codigo ?? '',
            'video' => $request->video ?? '',
        ];

        if($request->promocao){
            $data['promocao']['precoPromocional'] = __convert_value_bd($request->promocao);
        }

        if($request->categorias){
            $categorias = [];
            for($i=0; $i<sizeof($request->categorias); $i++){
                $categorias[] = $request->categorias[$i];
            }
            $data['categorias'] = $categorias;
        }

        if($request->largura){
            $data['dimensoes']['largura'] = $request->largura;
            $data['dimensoes']['altura'] = $request->altura;
            $data['dimensoes']['comprimento'] = $request->comprimento;
            $data['dimensoes']['peso'] = $request->peso;
        }
        // dd($data);
        // dd(json_encode($data));
        $image = null;

        if ($request->hasFile('image')) {

            if (!is_dir(public_path('uploads') . 'image_temp')) {
                mkdir(public_path('uploads') . 'image_temp', 0777, true);
            }

            $this->clearFolder(public_path('uploads'). '/image_temp');

            $file = $request->image;
            $ext = $file->getClientOriginalExtension();
            $file_name = Str::random(20) . ".$ext";

            $file->move(public_path('uploads'). '/image_temp', $file_name);
            $image = env('APP_URL') . '/uploads/image_temp/'.$file_name;
        }

        if($image != null){

            // $image = env('APP_URL') . '/uploads/image_temp/50Y1KFt4rjrUWS6KOXMD.png';
            $data['imagens'] = [$image];
            // dd($data);
        }

        curl_setopt($ch, CURLOPT_URL, $this->url . '/produtos/'.$item->vendizap_id);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");

        $data = json_decode(curl_exec($ch));
        curl_close($ch);
        // dd($data);
        if(isset($data->erros)){
            session()->flash("flash_error", "Algo deu errado: " . $data->erros[0]);
            return redirect()->back();
        }
        $item->nome = $request->nome;
        $item->save();

        // estoque

        if($request->estoque){
            if(sizeof($item->variacoes) == 0){
                $retorno = $this->ajustaEstoqueSimples($item, $request->estoque);

                if($retorno !== true){
                    session()->flash("flash_error", $retorno);
                }
            }
        }

        session()->flash("flash_success", "Produto atualizado!");
        return redirect()->route('vendizap-produtos.index');
    }

    private function ajustaEstoqueSimples($item, $quantidade){
        $config = VendiZapConfig::where('empresa_id', request()->empresa_id)->first();

        $ch = curl_init();
        $headers = [
            "X-Auth-Id: " . $config->auth_id,
            "X-Auth-Secret: " . $config->auth_secret,
            'Content-Type: application/json'
        ];

        $data = [
            'quantidade' => $quantidade
        ];

        curl_setopt($ch, CURLOPT_URL, $this->url . '/estoque/'.$item->vendizap_id);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");

        $data = json_decode(curl_exec($ch));
        curl_close($ch);
        // dd($data);
        return $data;
    }

    private function clearFolder($destino){
        $files = glob($destino."/*");
        foreach($files as $file){ 
            if(is_file($file)) unlink($file); 
        }
    }

}
