<?php

namespace App\Http\Controllers;

use App\Models\Departamento;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DepartamentoController extends Controller
{
    public function index()
    {
        $data = Departamento::orderBy('nome')->get();
        return view('departamento.index', compact('data'));
    }

    public function create()
    {
        $item = new Departamento();
        return view('departamento.create', compact('item'));
    }

    public function store(Request $request)
    {
        // dd(Auth::user());
        $request->validate([
            'nome' => 'required|string|max:255',
            'status' => 'required|boolean',
        ]);
        $data = $request->all();
        $data['empresa_id'] = Auth::user()->empresa_id;
        Departamento::create($data);
        return redirect()->route('departamento.index')->with('success', 'Departamento criado com sucesso!');
    }

    public function edit($id)
    {
        $item = Departamento::findOrFail($id);
        return view('departamento.edit', compact('item'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'nome' => 'required|string|max:255',
            'status' => 'required|boolean',
        ]);
        $item = Departamento::findOrFail($id);
        $item->update($request->all());
        return redirect()->route('departamento.index')->with('success', 'Departamento atualizado com sucesso!');
    }

    public function destroy($id)
    {
        $item = Departamento::findOrFail($id);
        $item->delete();
        return redirect()->route('departamento.index')->with('success', 'Departamento removido com sucesso!');
    }
} 