<?php
try {
    // Primeiro, conectar sem selecionar o banco de dados
    $pdo = new PDO("mysql:host=localhost", "root", "");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Criar o banco de dados se não existir
    $pdo->exec("DROP DATABASE IF EXISTS trocacheque");
    $pdo->exec("CREATE DATABASE trocacheque");
    
    // Selecionar o banco de dados
    $pdo->exec("USE trocacheque");
    
    // Criar tabela users primeiro
    $pdo->exec("CREATE TABLE users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(100) NOT NULL,
        email VARCHAR(100) NOT NULL UNIQUE,
        password VARCHAR(255) NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");
    
    // Criar um usuário padrão
    $password = password_hash('123456', PASSWORD_DEFAULT);
    $pdo->exec("INSERT INTO users (name, email, password) VALUES ('Admin', 'admin@admin.com', '$password')");
    
    // Depois criar a tabela cheques com a chave estrangeira
    $pdo->exec("CREATE TABLE cheques (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        cliente VARCHAR(100) NOT NULL,
        numero_cheque VARCHAR(20) NOT NULL,
        banco VARCHAR(50) NOT NULL,
        valor DECIMAL(10,2) NOT NULL,
        data_troca DATE NOT NULL,
        data_vencimento DATE NOT NULL,
        juros DECIMAL(10,2) NOT NULL,
        valor_liquido DECIMAL(10,2) NOT NULL,
        status_pagamento ENUM('pendente', 'pago') DEFAULT 'pendente',
        data_pagamento DATETIME DEFAULT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        UNIQUE KEY unique_cheque (user_id, numero_cheque, banco)
    )");
    
    echo "Banco de dados e tabelas criados com sucesso!";
    
} catch(PDOException $e) {
    echo "Erro: " . $e->getMessage();
}
?>
