function quitarCheque(chequeId) {
    if (!confirm('Tem certeza que deseja quitar este cheque?')) {
        return;
    }

    // Encontra o botão clicado
    const btn = document.querySelector(`button[onclick="quitarCheque(${chequeId})"]`);
    const originalText = btn.innerHTML;
    
    // Mostra loading no botão
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Quitando...';

    $.ajax({
        url: 'quitar_cheque.php',
        type: 'POST',
        data: { cheque_id: chequeId },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                alert(response.message);
                window.location.reload();
            } else {
                alert('Erro: ' + response.message);
                // Restaura o botão
                btn.disabled = false;
                btn.innerHTML = originalText;
            }
        },
        error: function(xhr, status, error) {
            console.error('Erro na requisição:', {
                status: status,
                error: error,
                response: xhr.responseText
            });
            alert('Erro ao comunicar com o servidor. Verifique o console para mais detalhes.');
            // Restaura o botão
            btn.disabled = false;
            btn.innerHTML = originalText;
        }
    });
}

function excluirCheque(chequeId) {
    if (!confirm('Tem certeza que deseja excluir este cheque?')) {
        return;
    }

    // Encontra o botão clicado
    const btn = document.querySelector(`button[onclick="excluirCheque(${chequeId})"]`);
    const originalText = btn.innerHTML;
    
    // Mostra loading no botão
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Excluindo...';

    $.ajax({
        url: 'excluir_cheque.php',
        type: 'POST',
        data: { cheque_id: chequeId },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                alert(response.message);
                window.location.reload();
            } else {
                alert('Erro: ' + response.message);
                // Restaura o botão
                btn.disabled = false;
                btn.innerHTML = originalText;
            }
        },
        error: function(xhr, status, error) {
            console.error('Erro na requisição:', {
                status: status,
                error: error,
                response: xhr.responseText
            });
            alert('Erro ao comunicar com o servidor. Verifique o console para mais detalhes.');
            // Restaura o botão
            btn.disabled = false;
            btn.innerHTML = originalText;
        }
    });
} 