<div class="row g-2">
    <div class="col-md-3">
        <?php echo Form::text('nome', 'Nome')
        ->required(); ?>

    </div>
    <div class="col-md-9">
        <?php echo Form::text('descricao', 'Descrição')
        ->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::tel('maximo_nfes', 'Max. NFe (mês)')
        ->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::tel('maximo_nfces', 'Max. NFCe (mês)')
        ->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::tel('maximo_ctes', 'Max. CTe (mês)')
        ->required(); ?>

    </div>

    <div class="col-md-2">
        <?php echo Form::tel('maximo_mdfes', 'Max. MDFe (mês)')
        ->required(); ?>

    </div>

    <div class="col-md-2">
        <?php echo Form::tel('maximo_usuarios', 'Max. Usuários')
        ->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::tel('maximo_locais', 'Max. Locais')
        ->required(); ?>

    </div>
    
    <div class="col-md-2">
        <?php echo Form::select('status', 'Ativo', ['1' => 'Sim', '0' => 'Não'])
        ->required()
        ->attrs(['class' => 'form-select']); ?>

    </div>
    
    <div class="col-md-2">
        <?php echo Form::select('visivel_clientes', 'Visível para clientes', ['1' => 'Sim', '0' => 'Não'])
        ->required()
        ->attrs(['class' => 'form-select']); ?>

    </div>

    <div class="col-md-2">
        <?php echo Form::select('visivel_contadores', 'Visível para contadores', ['0' => 'Não', '1' => 'Sim'])
        ->required()
        ->attrs(['class' => 'form-select']); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::tel('intervalo_dias', 'Intervalo de dias')
        ->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::tel('valor', 'Valor')
        ->required()
        ->attrs(['class' => 'moeda'])
        ->value(isset($item) ? __moeda($item->valor) : ''); ?>

    </div>

    <div class="col-md-2">
        <?php echo Form::tel('valor_implantacao', 'Valor de implantação')
        ->attrs(['class' => 'moeda'])
        ->value(isset($item) ? __moeda($item->valor_implantacao) : ''); ?>

    </div>

    <div class="col-md-2">
        <?php echo Form::select('auto_cadastro', 'Auto cadastro cliente', ['0' => 'Não', '1' => 'Sim'])
        ->required()
        ->attrs(['class' => 'form-select']); ?>

    </div>

    <div class="col-md-2">
        <?php echo Form::select('fiscal', 'Emite fiscal', ['1' => 'Sim', '0' => 'Não'])
        ->required()
        ->attrs(['class' => 'form-select']); ?>

    </div>

    <div class="col-md-2">
        <?php echo Form::select('segmento_id', 'Segmento', ['' => 'Selecione'] + $segmentos->pluck('nome', 'id')->all())
        ->attrs(['class' => 'form-select']); ?>

    </div>

    <div class="col-12"></div>

    <div class="row m-3">
        <h5>Módulos do plano</h5>
        <?php if(!isset($item)): ?>
        <div class="row">
            <div class="col-lg-3 col-6">
                <input type="checkbox" class="form-check-input check_todos" style=" width: 25px; height: 25px;">
                <label class="form-check-label m-1" for="customCheck1">Marcar todos</label>
            </div>
        </div>
        <?php endif; ?>
        <?php $__currentLoopData = $modulos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-lg-3 col-6">
            <input name="modulos[]" value="<?php echo e($m); ?>" type="checkbox" class="form-check-input check-module" style=" width: 25px; height: 25px;" <?php if(isset($item)): ?> <?php if(sizeof($item->modulos) > 0 && in_array($m, $item->modulos)): ?> checked="true" <?php endif; ?> <?php endif; ?>>
            <label class="form-check-label m-1" for="customCheck1"><?php echo e($m); ?></label>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="card col-md-3 mt-3 form-input">
        <div class="preview">
            <button type="button" id="btn-remove-imagem" class="btn btn-link-danger btn-sm btn-danger">x</button>
            <?php if(isset($item)): ?>
            <img id="file-ip-1-preview" src="<?php echo e($item->img); ?>">
            <?php else: ?>
            <img id="file-ip-1-preview" src="/imgs/no-image.png">
            <?php endif; ?>
        </div>
        <label for="file-ip-1">Imagem</label>
        <input type="file" id="file-ip-1" name="image" accept="image/*" onchange="showPreview(event);">
    </div>
    <?php if($errors->has('image')): ?>
    <div class="text-danger mt-2">
        <?php echo e($errors->first('image')); ?>

    </div>
    <?php endif; ?>
    <hr class="mt-4">
    <div class="col-12" style="text-align: right;">
        <button type="submit" class="btn btn-success px-5" id="btn-store">Salvar</button>
    </div>
</div>

<?php $__env->startSection('js'); ?>
<script type="text/javascript">

    $(function(){
        <?php if(!isset($item)): ?>
        setTimeout(() => {
            checkTodos()
        }, 10)
        <?php endif; ?>
    })

    $('body').on('click', '.check_todos', function () {
        setTimeout(() => {
            checkTodos()
        }, 10)
    })

    function checkTodos(){

        if($('.check_todos').is(':checked')){
            $('.check-module').prop('checked', 1)
        }else{
            $('.check-module').prop('checked', 0)
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php /**PATH C:\laragon\www\erp\resources\views/planos/_forms.blade.php ENDPATH**/ ?>