<!DOCTYPE html>
<html>
<head>
	<style type="text/css">
		.footer {
			position: fixed;
			bottom: 0px;
			padding: 0;
		}
		.footer small{
			color:grey; 
			font-size: 10px;
			text-align: left;
			margin-top: 100px !important;
		}
		body{
			width: 260px;
			/*background: #000;*/
			margin-left: -40px;
			margin-top: -40px;
		}
		.mt-20{
			margin-top: -20px;
		}
		.mt-10{
			margin-top: -10px;
		}
		.mt-25{
			margin-top: -25px;
		}
		table th{
			font-size: 10px;
			text-align: left;
		}

		table td{
			font-size: 11px;
		}

		strong{
			color: #3B4CA7;
		}

	</style>
</head>
<header>
	<div class="headReport">
	</div>
</header>
<body>
	<h5 style="text-align:center;" class="mt-10">Relatório de caixa</h5>
	<h5 style="text-align:center;" class="mt-20"><?php echo e($config->nome_fantasia); ?></h5>
	<h5 style="text-align:center;" class="mt-20"><?php echo e(__setMask($config->cpf_cnpj)); ?></h5>
	
	<table>
		<tbody>
			<tr>
				<td>
					<h6 style="text-align:left; font-size: 8px;" class="mt-20">Total de vendas: <strong>R$ <?php echo e(number_format($totalVendas, 2, ',', '.')); ?></strong></h6>
				</td>
				<td>
					<h6 style="margin-left:20px; font-size: 8px;" class="mt-20">Total de compras: <strong>R$ <?php echo e(number_format($totalCompras, 2, ',', '.')); ?></strong></h6>
				</td>
			</tr>
			<tr>
				<td>
					<h6 style="text-align:left; font-size: 8px;" class="mt-25">Abertura: <strong><?php echo e(__data_pt($item->created_at)); ?></strong></h6>
				</td>
				<td>
					<h6 style="margin-left:20px; font-size: 8px;" class="mt-25">Fechamento: <strong><?php echo e(__data_pt($item->updated_at_at)); ?></strong></h6>
				</td>
			</tr>

		</tbody>
	</table>

	<h6 style="text-align:left; border-top: 1px solid #000;" class="mt-20">Total por tipo de pagamento:</h6>
	<table>
		<tbody>
			<?php $__currentLoopData = $somaTiposPagamento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<?php if($tp > 0): ?>
			<tr>
				<td>
					<h6 style="text-align:left; font-size: 9px; width: 150px;" class="mt-25"><?php echo e(App\Models\Nfce::getTipoPagamento($key)); ?></h6>
				</td>
				<td>
					<h6 style="text-align:left; font-size: 9px;" class="mt-25">R$ <?php echo e(__moeda($tp)); ?></h6>
				</td>
			</tr>
			<?php endif; ?>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</tbody>
	</table>

	<h6 style="text-align:left; border-top: 1px solid #000;" class="mt-20">Vendas:</h6>
	<table>
		<tbody>
			<thead>
				<tr>
					<th>
						<h6 style="text-align:left; font-size: 9px; width: 107px;" class="mt-25">CLIENTE</h6>
					</th>

					<th>
						<h6 style="text-align:left; font-size: 9px; width: 70px;" class="mt-25">DATA</h6>
					</th>
					<th>
						<h6 style="text-align:left; font-size: 9px; width: 100px;" class="mt-25">TIPO DE PAG.</h6>
					</th>
				</tr>
				<tr>
					<th>
						<h6 style="text-align:left; font-size: 9px; width: 70px;" class="mt-25">ESTADO</h6>
					</th>
					<th>
						<h6 style="text-align:left; font-size: 9px; width: 70px;" class="mt-25">NFCE/NFE</h6>
					</th>
					<th>
						<h6 style="text-align:left; font-size: 9px; width: 70px;" class="mt-25">VALOR</h6>
					</th>
				</tr>
			</thead>

			<tbody>
				
				<?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<tr>
					<td>
						<h6 style="text-align:left; font-size: 9px; width: 107px;" class="mt-25"><?php echo e($v->cliente->razao_social ?? 'NÃO IDENTIFCADO'); ?></h6>
					</td>

					<td>
						<h6 style="text-align:left; font-size: 9px; width: 70px;" class="mt-25"><?php echo e(__data_pt($v->created_at)); ?></h6>
					</td>
					<td>
						<h6 style="text-align:left; font-size: 9px; width: 100px;" class="mt-25">
							<?php if($v->tipo_pagamento == '99'): ?>
							Outros
							<?php else: ?>
							<?php echo e($v->tipo_pagamento ? $v->getTipoPagamento($v->tipo_pagamento) : 'Pag Múltiplo'); ?>

							<?php endif; ?>
						</h6>
					</td>
				</tr>

				<tr>
					<td>
						<h6 style="text-align:left; font-size: 9px; width: 107px; border-bottom: 1px solid #999;" class="mt-25"><?php echo e($v->tipo != 'OS' ? strtoupper($v->estado) : ''); ?></h6>
					</td>
					<td>
						<h6 style="text-align:left; font-size: 9px; width: 70px; border-bottom: 1px solid #999;" class="mt-25">
							<?php if($v->estado == 'aprovado'): ?>
							<?php if($v->tipo == 'Nfe'): ?>
							<?php echo e($v->numero > 0 ? $v->numero : '--'); ?>

							<?php else: ?>
							<?php echo e($v->numero > 0 ? $v->numero : '--'); ?>

							<?php endif; ?>
							<?php else: ?>
							--
							<?php endif; ?>
						</h6>
					</td>
					
					<td>
						<h6 style="text-align:left; font-size: 9px; width: 70px; border-bottom: 1px solid #999;" class="mt-25">
							R$<?php if($v->tipo != 'OS'): ?>
							<?php echo e(__moeda($v->total)); ?>

							<?php else: ?>
							<?php echo e(__moeda($v->valor)); ?>

							<?php endif; ?>
						</h6>
					</td>
				</tr>

				
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</tbody>
		</tbody>
	</table>


	<?php
	$somaSuprimento = 0;
	$somaSangria = 0;
	?>

	<h6 style="text-align:left; border-top: 1px solid #000;" class="mt-20">Suprimentos:</h6>
	<table>
		<tbody>
			<?php if(sizeof($suprimentos) > 0): ?>
			<?php $__currentLoopData = $suprimentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

			<?php
			$somaSuprimento += $s->valor;
			?> 
			<tr>
				<td>
					<h6 style="text-align:left; font-size: 9px; width: 150px;" class="mt-25">
						<?php echo e(__data_pt($s->created_at)); ?>

					</h6>
				</td>
				<td>
					<h6 style="text-align:left; font-size: 9px;" class="mt-25">R$ <?php echo e(__moeda($s->valor)); ?></h6>
				</td>
			</tr>

			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			<?php else: ?>
			<tr>
				<td>
					<h6 style="text-align:left; font-size: 9px; width: 150px;" class="mt-25">
						--
					</h6>
				</td>
				<td>
					<h6 style="text-align:left; font-size: 9px;" class="mt-25">R$ <?php echo e(__moeda(0)); ?></h6>
				</td>
			</tr>
			<?php endif; ?>
		</tbody>
	</table>

	<h6 style="text-align:left; border-top: 1px solid #000;" class="mt-20">Sangrias:</h6>
	<table>
		<tbody>
			<?php if(sizeof($sangrias) > 0): ?>
			<?php $__currentLoopData = $sangrias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

			<?php
			$somaSangria += $s->valor;
			?>
			<tr>
				<td>
					<h6 style="text-align:left; font-size: 9px; width: 150px;" class="mt-25">
						<?php echo e(__data_pt($s->created_at)); ?>

					</h6>
				</td>
				<td>
					<h6 style="text-align:left; font-size: 9px;" class="mt-25">R$ <?php echo e(__moeda($s->valor)); ?></h6>
				</td>
			</tr>

			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			<?php else: ?>
			<tr>
				<td>
					<h6 style="text-align:left; font-size: 9px; width: 150px;" class="mt-25">
						--
					</h6>
				</td>
				<td>
					<h6 style="text-align:left; font-size: 9px;" class="mt-25">R$ <?php echo e(__moeda(0)); ?></h6>
				</td>
			</tr>
			<?php endif; ?>
		</tbody>
	</table>

	<table>
		<tbody>
			<tr>
				<td style="width: 115px;">
					<h6 style="text-align:left; font-size: 9px;" class="mt-20">
						Soma de vendas: <strong>R$ <?php echo e(__moeda($totalVendas)); ?></strong>
					</h6>
				</td>
				<td style="width: 130px;">
					<h6 style="float: right; font-size: 9px;" class="mt-20">Soma de sangria: 
						<strong>R$ <?php echo e(__moeda($somaSangria)); ?></strong>
					</h6>
				</td>
			</tr>
			<tr>
				<td style="width: 115px;">
					<h6 style="text-align:left; font-size: 9px;" class="mt-20">
						Soma de suprimento: <strong>R$ <?php echo e(__moeda($somaSuprimento)); ?></strong>
					</h6>
				</td>
				<td style="width: 130px;">
					<h6 style="float: right; font-size: 9px;" class="mt-20">Valor em caixa: 
						<strong>R$ <?php echo e(__moeda($somaSuprimento + $totalVendas - $somaSangria)); ?></strong>
					</h6>
				</td>
			</tr>
			<tr>
				<td style="width: 115px;">
					<h6 style="text-align:left; font-size: 9px;" class="mt-20">
						Contagem gaveta: <strong>R$ <?php echo e(__moeda($item->valor_dinheiro)); ?></strong>
					</h6>
				</td>
				<td style="width: 130px;">
					<h6 style="float: right; font-size: 9px;" class="mt-20">Soma de serviços: 
						<strong>R$ <?php echo e(__moeda($somaServicos)); ?></strong>
					</h6>
				</td>
			</tr>

		</tbody>
	</table>
	<h6 style="text-align:left; border-top: 1px solid #000;" class="mt-10">PRODUTO VENDIDOS:</h6>
	<table>

		<thead>
			<tr>
				<th>
					<h6 style="text-align:left; font-size: 9px; width: 147px;" class="mt-25">PRODUTO</h6>
				</th>

				<th>
					<h6 style="text-align:left; font-size: 9px; width: 107px;" class="mt-25">QUANTIDADE</h6>
				</th>

			</tr>
			<tr>
				<th>
					<h6 style="text-align:left; font-size: 9px; width: 127px;" class="mt-25">VALOR VENDA</h6>
				</th>
				<th>
					<h6 style="text-align:left; font-size: 9px; width: 107px;" class="mt-25">VALOR COMPRA</h6>
				</th>

			</tr>
		</thead>
		<tbody>
			<?php $__currentLoopData = $produtos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<tr>
				<td>
					<h6 style="text-align:left; font-size: 9px; width: 147px;" class="mt-25">
						<?php echo e($p['nome']); ?>

					</h6>
				</td>
				<td>
					<h6 style="text-align:left; font-size: 9px; width: 107px;" class="mt-25">
						<?php echo e($p['quantidade']); ?>

					</h6>
				</td>
			</tr>
			<tr>
				<td>
					<h6 style="text-align:left; font-size: 9px; width: 147px; border-bottom: 1px solid #999;" class="mt-25">
						<?php echo e(__moeda($p['valor_venda'])); ?>

					</h6>
				</td>
				<td>
					<h6 style="text-align:left; font-size: 9px; width: 107px; border-bottom: 1px solid #999;" class="mt-25">
						<?php echo e(__moeda($p['valor_compra'])); ?>

					</h6>
				</td>
			</tr>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</tbody>

	</table>
	<br>
	<table>
        <tr>
            <td>
                ________________________________________
            </td>
        </tr>
        <tr>
            <td>
                <?php echo e($usuario->name); ?> - <?php echo e(date('d/m/Y H:i')); ?>

            </td>
        </tr>
    </table>

</body>
<?php /**PATH /www/wwwroot/erp.royalsistema.com.br/resources/views/caixa/imprimir_80.blade.php ENDPATH**/ ?>