<div class="leftside-menu">
    <!-- Brand Logo Light -->
    <a href="/" class="logo logo-light">
        <span class="logo-lg">
            <img class="logo-painel" src="/logo.png" alt="logo">
        </span>
        <span class="logo-sm">
            <img src="/logo-sm.png" alt="small logo">
        </span>
    </a>

    <!-- Brand Logo Dark -->
    <a href="/" class="logo logo-dark">
        <span class="logo-lg">
            <img class="logo-painel" src="/logo.png" alt="dark logo">
        </span>
        <span class="logo-sm">
            <img src="/logo-sm.png" alt="small logo">
        </span>
    </a>

    <!-- Sidebar Hover Menu Toggle Button -->
    <div class="button-sm-hover" data-bs-toggle="tooltip" data-bs-placement="right" title="Show Full Sidebar">
        <i class="ri-checkbox-blank-circle-line align-middle"></i>
    </div>

    <!-- Full Sidebar Menu Close Button -->
    <div class="button-close-fullsidebar">
        <i class="ri-close-fill align-middle"></i>
    </div>

    <!-- Sidebar -left -->
    <div class="h-100" id="leftside-menu-container" data-simplebar>
        <!-- Leftbar User -->
        <div class="leftbar-user p-3 text-white">
            <a <?php if(!__isContador()): ?> href="<?php echo e(route('usuarios.profile', Auth::user()->id)); ?>" <?php endif; ?> class="d-flex align-items-center text-reset">
                <div class="flex-shrink-0">
                    <?php if(Auth::user()->imagem != null): ?>
                    <img src="<?php echo e(Auth::user()->img); ?>" height="42" class="rounded-circle shadow">
                    <?php else: ?>
                    <img src="/assets/images/users/avatar-4.jpg" height="42" class="rounded-circle shadow">
                    <?php endif; ?>
                </div>
                <div class="flex-grow-1 ms-2">
                    <span class="fw-semibold fs-15 d-block"> <?php echo e(Auth::user()->name); ?></span>
                    <span class="fs-13"><?php echo e(Auth::user()->tipo); ?></span>
                </div>
                <div class="ms-auto">
                    <i class="ri-arrow-right-s-fill fs-20"></i>
                </div>
            </a>
        </div>

        <!--- Sidemenu -->
        <ul class="side-nav" id="step4">

            <li class="side-nav-title mt-1"> Menu</li>

            <li class="side-nav-item">
                <a href="<?php echo e(route('home')); ?>" class="side-nav-link">
                    <i class="ri-dashboard-2-fill"></i>
                    <span class="badge bg-success float-end"></span>
                    <span> Home </span>
                </a>
            </li>

            <?php if(__isSuporte()): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarPages2" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-broadcast-line"></i>
                    <span> Suporte </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarPages2">
                    <ul class="side-nav-second-level">

                        <li>
                            <a href="<?php echo e(route('empresas.index')); ?>">Empresas</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('segmentos.index')); ?>">Segmentos</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('cidades.index')); ?>">Cidades</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('usuario-super.index')); ?>">Usuários</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('ncm.index')); ?>">NCM</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('logs.index')); ?>">Logs</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('ibpt.index')); ?>">IBPT</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('ticket-super.index')); ?>">Ticket</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('configuracao-super.index')); ?>">Configuração</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('notificacao-super.index')); ?>">Notificações</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('padroes-etiqueta.index')); ?>">Padrões para etiqueta</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('video-suporte.index')); ?>">Videos de suporte</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('relatorios-adm.index')); ?>">Relatórios</a>
                        </li>
                        
                    </ul>

                </div>
            </li>

            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarPermissao" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-rotate-lock-line"></i>
                    <span> Controle de acesso </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarPermissao">
                    <ul class="side-nav-second-level">

                        <li>
                            <a href="<?php echo e(route('permissions.index')); ?>">Permissões</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('roles.index')); ?>">Atribuições</a>
                        </li>

                    </ul>
                </div>
            </li>

            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarPages1" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-file-mark-fill"></i>
                    <span> Emissões </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarPages1">
                    <ul class="side-nav-second-level">

                        <li>
                            <a href="<?php echo e(route('nfe-all')); ?>">NFe</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('nfce-all')); ?>">NFCe</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('cte-all')); ?>">CTe</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('mdfe-all')); ?>">MDFe</a>
                        </li>
                    </ul>
                </div>
            </li>

            <?php endif; ?>
            <?php if(__isMaster()): ?>

            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarPages2" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-stack-fill"></i>
                    <span> SuperAdmin </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarPages2">
                    <ul class="side-nav-second-level">

                        <li>
                            <a href="<?php echo e(route('empresas.index')); ?>">Empresas</a>
                        </li>

                        <?php if(env("CONTADOR") == 1): ?>
                        <li>
                            <a href="<?php echo e(route('contadores.index')); ?>">Contadores</a>
                        </li>
                        <?php endif; ?>

                        <li>
                            <a href="<?php echo e(route('planos.index')); ?>">Planos</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('segmentos.index')); ?>">Segmentos</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('cidades.index')); ?>">Cidades</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('usuario-super.index')); ?>">Usuários</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('gerenciar-planos.index')); ?>">Gerenciar planos</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('financeiro-plano.index')); ?>">Financeiro planos</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('planos-pendentes.index')); ?>">Planos pendentes</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('ncm.index')); ?>">NCM</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('natureza-operacao-super.index')); ?>">Naturezas de operação</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('padrao-tributacao-produto-super.index')); ?>">Padrões de tributação</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('logs.index')); ?>">Logs</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('ibpt.index')); ?>">IBPT</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('ticket-super.index')); ?>">Ticket</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('configuracao-super.index')); ?>">Configuração</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('notificacao-super.index')); ?>">Notificações</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('padroes-etiqueta.index')); ?>">Padrões para etiqueta</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('video-suporte.index')); ?>">Videos de suporte</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('relatorios-adm.index')); ?>">Relatórios</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('contrato-config.index')); ?>">Configuração de contrato</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('contrato-config.list')); ?>">Lista de contratos</a>
                        </li>

                    </ul>
                </div>
            </li>

            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarPermissao" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-rotate-lock-line"></i>
                    <span> Controle de acesso </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarPermissao">
                    <ul class="side-nav-second-level">

                        <li>
                            <a href="<?php echo e(route('permissions.index')); ?>">Permissões</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('roles.index')); ?>">Atribuições</a>
                        </li>

                    </ul>
                </div>
            </li>

            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarPages1" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-file-mark-fill"></i>
                    <span> Emissões </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarPages1">
                    <ul class="side-nav-second-level">

                        <li>
                            <a href="<?php echo e(route('nfe-all')); ?>">NFe</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('nfce-all')); ?>">NFCe</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('cte-all')); ?>">CTe</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('mdfe-all')); ?>">MDFe</a>
                        </li>
                    </ul>
                </div>
            </li>

            <?php if(env("MARKETPLACE") == 1): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarMarketPlace" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-store-2-line"></i>
                    <span>Delivery/Marketplace</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarMarketPlace">
                    <ul class="side-nav-second-level">

                        <li>
                            <a href="<?php echo e(route('bairros-super.index')); ?>">Bairros</a>
                        </li>

                    </ul>
                </div>
            </li>
            <?php endif; ?>

            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarFinanceiroBoleto" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-coins-line"></i>
                    <span>Financeiro Boletos</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarFinanceiroBoleto">
                    <ul class="side-nav-second-level">

                        <li>
                            <a href="<?php echo e(route('financeiro-boleto.index')); ?>">Listar</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('financeiro-boleto.gerar')); ?>">Gerador</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('financeiro-boleto.logs')); ?>">Logs</a>
                        </li>

                    </ul>
                </div>
            </li>

            <?php if(env("APP_ENV") != "demo"): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarAtualizacao" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-refresh-fill"></i>
                    <span>Atualização </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarAtualizacao">
                    <ul class="side-nav-second-level">

                        <li>
                            <a href="<?php echo e(route('update-sql.index')); ?>">Banco de dados</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('update-file.index')); ?>">Diretórios</a>
                        </li>
                    </ul>
                </div>
            </li>

            <?php endif; ?>

            <li class="side-nav-item">
                <a href="<?php echo e(route('registro')); ?>" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-bookmark-3-fill"></i>
                    <span>Registro de Software</span>
                </a>
            </li>

            <li class="side-nav-item">
                <a href="<?php echo e(route('sugestao.index')); ?>" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-code-s-slash-line"></i>
                    <span>Susgestão e Desenvolvimento</span>
                </a>
            </li>

            <?php endif; ?>

            <?php if(!__isMaster()): ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Produtos')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['produtos_view', 'categoria_produtos_view', 'inventario_view', 'lista_preco_view'])): ?>

            <li class="side-nav-item" id="step7">
                <a data-bs-toggle="collapse" href="#sidebarExtendedProd" aria-expanded="false" aria-controls="sidebarExtendedUI" class="side-nav-link">
                    <i class="ri-product-hunt-fill"></i>
                    <span> Produtos </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarExtendedProd">
                    <ul class="side-nav-second-level">

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categoria_produtos_view')): ?>
                        <li>
                            <a href="<?php echo e(route('categoria-produtos.index')); ?>">Categorias</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('produtos_view')): ?>
                        <li>
                            <a href="<?php echo e(route('produtos.index')); ?>">Listar</a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('produtos_create')): ?>
                        <li>
                            <a href="<?php echo e(route('produtos.create')); ?>">Novo Produto</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('estoque_view')): ?>
                        <li>
                            <a href="<?php echo e(route('estoque.index')); ?>">Estoque</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inventario_view')): ?>
                        <li>
                            <a href="<?php echo e(route('inventarios.index')); ?>">Inventário</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('variacao_view')): ?>
                        <li>
                            <a href="<?php echo e(route('variacoes.index')); ?>">Variações</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lista_preco_view')): ?>
                        <li>
                            <a href="<?php echo e(route('lista-preco.index')); ?>">Lista de preços</a>
                        </li>
                        <?php endif; ?>

                        <?php if(__isPlanoFiscal()): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('config_produto_fiscal_view')): ?>
                        <li>
                            <a href="<?php echo e(route('produtopadrao-tributacao.index')); ?>">Configuração Padrão Fiscal</a>
                        </li>
                        <?php endif; ?>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('marcas_view')): ?>
                        <li>
                            <a href="<?php echo e(route('marcas.index')); ?>">Marcas</a>
                        </li>
                        <?php endif; ?>

                        <li>
                            <a href="<?php echo e(route('modelo-etiquetas.index')); ?>">Modelos de Etiqueta</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('produto-consulta-codigo.index')); ?>">Consulta código</a>
                        </li>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transferencia_estoque_view')): ?>
                        <li>
                            <a href="<?php echo e(route('transferencia-estoque.index')); ?>">Transferência de estoque</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('unidade_medida_view')): ?>
                        <li>
                            <a href="<?php echo e(route('unidades-medida.index')); ?>">Unidades de medida</a>
                        </li>
                        <?php endif; ?>

                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Atendimento')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['atendimentos_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarAtendimento" aria-expanded="false" aria-controls="sidebarAtendimento" class="side-nav-link">
                    <i class="ri-store-2-line"></i>
                    <span> Atendimento </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarAtendimento">
                    <ul class="side-nav-third-level">
                        <li>
                            <a href="<?php echo e(route('atendimentos.index')); ?>">Dias de Atendimento</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('interrupcoes.index')); ?>">Interrupções</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('funcionamentos.index')); ?>">Horário de Funcionamento</a>
                        </li>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Serviços')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['servico_view', 'categoria_servico_view', 'ordem_servico_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarExtendedServ" aria-expanded="false" aria-controls="sidebarExtendedSer" class="side-nav-link">
                    <i class="ri-tools-fill"></i>
                    <span> Serviços </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarExtendedServ">
                    <ul class="side-nav-second-level">

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categoria_servico_view')): ?>
                        <li>
                            <a href="<?php echo e(route('categoria-servico.index')); ?>">Categorias</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('servico_view')): ?>
                        <li>
                            <a href="<?php echo e(route('servicos.index')); ?>">Listar</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('servico_create')): ?>
                        <li>
                            <a href="<?php echo e(route('servicos.create')); ?>">Novo serviço</a>
                        </li>
                        <?php endif; ?>

                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Serviços')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['ordem_servico_view'])): ?>

            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarOs" aria-expanded="false" aria-controls="sidebarExtendedSer" class="side-nav-link">
                    <i class="ri-ruler-2-line"></i>
                    <span> Ordem de Serviço </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarOs">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ordem_servico_view')): ?>
                        <li>
                            <a href="<?php echo e(route('ordem-servico.index')); ?>">Listar</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ordem_servico_create')): ?>
                        <li>
                            <a href="<?php echo e(route('ordem-servico.create')); ?>">Nova OS</a>
                        </li>
                        <?php endif; ?>

                        <?php if(__isSegmentoPlanoOtica()): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('convenio_view')): ?>
                        <li>
                            <a href="<?php echo e(route('convenios.index')); ?>">Convênios</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('medico_view')): ?>
                        <li>
                            <a href="<?php echo e(route('medicos.index')); ?>">Médicos</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('laboratorio_view')): ?>
                        <li>
                            <a href="<?php echo e(route('laboratorios.index')); ?>">Laboratórios</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tratamento_otica_view')): ?>
                        <li>
                            <a href="<?php echo e(route('tratamentos-otica.index')); ?>">Tratamentos ótica</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('formato_armacao_view')): ?>
                        <li>
                            <a href="<?php echo e(route('formato-armacao.index')); ?>">Formatos de armação</a>
                        </li>
                        <?php endif; ?>

                        <li>
                            <a href="<?php echo e(route('tipo-armacao.index')); ?>">Tipos de armação</a>
                        </li>

                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('metas_view')): ?>
                        <li>
                            <a href="<?php echo e(route('ordem-servico.metas')); ?>">Metas</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Ordem de Produção')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['ordem_producao_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarOrdemProducao" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-pencil-ruler-line"></i>

                    <span>Ordem de Produção</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarOrdemProducao">
                    <ul class="side-nav-second-level">

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ordem_producao_view')): ?>
                        <li>
                            <a href="<?php echo e(route('ordem-producao.index')); ?>">Listar</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ordem_producao_create')): ?>
                        <li>
                            <a href="<?php echo e(route('ordem-producao.create')); ?>">Nova Ordem</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Agendamentos')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['agendamento_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarAgendamentos" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-calendar-event-fill"></i>

                    <span>Agendamentos</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarAgendamentos">
                    <ul class="side-nav-second-level">
                        <li>
                            <a href="<?php echo e(route('agendamentos.index')); ?>">Listar</a>
                        </li>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Usuários')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['usuarios_view', 'controle_acesso_view'])): ?>
            <li class="side-nav-item" id="step6">
                <a data-bs-toggle="collapse" href="#sidebarUsuarios" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-user-fill"></i>

                    <span>Usuários</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarUsuarios">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('usuarios_view')): ?>
                        <li>
                            <a href="<?php echo e(route('usuarios.index')); ?>">Listar</a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('controle_acesso_view')): ?>
                        <li>
                            <a href="<?php echo e(route('controle-acesso.index')); ?>">Controle de acesso</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Pessoas')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['clientes_view', 'fornecedores_view', 'transportadoras_view'])): ?>
            <li class="side-nav-item" id="step6">
                <a data-bs-toggle="collapse" href="#sidebarPessoas" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-group-2-fill"></i>

                    <span>Pessoas</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarPessoas">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('clientes_view')): ?>
                        <li>
                            <a href="<?php echo e(route('clientes.index')); ?>">Clientes</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('fornecedores_view')): ?>
                        <li>
                            <a href="<?php echo e(route('fornecedores.index')); ?>">Fornecedores</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transportadoras_view')): ?>
                        <li>
                            <a href="<?php echo e(route('transportadoras.index')); ?>">Transportadoras</a>
                        </li>
                        <?php endif; ?>

                    </ul>
                </div>
            </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['funcionario_view', 'apuracao_mensal_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarGestaoPessoal" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-folder-user-line"></i>

                    <span>Gestão Pessoal</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarGestaoPessoal">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('funcionario_view')): ?>
                        <li>
                            <a href="<?php echo e(route('funcionarios.index')); ?>">Funcionários</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apuracao_mensal_view')): ?>
                        <li>
                            <a href="<?php echo e(route('evento-funcionarios.index')); ?>">Eventos</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('funcionario-eventos.index')); ?>">Funcionários x Eventos</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('apuracao-mensal.index')); ?>">Apuração Mensal</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('comissao_margem_view')): ?>
                        <li>
                            <a href="<?php echo e(route('comissao-margem.index')); ?>">Comissão por margem</a>
                        </li>
                        <?php endif; ?>

                    </ul>
                </div>
            </li>
            <?php endif; ?>

            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Compras')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['compras_view', 'manifesto_view', 'cotacao_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarCompra" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-logout-box-line"></i>

                    <span>Compras</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarCompra">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('compras_view')): ?>
                        <li>
                            <a href="<?php echo e(route('compras.index')); ?>">Listar</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('compras_create')): ?>
                        <li>
                            <a href="<?php echo e(route('compras.create')); ?>" data-toggle="fullscreen" class="dropdown-item">Nova
                            </a>
                        </li>
                        <?php endif; ?>

                        <li>
                            <a href="<?php echo e(route('compras.xml')); ?>" data-toggle="fullscreen" class="dropdown-item">
                                Importar XML
                            </a>
                        </li>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manifesto_view')): ?>
                        <li>
                            <a href="<?php echo e(route('manifesto.index')); ?>" data-toggle="fullscreen" class="dropdown-item">
                                Manifesto
                            </a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cotacao_view')): ?>
                        <li>
                            <a href="<?php echo e(route('cotacoes.index')); ?>" data-toggle="fullscreen" class="dropdown-item">
                                Cotação
                            </a>
                        </li>
                        <?php endif; ?>

                        <?php if(__isPlanoFiscal()): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('arquivos_xml_view')): ?>
                        <li>
                            <a href="<?php echo e(route('nfe-entrada-xml.index')); ?>">Arquivos XML Emitidos</a>
                        </li>
                        <?php endif; ?>
                        <?php endif; ?>

                        <?php if(__isPlanoFiscal()): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('arquivos_xml_view')): ?>
                        <li>
                            <a href="<?php echo e(route('nfe-importa-xml.index')); ?>">Arquivos XML Importados</a>
                        </li>
                        <?php endif; ?>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('relacao_dados_fornecedor_view')): ?>
                        <li>
                            <a href="<?php echo e(route('relacao-dados-fornecedor.index')); ?>" data-toggle="fullscreen" class="dropdown-item">
                                Relação dados fornecedor
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isPlanoFiscal()): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['devolucao_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarDevolucao" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-arrow-go-back-fill"></i>

                    <span>Devolução</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarDevolucao">
                    <ul class="side-nav-second-level">

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('devolucao_view')): ?>
                        <li>
                            <a href="<?php echo e(route('devolucao.index')); ?>" data-toggle="fullscreen" class="dropdown-item">
                                Lista
                            </a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('devolucao_create')): ?>
                        <li>
                            <a href="<?php echo e(route('devolucao.xml')); ?>" data-toggle="fullscreen" class="dropdown-item">
                                Nova devolução
                            </a>
                        </li>
                        <?php endif; ?>

                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'PDV')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['pdv_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarPDV" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-shopping-cart-fill"></i>

                    <span>PDV</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarPDV">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pdv_view')): ?>
                        <li>
                            <a href="<?php echo e(route('frontbox.index')); ?>">Listar</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pdv_create')): ?>
                        <li class="d-none d-sm-inline-block">
                            <a href="<?php echo e(route('frontbox.create')); ?>" data-toggle="fullscreen" class="dropdown-item">PDV</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('troca_view')): ?>
                        <li>
                            <a href="<?php echo e(route('trocas.index')); ?>" data-toggle="fullscreen" class="dropdown-item">Trocas</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('config_tef_view')): ?>
                        <li>
                            <a href="<?php echo e(route('tef-registros.index')); ?>">Registros de TEF</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Vendas')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['nfe_view', 'orcamento_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarNfe" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-file-list-fill"></i>

                    <span>Vendas</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarNfe">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfe_view')): ?>
                        <li>
                            <a href="<?php echo e(route('nfe.index')); ?>">Listar</a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfe_create')): ?>
                        <li>
                            <a href="<?php echo e(route('nfe.create')); ?>">Nova</a>
                        </li>
                        <?php endif; ?>

                        <?php if(__isPlanoFiscal()): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfe_inutiliza')): ?>
                        <li>
                            <a href="<?php echo e(route('nfe.inutilizar')); ?>">Inutilizar NFe</a>
                        </li>
                        <?php endif; ?>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orcamento_view')): ?>
                        <li>
                            <a href="<?php echo e(route('orcamentos.index')); ?>">Orçamentos</a>
                        </li>
                        <?php endif; ?>

                        <?php if(__isPlanoFiscal()): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('arquivos_xml_view')): ?>
                        <li>
                            <a href="<?php echo e(route('nfe-xml.index')); ?>">Arquivos XML</a>
                        </li>
                        <?php endif; ?>
                        <?php endif; ?>

                        <li>
                            <a href="<?php echo e(route('nfe.import-zip')); ?>">Importar XML</a>
                        </li>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('metas_view')): ?>
                        <li>
                            <a href="<?php echo e(route('nfe.metas')); ?>">Metas</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Financeiro')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['conta_pagar_view', 'conta_receber_view', 'relatorio_view', 'caixa_view', 'contas_empresa_view', 'contas_boleto_view', 'boleto_view', 'taxa_pagamento_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarPagar" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-money-dollar-box-fill"></i>
                    <span>Financeiro</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarPagar">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('caixa_view')): ?>
                        <li>
                            <a data-bs-toggle="collapse" href="#caixa" aria-expanded="false" aria-controls="caixa">
                                <span> Caixa </span>
                                <span class="menu-arrow"></span>
                            </a>
                            <div class="collapse" id="caixa">
                                <ul class="side-nav-third-level">
                                    <li>
                                        <a href="<?php echo e(route('caixa.index')); ?>">Movimentação</a>
                                    </li>

                                    <li>
                                        <a href="<?php echo e(route('caixa.create')); ?>">Abrir caixa</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('caixa.list')); ?>">Listar</a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['conta_pagar_view', 'conta_pagar_create'])): ?>
                        <li>
                            <a data-bs-toggle="collapse" href="#pagar" aria-expanded="false" aria-controls="pagar">
                                <span> Contas a pagar </span>
                                <span class="menu-arrow"></span>
                            </a>
                            <div class="collapse" id="pagar">
                                <ul class="side-nav-third-level">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('conta_pagar_view')): ?>
                                    <li>
                                        <a href="<?php echo e(route('conta-pagar.index')); ?>">Listar</a>
                                    </li>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('conta_pagar_create')): ?>
                                    <li>
                                        <a href="<?php echo e(route('conta-pagar.create')); ?>">Nova conta</a>
                                    </li>
                                    <?php endif; ?>

                                </ul>
                            </div>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['conta_receber_view', 'conta_receber_create'])): ?>
                        <li>
                            <a data-bs-toggle="collapse" href="#receber" aria-expanded="false" aria-controls="receber">
                                <span> Contas a receber </span>
                                <span class="menu-arrow"></span>
                            </a>
                            <div class="collapse" id="receber">
                                <ul class="side-nav-third-level">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('conta_receber_view')): ?>
                                    <li>
                                        <a href="<?php echo e(route('conta-receber.index')); ?>">Listar</a>
                                    </li>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('conta_receber_create')): ?>
                                    <li>
                                        <a href="<?php echo e(route('conta-receber.create')); ?>">Nova conta</a>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('relatorio_view')): ?>
                        <li>
                            <a href="<?php echo e(route('relatorios.index')); ?>">Relatórios</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('taxa_pagamento_view')): ?>
                        <li>
                            <a href="<?php echo e(route('taxa-cartao.index')); ?>">Taxas de pagamento</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('plano_contas_view')): ?>
                        <li>
                            <a href="<?php echo e(route('plano-contas.index')); ?>">Plano de contas</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contas_empresa_view')): ?>
                        <li>
                            <a href="<?php echo e(route('contas-empresa.index')); ?>">Contas da empresa</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contas_boleto_view')): ?>
                        <li>
                            <a href="<?php echo e(route('contas-boleto.index')); ?>">Contas para boleto</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('boleto_view')): ?>
                        <li>
                            <a href="<?php echo e(route('boleto.index')); ?>">Boletos</a>
                        </li>
                        <?php endif; ?>

                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'NFCe')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['nfce_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarNfce" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-bill-line"></i>
                    <span>NFCe</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarNfce">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfce_view')): ?>
                        <li>
                            <a href="<?php echo e(route('nfce.index')); ?>">Listar</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfce_create')): ?>
                        <li>
                            <a href="<?php echo e(route('nfce.create')); ?>">Nova</a>
                        </li>
                        <?php endif; ?>

                        <?php if(__isPlanoFiscal()): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfce_inutiliza')): ?>
                        <li>
                            <a href="<?php echo e(route('nfce.inutilizar')); ?>">Inutilizar</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('arquivos_xml_view')): ?>
                        <li>
                            <a href="<?php echo e(route('nfce-xml.index')); ?>">Arquivos XML</a>
                        </li>
                        <?php endif; ?>
                        <?php endif; ?>

                        <li>
                            <a href="<?php echo e(route('nfce.import-zip')); ?>">Importar XML</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('nfce-contigencia.index')); ?>">Envio Contigência</a>
                        </li>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Pré venda')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['pre_venda_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarPreVenda" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class=" ri-list-ordered"></i>
                    <span>Pré Venda</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarPreVenda">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pre_venda_view')): ?>
                        <li>
                            <a href="<?php echo e(route('pre-venda.index')); ?>">Listar</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pre_venda_create')): ?>
                        <li>
                            <a href="<?php echo e(route('pre-venda.create')); ?>">Nova</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'NFSe')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['nfse_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarNfse" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-file-code-line"></i>

                    <span>NFSe</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarNfse">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfse_view')): ?>
                        <li>
                            <a href="<?php echo e(route('nota-servico.index')); ?>">Listar</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfse_create')): ?>
                        <li>
                            <a href="<?php echo e(route('nota-servico.create')); ?>">Nova</a>
                        </li>
                        <?php endif; ?>

                        <li>
                            <a href="<?php echo e(route('nota-servico-config.index')); ?>">Emitente</a>
                        </li>

                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Veiculos')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['veiculos_view', 'veiculos_create'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarVeiculos" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-roadster-line"></i>
                    <span> Veículos </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarVeiculos">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('veiculos_view')): ?>
                        <li>
                            <a href="<?php echo e(route('veiculos.index')); ?>">Listar</a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('veiculos_create')): ?>
                        <li>
                            <a href="<?php echo e(route('veiculos.create')); ?>">Novo Veículo</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Controle de Fretes')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['tipo_despesa_frete_view', 'frete_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarControleFrete" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-road-map-line"></i>
                    <span>Controle de Fretes</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarControleFrete">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tipo_despesa_frete_view')): ?>
                        <li>
                            <a href="<?php echo e(route('tipo-despesa-frete.index')); ?>">Tipos de despesa de frete</a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('frete_view')): ?>
                        <li>
                            <a href="<?php echo e(route('fretes.index')); ?>">Fretes</a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manutencao_veiculo_view')): ?>
                        <li>
                            <a href="<?php echo e(route('manutencao-veiculos.index')); ?>">Manutenção de veículos</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'CTe')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['cte_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarCte" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-truck-fill"></i>
                    <span>CTe</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarCte">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cte_view')): ?>
                        <li>
                            <a href="<?php echo e(route('cte.index')); ?>">Listar</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cte_create')): ?>
                        <li>
                            <a href="<?php echo e(route('cte.create')); ?>">Nova</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('arquivos_xml_view')): ?>
                        <li>
                            <a href="<?php echo e(route('cte-xml.index')); ?>">Arquivos XML</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['cte_os_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarCteOs" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-focus-3-line"></i>
                    <span>CTe Os</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarCteOs">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cte_os_view')): ?>
                        <li>
                            <a href="<?php echo e(route('cte-os.index')); ?>">Listar</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cte_os_create')): ?>
                        <li>
                            <a href="<?php echo e(route('cte-os.create')); ?>">Nova</a>
                        </li>
                        <?php endif; ?>

                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'MDFe')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['mdfe_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarMdfe" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-file-lock-line"></i>
                    <span>MDFe</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarMdfe">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mdfe_view')): ?>
                        <li>
                            <a href="<?php echo e(route('mdfe.index')); ?>">Listar</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mdfe_create')): ?>
                        <li>
                            <a href="<?php echo e(route('mdfe.create')); ?>">Nova</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('arquivos_xml_view')): ?>
                        <li>
                            <a href="<?php echo e(route('mdfe-xml.index')); ?>">Arquivos XML</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Cardapio')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cardapio_view')): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarCardapio" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-restaurant-2-line"></i>
                    <span>Cardápio</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarCardapio">
                    <ul class="side-nav-second-level">
                        <li>
                            <a href="<?php echo e(route('config-cardapio.index')); ?>">Configuração</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('produtos-cardapio.categorias')); ?>">Categorias</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('produtos-cardapio.index')); ?>">Produtos</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('categoria-adicional.index')); ?>">Categorias de adicional</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('adicionais.index')); ?>">Adicionais</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('pedidos-cardapio.index')); ?>">Comandas</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('pedido-cozinha.index')); ?>">Controle de pedidos</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('impressao-pedido.index')); ?>">Controle de impressão</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('carrossel.index')); ?>">Carrossel destaque</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('avaliacao-cardapio.index')); ?>">Avaliações</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('tamanhos-pizza.index')); ?>">Tamanhos de pizza</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('atendimento-garcom.index')); ?>">Atendimentos garçom</a>
                        </li>

                        <?php if(file_exists(public_path('app.apk'))): ?>
                        <li>
                            <a href="<?php echo e(route('config-cardapio.download')); ?>">Download APP</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(env("ECOMMERCE") == 1): ?>
            <?php if(__isActivePlan(Auth::user()->empresa, 'Ecommerce')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ecommerce_view')): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarEcommerce" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-store-3-line"></i>
                    <span> Ecommerce </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarEcommerce">
                    <ul class="side-nav-second-level">
                        <li>
                            <a href="<?php echo e(route('config-ecommerce.index')); ?>">Configuração</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('produtos-ecommerce.categorias')); ?>">Categorias de produtos</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('produtos-ecommerce.index')); ?>">Produtos</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('pedidos-ecommerce.index')); ?>">Pedidos</a>
                        </li>

                        <li>
                            <a target="_blank" href="<?php echo e(route('config-ecommerce.site')); ?>">Ver site</a>
                        </li>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(env("MERCADOLIVRE") == 1): ?>
            <?php if(__isActivePlan(Auth::user()->empresa, 'Mercado Livre')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mercado_livre_view')): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarMercadoLivre" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-box-1-line"></i>
                    <span> Mercado Livre </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarMercadoLivre">
                    <ul class="side-nav-second-level">

                        <li>
                            <a href="<?php echo e(route('mercado-livre-config.index')); ?>">Configuração</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('mercado-livre.produtos-news')); ?>">Produtos</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('mercado-livre-perguntas.index')); ?>">Perguntas</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('mercado-livre-pedidos.index')); ?>">Pedidos</a>
                        </li>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(env("WOOCOMMERCE") == 1): ?>
            <?php if(__isActivePlan(Auth::user()->empresa, 'Woocommerce')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('woocommerce_view')): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarWoocommerce" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-wordpress-fill"></i>
                    <span> Woocommerce </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarWoocommerce">
                    <ul class="side-nav-second-level">

                        <li>
                            <a href="<?php echo e(route('woocommerce-config.index')); ?>">Configuração</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('woocommerce-categorias.index')); ?>">Categorias</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('woocommerce-produtos.index')); ?>">Produtos</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('woocommerce-pedidos.index')); ?>">Pedidos</a>
                        </li>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(env("NUVEMSHOP") == 1): ?>
            <?php if(__isActivePlan(Auth::user()->empresa, 'Nuvem Shop')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nuvem_shop_view')): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarNuvemShop" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-cloud-line"></i>
                    <span> Nuvem Shop </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarNuvemShop">
                    <ul class="side-nav-second-level">

                        <li>
                            <a href="<?php echo e(route('nuvem-shop-config.index')); ?>">Configuração</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('nuvem-shop-categorias.index')); ?>">Categorias</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('nuvem-shop-produtos.index')); ?>">Produtos</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('nuvem-shop-pedidos.index')); ?>">Pedidos</a>
                        </li>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(env("MARKETPLACE") == 1): ?>
            <?php if(__isActivePlan(Auth::user()->empresa, 'Delivery')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delivery_view')): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarMarketPlace" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-store-2-line"></i>
                    <span>Delivery/Marketplace</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarMarketPlace">
                    <ul class="side-nav-second-level">

                        <li>
                            <a href="<?php echo e(route('config-marketplace.index')); ?>">Configuração</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('pedidos-delivery.index')); ?>">Pedidos</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('produtos-delivery.categorias')); ?>">Categorias de produto</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('servico-marketplace.categorias')); ?>">Categorias de serviço</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('produtos-delivery.index')); ?>">Produtos</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('servicos-marketplace.index')); ?>">Serviços</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('funcionamento-delivery.index')); ?>">Funcionamento</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('bairros-empresa.index')); ?>">Bairros</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('categoria-adicional.index')); ?>">Categorias de adicional</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('adicionais.index')); ?>">Adicionais</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('destaque-marketplace.index')); ?>">Destaques</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('cupom-desconto.index')); ?>">Cupom de desconto</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('tamanhos-pizza.index')); ?>">Tamanhos de pizza</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('motoboys.index')); ?>">Motoboys</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('pedido-cozinha.index')); ?>">Controle de pedidos</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('impressao-pedido.index')); ?>">Controle de impressão</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('clientes-delivery.index')); ?>">Clientes</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('config-agendamento.index')); ?>">Configuração de agendamento</a>
                        </li>
                        <li>
                            <a target="_blank" href="<?php echo e(route('config-marketplace.loja')); ?>">Ver loja</a>
                        </li>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Localizações')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['localizacao_view'])): ?>
            <li class="side-nav-item" id="step5">
                <a data-bs-toggle="collapse" href="#sidebarLocalizacao" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-building-4-line"></i>
                    <span>Localizações</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarLocalizacao">
                    <ul class="side-nav-second-level">
                        <li>
                            <a href="<?php echo e(route('localizacao.index')); ?>">Listar</a>
                        </li>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(env("RESERVAS") == 1): ?>
            <?php if(__isActivePlan(Auth::user()->empresa, 'Reservas')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['categoria_acomodacao_view', 'config_reserva_view', 'reserva_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarReservas" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-hotel-line"></i>
                    <span> Reservas </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarReservas">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('config_reserva_view')): ?>
                        <li>
                            <a href="<?php echo e(route('config-reserva.index')); ?>">Configuração</a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categoria_acomodacao_view')): ?>
                        <li>
                            <a href="<?php echo e(route('categoria-acomodacao.index')); ?>">Categorias de acomodação</a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('acomodacao_view')): ?>
                        <li>
                            <a href="<?php echo e(route('acomodacao.index')); ?>">Acomodações</a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('frigobar_view')): ?>
                        <li>
                            <a href="<?php echo e(route('frigobar.index')); ?>">Frigobares</a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reserva_view')): ?>
                        <li>
                            <a href="<?php echo e(route('reservas.index')); ?>">Reservas</a>
                        </li>
                        <?php endif; ?>
                        <li>
                            <a href="<?php echo e(route('produtos-reserva.index')); ?>">Produtos</a>
                        </li>

                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(env("IFOOD") == 1): ?>
            <?php if(__isActivePlan(Auth::user()->empresa, 'IFood')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['ifood_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarIfood" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <img src="/icons/ifood.png" class="icon-menu">
                    <span> IFood </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarIfood">
                    <ul class="side-nav-second-level">
                        <li>
                            <a href="<?php echo e(route('ifood-config.index')); ?>">Configuração</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('ifood-config-loja.index')); ?>">Configuração da loja</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('ifood-catalogos.index')); ?>">Catálogos</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('ifood-categoria-produtos.index')); ?>">Categorias de Produto</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('ifood-produtos.index')); ?>">Produtos</a>
                        </li>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'CRM')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['crm_view'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarCrm" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-user-voice-fill"></i>
                    <span> CRM </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarCrm">
                    <ul class="side-nav-second-level">
                        <li>
                            <a href="<?php echo e(route('crm.index')); ?>">Listar</a>
                        </li>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if(__isActivePlan(Auth::user()->empresa, 'Sped')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['sped_config_view', 'sped_create'])): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarSped" aria-expanded="false" aria-controls="sidebarPages" class="side-nav-link">
                    <i class="ri-book-fill"></i>
                    <span> Sped </span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarSped">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sped_config_view')): ?>
                        <li>
                            <a href="<?php echo e(route('sped-config.index')); ?>">Configuração</a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sped_create')): ?>
                        <li>
                            <a href="<?php echo e(route('sped.index')); ?>">Arquivo</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['natureza_operacao_view', 'emitente_view'])): ?>
            <li class="side-nav-item" id="step5">
                <a data-bs-toggle="collapse" href="#sidebarConfig" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-settings-4-fill"></i>
                    <span>Configuração</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarConfig">
                    <ul class="side-nav-second-level">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('emitente_view')): ?>
                        <li>
                            <a href="<?php echo e(route('config.index')); ?>">Emitente</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('natureza_operacao_view')): ?>
                        <li>
                            <a href="<?php echo e(route('natureza-operacao.index')); ?>">Natureza de operação</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('email_config_view')): ?>
                        <li>
                            <a href="<?php echo e(route('email-config.index')); ?>">Configuração de email</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('escritorio_contabil_view')): ?>
                        <li>
                            <a href="<?php echo e(route('escritorio-contabil.index')); ?>">Escritório contábil</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('emitente_view')): ?>
                        <li>
                            <a href="<?php echo e(route('config-geral.create')); ?>">Geral</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('difal_view')): ?>
                        <li>
                            <a href="<?php echo e(route('difal.index')); ?>">Op. Interestadual - Difal</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cashback_config_view')): ?>
                        <li>
                            <a href="<?php echo e(route('cash-back-config.index')); ?>">CashBack</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contigencia_view')): ?>
                        <li>
                            <a href="<?php echo e(route('contigencia.index')); ?>">Contigência</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('config_tef_view')): ?>
                        <li>
                            <a href="<?php echo e(route('tef-config.index')); ?>">TEF</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('config_api')): ?>
                        <li>
                            <a href="<?php echo e(route('config-api.index')); ?>">API</a>
                        </li>
                        <?php endif; ?>

                        <li>
                            <a href="<?php echo e(route('sintegra.index')); ?>">Sintegra</a>
                        </li>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('metas_view')): ?>
                        <li>
                            <a href="<?php echo e(route('metas.index')); ?>">Configuração de metas</a>
                        </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('impressora_pedido_view')): ?>
                        <li>
                            <a href="<?php echo e(route('impressoras-pedido.index')); ?>">Impressoras de pedido</a>
                        </li>
                        <?php endif; ?>
                        
                    </ul>
                </div>
            </li>
            <?php endif; ?>

            <?php endif; ?>

            <?php if(Auth::user()->empresa && __isContador()): ?>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarCad" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-draft-fill"></i>
                    <span>Cadastros</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarCad">
                    <ul class="side-nav-second-level">
                        <li>
                            <a href="<?php echo e(route('contador-empresa.produtos')); ?>">Produtos</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('contador-empresa.clientes')); ?>">Clientes</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('contador-empresa.fornecedores')); ?>">Fornecedores</a>
                        </li>
                    </ul>
                </div>
            </li>
            <li class="side-nav-item">
                <a data-bs-toggle="collapse" href="#sidebarDoc" aria-expanded="false" aria-controls="sidebarIcons" class="side-nav-link">
                    <i class="ri-clipboard-fill"></i>
                    <span>Documentos</span>
                    <span class="menu-arrow"></span>
                </a>
                <div class="collapse" id="sidebarDoc">
                    <ul class="side-nav-second-level">
                        <li>
                            <a href="<?php echo e(route('contador-empresa.nfe')); ?>">NFe</a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('contador-empresa.nfce')); ?>">NFCe</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('contador-empresa.cte')); ?>">CTe</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('contador-empresa.mdfe')); ?>">MDFe</a>
                        </li>
                    </ul>
                </div>
            </li>
            <?php endif; ?>
        </ul>
    </div>
</div>
<?php /**PATH /www/wwwroot/erp.royalsistema.com.br/resources/views/layouts/menu/vertical.blade.php ENDPATH**/ ?>