<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('clientes_create')): ?>
                    <a href="<?php echo e(route('clientes.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Novo Cliente
                    </a>
                    
                    <a href="<?php echo e(route('clientes.import')); ?>" class="btn btn-info pull-right">
                        <i class="ri-file-upload-line"></i>
                        Upload
                    </a>
                    <?php endif; ?>

                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-3">
                            <?php echo Form::text('razao_social', 'Pesquisar por nome'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::text('cpf_cnpj', 'Pesquisar por CPF/CNPJ')
                            ->attrs(['class' => 'cpf_cnpj'])
                            ->type('tel'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial cadastro'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final cadastro'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::select('ordem', 'Ordenar por', ['razao_social' => 'Razão social', 'numero_sequencial' => 'Código', 'created_at' => 'Data de cadastro'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <div class="col-md-3 text-left ">
                            <br>

                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('clientes.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3 table-responsive">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('clientes_delete')): ?>
                                    <th>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input" type="checkbox" id="select-all-checkbox">
                                        </div>
                                    </th>
                                    <?php endif; ?>
                                    <th>#</th>
                                    <th>Razão Social</th>
                                    <th>CPF/CNPJ</th>
                                    <th>Cidade</th>
                                    <th>Endereço</th>
                                    <th>CEP</th>
                                    <th>Status</th>
                                    <th>Data de cadastro</th>
                                    <th width="10%">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('clientes_delete')): ?>
                                    <td>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input check-delete" type="checkbox" name="item_delete[]" value="<?php echo e($item->id); ?>">
                                        </div>
                                    </td>
                                    <?php endif; ?>
                                    <td><?php echo e($item->numero_sequencial); ?></td>
                                    <td width="500"><?php echo e($item->razao_social); ?></td>
                                    <td><?php echo e($item->cpf_cnpj); ?></td>
                                    <td><?php echo e($item->cidade ? $item->cidade->info : ''); ?></td>
                                    <td><?php echo e($item->rua ? $item->endereco : '--'); ?></td>
                                    <td><?php echo e($item->cep); ?></td>
                                    <td>
                                        <?php if($item->status): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(__data_pt($item->created_at)); ?></td>
                                    <td>
                                        <form action="<?php echo e(route('clientes.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>" style="width: 230px;">
                                            <?php echo method_field('delete'); ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('clientes_edit')): ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('clientes.edit', [$item->id])); ?>">
                                                <i class="ri-pencil-fill"></i>
                                            </a>
                                            <?php endif; ?>

                                            <?php echo csrf_field(); ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('clientes_delete')): ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <?php endif; ?>

                                            <a title="Informações de cashBack" class="btn btn-dark btn-sm" href="<?php echo e(route('clientes.cash-back', [$item->id])); ?>">
                                                <i class="ri-coins-fill"></i>
                                            </a>

                                            <a title="Histórico" class="btn btn-primary btn-sm" href="<?php echo e(route('clientes.historico', [$item->id])); ?>">
                                                <i class="ri-file-list-3-fill"></i>
                                            </a>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crm_create')): ?>
                                            <button type="button" title="CRM" class="btn btn-light btn-sm" onclick="modalCrm('<?php echo e($item->id); ?>')">
                                                <i class="ri-user-voice-fill"></i>
                                            </button>
                                            <?php endif; ?>

                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <br>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('clientes_delete')): ?>
                        <form action="<?php echo e(route('clientes.destroy-select')); ?>" method="post" id="form-delete-select">
                            <?php echo method_field('delete'); ?>
                            <?php echo csrf_field(); ?>
                            <div></div>
                            <button type="button" class="btn btn-danger btn-sm btn-delete-all" disabled>
                                <i class="ri-close-circle-line"></i> Remover selecionados
                            </button>
                        </form>
                        <?php endif; ?>
                    </div>
                </div>
                <br>
                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('modals._crm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="/js/delete_selecionados.js"></script>
<script type="text/javascript">
    function modalCrm(cliente_id){
        $('#cliente_id').val(cliente_id)
        $('#modal_crm').modal('show')
        montaSelect2()
    }
</script>
<script type="text/javascript" src="/js/modal_crm.js"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Clientes'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/erp.royalsistema.com.br/resources/views/clientes/index.blade.php ENDPATH**/ ?>