<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('estoque_create')): ?>
                    <div class="col-md-2">
                        <a href="<?php echo e(route('estoque.create')); ?>" class="btn btn-success">
                            <i class="ri-add-circle-fill"></i>
                            Adicionar estoque
                        </a>
                    </div>
                    <div class="col-md-10"  style="text-align: right;">
                        <a href="<?php echo e(route('apontamento.create')); ?>" class="btn btn-info">
                            <i class="ri-settings-3-line"></i>
                            Apontamento Produção
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-3">
                            <?php echo Form::text('produto', 'Pesquisar por produto'); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::select('categoria_id', 'Categoria', ['' => 'Selecione'] + $categorias->pluck('nome', 'id')->all())
                            ->attrs(['class' => 'form-select']); ?>

                        </div>

                        <?php if(__countLocalAtivo() > 1): ?>
                        <div class="col-md-2">
                            <?php echo Form::select('local_id', 'Local', ['' => 'Selecione'] + __getLocaisAtivoUsuario()->pluck('descricao', 'id')->all())
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        <?php endif; ?>
                        <div class="col-md-3 text-left ">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('estoque.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th></th>
                                    <th>#</th>
                                    <th>Produto</th>
                                    <th>Categoria</th>
                                    <th>Quantidade</th>
                                    <th>Valor de venda</th>
                                    <th>Unidade</th>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <th>Local</th>
                                    <?php endif; ?>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><img class="img-60" src="<?php echo e($item->produto->img); ?>"></td>
                                    <td><?php echo e($item->produto->numero_sequencial); ?></td>
                                    <td>
                                        <?php echo e($item->descricao()); ?>

                                    </td>
                                    <td><?php echo e($item->produto->categoria ? $item->produto->categoria->nome : ''); ?></td>
                                    <td>
                                        <?php if(!$item->produto->unidadeDecimal()): ?>
                                        <?php echo e(number_format($item->quantidade, 0)); ?>

                                        <?php else: ?>
                                        <?php echo e(number_format($item->quantidade, 3, '.', '')); ?>

                                        <?php endif; ?>
                                        <!-- <?php if(__countLocalAtivo() == 1): ?>

                                        <?php if(!$item->produto->unidadeDecimal()): ?>
                                        <?php echo e(number_format($item->quantidade, 0)); ?>

                                        <?php else: ?>
                                        <?php echo e(number_format($item->quantidade, 3, '.', '')); ?>

                                        <?php endif; ?>

                                        <?php else: ?>

                                        <?php $__currentLoopData = $item->produto->estoqueLocais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($e->local): ?>
                                        <?php echo e($e->local->descricao); ?>:
                                        <strong class="text-success">
                                            <?php if(!$item->produto->unidadeDecimal()): ?>
                                            <?php echo e(number_format($e->quantidade, 0)); ?>

                                            <?php else: ?>
                                            <?php echo e(number_format($e->quantidade, 3)); ?>

                                            <?php endif; ?>
                                        </strong>
                                        <?php endif; ?>
                                        <?php if(!$loop->last): ?> | <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <?php endif; ?> -->
                                    </td>
                                    <td><?php echo e(__moeda($item->produto->valor_unitario)); ?></td>
                                    <td><?php echo e($item->produto->unidade); ?></td>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <th><?php echo e($item->local->descricao); ?></th>
                                    <?php endif; ?>
                                    <td style="width: 300px">
                                        <form action="<?php echo e(route('estoque.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('estoque_edit')): ?>
                                            <a title="Editar estoque" href="<?php echo e(route('estoque.edit', [$item->id])); ?>" class="btn btn-dark btn-sm">
                                                <i class="ri-pencil-fill"></i>
                                            </a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('produtos_edit')): ?>
                                            <a title="Editar produto" href="<?php echo e(route('produtos.edit', [$item->produto_id])); ?>" class="btn btn-warning btn-sm">
                                                <i class="ri-pencil-fill"></i>
                                            </a>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('estoque_delete')): ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <?php endif; ?>

                                        </form>

                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <br>
                <?php echo $data->appends(request()->all())->links(); ?>


            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Estoque'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/erp.royalsistema.com.br/resources/views/estoque/index.blade.php ENDPATH**/ ?>