<div class="row g-2">

    <div class="col-md-3">
        {!! Form::text('cliente', 'Nome do cliente')->required() !!}
    </div>

    <div class="col-md-3">
        {!! Form::text('cpf_cnpj', 'CPF / CNPJ do cliente')->attrs(['class' => 'cpf_cnpj'])->required() !!}
    </div>

    <div class="col-md-3">
        {!! Form::text('valor', 'Valor da cobrança')->attrs(['class' => 'moeda'])->required() !!}
    </div>

    <div class="col-md-3">
        {!! Form::text('whatsapp', 'Whatsapp')->required() !!}
    </div>

    <div class="col-md-3">
        {!! Form::text('titulo', 'Título')->required() !!}
    </div>

    <div class="col-md-2">
        {!! Form::select('status', 'Status', ['1' => 'Ativo', '0' => 'Desativado'])->attrs(['class' => 'form-select'])->required() !!}
    </div>

    <div class="col-md-2">
        {!! Form::select('recorrente', 'Recorrente', ['1' => 'Sim', '0' => 'Não'])->attrs(['class' => 'form-select'])->required() !!}
    </div>

    <div class="col-md-3">
        {!! Form::select('gateway', 'Gateway', [
            '' => 'Selecione',
            'pay_mundi' => 'Pay Mundi',
            'onz_finance' => 'K1 Bank',
        ])->attrs(['class' => 'form-select'])->required() !!}
    </div>

    <div class="col-md-3">
        {!! Form::text('dias_antes_vencimento', 'Dias antes vencimento')->required() !!}
        <small>Separe por ; pra que seja por período de dias (Exemplo 5;3;2)</small>
    </div>

    <div class="col-md-3">
        {!! Form::text('dias_apos_vencimento', 'Dias após vencimento')->required() !!}
        <small>Separe por ; pra que seja por período de dias (Exemplo 5;3;2)</small>
    </div>

    <div class="col-md-3">
        {!! Form::date('data_vencimento', 'Data vencimento')->required() !!}
    </div>

    <hr class="mt-4">
    <div class="col-12" style="text-align: right;">
        <button type="submit" class="btn btn-success px-5" id="btn-store">Salvar</button>
    </div>
</div>

@section('js')

    <script type="text/javascript">
        $(function() {
            var behavior = function(val) {
                    return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
                },
                options = {
                    onKeyPress: function(val, e, field, options) {
                        field.mask(behavior.apply({}, arguments), options);
                    }
                };

            $('input[name="whatsapp"]').mask(behavior, options);
            $('input[name="cpf').mask('000.000.000-00', {
                reverse: true
            });
        })
    </script>
@endsection
