@extends('layouts.app', ['title' => 'CRM - Kanban'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="col-12">
            <a href="{{ route('crm.index', request()->all()) }}" class="btn btn-secondary mb-3">
                <i class="ri-list-check-2"></i> Voltar para lista
            </a>
        </div>
    </div>
    <div class="row g-3">
        @php
            $statusList = [
                'positivo' => 'Positivo',
                'bom' => 'Bom',
                'negativo' => 'Negativo',
            ];
            $colors = [
                'positivo' => 'success',
                'bom' => 'warning',
                'negativo' => 'danger',
            ];
        @endphp
        @foreach($statusList as $statusKey => $statusLabel)
        <div class="col-md-4">
            <div class="card border-{{ $colors[$statusKey] }}">
                <div class="card-header bg-{{ $colors[$statusKey] }} text-white text-center">
                    <b>{{ $statusLabel }}</b>
                </div>
                <div class="card-body kanban-col" style="min-height: 400px; background: #f8f9fa;" id="kanban-col-{{ $statusKey }}">
                    @foreach($data->where('status', $statusKey) as $item)
                        <div class="card mb-3 shadow-sm" data-id="{{ $item->id }}">
                            <div class="card-body p-2">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <span class="badge bg-{{ $colors[$statusKey] }}">{{ $statusLabel }}</span>
                                    </div>
                                    <div>
                                        <small class="text-muted">{{ __data_pt($item->created_at) }}</small>
                                    </div>
                                </div>
                                <hr class="my-2">
                                <div>
                                    <b>Cliente:</b> {{ $item->cliente ? $item->cliente->info : '--' }}<br>
                                    <b>Assunto:</b> {{ $item->assunto }}<br>
                                    <b>Conclusão:</b> {{ $item->conclusao }}
                                </div>
                                <div class="mt-2 d-flex gap-1">
                                    @if($item->estado != 'aprovada')
                                        @can('crm_edit')
                                        <a class="btn btn-warning btn-sm" href="{{ route('crm.edit', $item->id) }}">
                                            <i class="ri-edit-line"></i>
                                        </a>
                                        @endcan
                                        @can('crm_delete')
                                        <form action="{{ route('crm.destroy', $item->id) }}" method="post" style="display:inline;">
                                            @method('delete')
                                            @csrf
                                            <button type="submit" class="btn btn-danger btn-sm"><i class="ri-delete-bin-line"></i></button>
                                        </form>
                                        @endcan
                                    @endif
                                    <a title="Ver resposta" class="btn btn-primary btn-sm" href="{{ route('crm.show', $item->id) }}">
                                        <i class="ri-eye-2-line"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endforeach
    </div>
</div>
@endsection
@section('js')
<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const statusList = ['positivo', 'bom', 'negativo'];
        statusList.forEach(function(status) {
            new Sortable(document.getElementById('kanban-col-' + status), {
                group: 'kanban',
                animation: 150,
                onAdd: function (evt) {
                    const card = evt.item;
                    const anotacaoId = card.getAttribute('data-id');
                    const newStatus = status;
                    // AJAX para atualizar status
                    fetch("{{ route('crm.kanban.status') }}", {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        body: JSON.stringify({ id: anotacaoId, status: newStatus })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if(data.success){
                            location.reload(); // Recarrega a página ao mover o card com sucesso
                        } else {
                            alert('Erro ao atualizar status!');
                        }
                    })
                    .catch(() => alert('Erro ao atualizar status!'));
                }
            });
        });
    });
</script>
@endsection 