<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NotificacaoCobrancaHistorico extends Model
{
    use HasFactory;

    protected $table = 'notificacao_cobranca_historico';

    protected $fillable = [
        'notificacao_cobranca_id',
        'empresa_id',
        'status',
        'pix_copia_cola',
        'mensagem',
        'externo_id',
        'gateway',
    ];

    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'empresa_id');
    }

    public function notificacaoCobranca()
    {
        return $this->belongsTo(NotificacaoCobranca::class, 'notificacao_cobranca_id');
    }
}
