<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NotificacaoCobrancaConfig extends Model
{
    use HasFactory;

    protected $table = 'notificacao_cobrancas_config';

    protected $fillable = [
        'empresa_id',
        'public_key_cashin_paymundi',
        'public_key_cashout_paymundi',
        'secret_key_cashin_paymundi',
        'secret_key_cashout_paymundi',
        'client_id_onz',
        'client_secret_onz',
        'crt_onz',
        'pfx_onz',
        'key_onz',
        'senha_onz',
        'frase_cobranca',
        'access_token_onz',
        'expires_in_onz',
        'chave_pix'
    ];

    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'empresa_id');
    }
}
