<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Module;
use App\Models\Tenant;
use App\Models\RoleModule;
use App\Enums\UserRole;

class ModuleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $modules = [
            [
                'name' => 'clients',
                'label' => 'Clientes',
                'description' => 'Gerenciamento de clientes',
            ],
            [
                'name' => 'products',
                'label' => 'Produtos',
                'description' => 'Gerenciamento de produtos',
            ],
            [
                'name' => 'orders',
                'label' => 'Pedidos',
                'description' => 'Gerenciamento de pedidos',
            ],
            [
                'name' => 'reports',
                'label' => 'Relatórios',
                'description' => 'Relatórios e dashboards',
            ],
            [
                'name' => 'users',
                'label' => 'Usuários',
                'description' => 'Gerenciamento de usuários',
            ],
            [
                'name' => 'marcas',
                'label' => 'Marcas',
                'description' => 'Gerenciamento de marcas',
            ],
            [
                'name' => 'modelos',
                'label' => 'Modelos',
                'description' => 'Gerenciamento de modelos',
            ],
            [
                'name' => 'categorias',
                'label' => 'Categorias',
                'description' => 'Gerenciamento de categorias',
            ],
        ];

        // Criar os módulos
        foreach ($modules as $module) {
            Module::create($module);
        }

        // Criar permissões para os gerentes de cada tenant
        $tenants = Tenant::all();
        $allModules = Module::all();

        foreach ($tenants as $tenant) {
            // Encontrar o usuário gerente do tenant
            $gerente = $tenant->users()->where('role', UserRole::GERENTE->value)->first();
            
            if ($gerente) {
                // Dar acesso a todos os módulos para o gerente
                foreach ($allModules as $module) {
                    RoleModule::create([
                        'role' => UserRole::GERENTE->value,
                        'module_id' => $module->id,
                        'tenant_id' => $tenant->id
                    ]);
                }
            }
        }
    }
}
