<?php

namespace App\Filament\User\Resources;

use App\Filament\User\Resources\ModuleResource\Pages;
use App\Filament\User\Resources\ModuleResource\RelationManagers;
use App\Models\Module;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Hidden;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Section;
use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Tables\Actions\DeleteAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\IconColumn;



class ModuleResource extends Resource
{
    public static function shouldRegisterNavigation(): bool
    {
        return auth()->user()->role === \App\Enums\UserRole::GERENTE;
    }
    protected static ?string $model = Module::class;

    protected static ?string $navigationIcon = 'heroicon-o-cog-8-tooth';
    protected static ?string $navigationGroup = 'Configurações';
    protected static ?int $navigationSort = 1;
    protected static ?string $pluralLabel = 'Módulos';


    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('name')
                    ->label('Nome Técnico')
                    ->required()
                    ->maxLength(255)
                    ->unique(ignoreRecord: true),
                TextInput::make('label')
                    ->label('Nome de Exibição')
                    ->required()
                    ->maxLength(255),
                Textarea::make('description')
                    ->label('Descrição')
                    ->maxLength(65535),
                Toggle::make('is_active')
                    ->label('Ativo')
                    ->default(true),
                Section::make('Permissões por Perfil')
                    ->schema([
                        Repeater::make('roles')
                            ->relationship()
                            ->schema([
                                Select::make('role')
                                    ->label('Perfil')
                                    ->options(\App\Enums\UserRole::class)
                                    ->required(),
                                Hidden::make('tenant_id')
                                    ->default(fn () => auth()->user()->tenant_id),
                            ])
                            ->defaultItems(0)
                            ->addActionLabel('Adicionar Permissão')
                            ->deletable(auth()->user()->role === \App\Enums\UserRole::ADMIN)
                    ])
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')
                    ->label('Nome Técnico')
                    ->searchable(),
                TextColumn::make('label')
                    ->label('Nome de Exibição')
                    ->searchable(),
                IconColumn::make('is_active')
                    ->label('Ativo')
                    ->boolean(),
                TextColumn::make('roles.role')
                    ->label('Perfis com Acesso')
                    ->badge()
            ])
            ->filters([
                //
            ])
            ->actions([
                EditAction::make()
                ->tooltip('Editar')
                    ->iconButton()
                    ->color('warning')
                    ->icon('heroicon-o-pencil-square'),
                DeleteAction::make()
                ->tooltip('Excluir')
                    ->iconButton()
                    ->color('danger')
                    ->icon('heroicon-o-trash')
                    ->modalHeading('Excluir Módulo')
                    ->modalDescription('Tem certeza que deseja excluir este módulo? Esta ação não poderá ser desfeita.')
                    ->modalSubmitActionLabel('Sim, excluir')
                    ->modalCancelActionLabel('Não, cancelar')
            ])
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make()
                        ->label('Excluir Selecionados')
                        ->modalHeading('Excluir Módulos Selecionados')
                        ->modalDescription('Tem certeza que deseja excluir os módulos selecionados? Esta ação não poderá ser desfeita.')
                        ->modalSubmitActionLabel('Sim, excluir')
                        ->modalCancelActionLabel('Não, cancelar')
                        ->successNotification(null)
                        ->after(function() {
                            Notification::make()
                                ->success()
                                ->color('success')
                                ->icon('heroicon-o-check-circle')
                                ->title('Módulos excluídos!')
                                ->body('Os módulos foram removidos com sucesso')
                                ->send();
                        })
                ])
                ->label('Ações em massa'),
            ]);
            
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListModules::route('/'),
            'create' => Pages\CreateModule::route('/create'),
            'edit' => Pages\EditModule::route('/{record}/edit'),
        ];
    }
}
