<?php

namespace App\Filament\User\Resources;

use App\Filament\User\Resources\ModeloResource\Pages;
use App\Filament\User\Resources\ModeloResource\RelationManagers;
use App\Models\Modelo;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\TextInput;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Tables\Actions\DeleteAction;  
use Filament\Notifications\Notification;
use Filament\Actions\Action;
use Filament\Forms\Components\Select;

class ModeloResource extends Resource
{
    protected static ?string $model = Modelo::class;
    // aqui controle de visibilidade do menu 
    protected static ?string $navigationIcon = 'heroicon-o-bookmark-square';
    protected static ?string $navigationGroup = 'Cadastros';
    protected static ?int $navigationSort = 4;
    protected static ?string $pluralLabel = 'Modelos';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('nome')
                    ->required(),
                // PEGA APENAS O TENANT DO USUARIO LOGADO
                Select::make('tenant_id')
                    ->label('Empresa do Cliente')
                    ->relationship('tenant', 'name', fn ($query) => $query->where('id', auth()->user()->tenant_id))
                    ->required()
                    ->preload()
                    ->searchable()
                    ->default(auth()->user()->tenant_id)
                    ->disabled()
                    ->dehydrated(), // NAO PODE SER ALTERADO
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
        // pega apenas os clientes do tenant do usuario logado
        ->modifyQueryUsing(fn (Builder $query) => $query->where('tenant_id', auth()->user()->tenant_id))
            ->columns([
                TextColumn::make('nome')
                    ->searchable(),
                TextColumn::make('tenant.name')
                    ->label('Empresa')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('created_at')
                    ->label('Data de Criação')
                    ->dateTime('d/m/Y')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: false),
            ])
            ->filters([
                //
            ])
            ->actions([
                EditAction::make()
                ->tooltip('Editar')
                    ->iconButton()
                    ->color('warning')
                    ->icon('heroicon-o-pencil-square'),
                DeleteAction::make()
                ->tooltip('Excluir')
                    ->iconButton()
                    ->color('danger')
                    ->icon('heroicon-o-trash')
                    ->modalHeading('Excluir Modelo')
                    ->modalDescription('Tem certeza que deseja excluir esta marca? Esta ação não poderá ser desfeita.')
                    ->modalSubmitActionLabel('Sim, excluir')
                    ->modalCancelActionLabel('Não, cancelar')
            ])
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make()
                        ->label('Excluir Selecionados')
                        ->modalHeading('Excluir Modelos Selecionados')
                        ->modalDescription('Tem certeza que deseja excluir os modelos selecionados? Esta ação não poderá ser desfeita.')
                        ->modalSubmitActionLabel('Sim, excluir')
                        ->modalCancelActionLabel('Não, cancelar')
                        ->successNotification(null)
                        ->after(function() {
                            Notification::make()
                                ->success()
                                ->color('success')
                                ->icon('heroicon-o-check-circle')
                                ->title('Modelos excluídos!')
                                ->body('Os modelos foram removidos com sucesso')
                                ->send();
                        })
                ])
                ->label('Ações em massa'),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListModelos::route('/'),
            'create' => Pages\CreateModelo::route('/create'),
            'edit' => Pages\EditModelo::route('/{record}/edit'),
        ];
    }
}
