<?php

namespace App\Filament\User\Resources\ClientResource\Pages;
 
use App\Filament\User\Resources\ClientResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Filament\Actions\Action;
use Filament\Notifications\Notification;
 
class EditClient extends EditRecord
{
    protected function getSavedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->color('success')
            ->icon('heroicon-o-check-circle')
            ->title('Atualizado!')
            ->body('Cliente atualizado com sucesso')
            ->duration(5000);
    }

    protected static string $resource = ClientResource::class;

    // botao salvar
    protected function getSaveFormAction(): Action
    {
        return parent::getSaveFormAction()
            ->label('Salvar Cliente')
            ->icon('heroicon-o-check')
            ->color('success');
    }

    // botao cancelar
    protected function getCancelFormAction(): Action
    {
        return parent::getCancelFormAction()
            ->label('Cancelar')
            ->icon('heroicon-o-x-mark')
            ->color('warning');
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    // mensagem de sucesso
    protected function getUpdatedNotificationTitle(): ?string
    {
        return 'Cliente atualizado!';
    }

    protected function getUpdatedNotificationDescription(): ?string
    {
        return 'As informações do cliente foram atualizadas com sucesso.';
    }

    protected function getUpdatedNotificationIcon(): ?string
    {
        return 'heroicon-o-check-circle';
    }

    protected function getUpdatedNotificationColor(): ?string
    {
        return 'success';
    }

    protected function getUpdatedNotificationActions(): ?array
    {
        return [
            Actions\ViewAction::make()
                ->label('Visualizar Cliente'),
        ];
    }
}
