<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}
require_once '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $installment_id = filter_input(INPUT_POST, 'installment_id', FILTER_SANITIZE_NUMBER_INT);
    $payment_date = filter_input(INPUT_POST, 'payment_date', FILTER_SANITIZE_STRING);

    try {
        // Atualizar status da parcela
        $stmt = $pdo->prepare("
            UPDATE installments 
            SET status = 'paid', payment_date = ? 
            WHERE id = ? AND status != 'paid'
        ");
        $stmt->execute([$payment_date, $installment_id]);

        if ($stmt->rowCount() > 0) {
            header('Location: index.php?success=payment_received');
        } else {
            header('Location: index.php?error=already_paid');
        }
        exit;
    } catch (PDOException $e) {
        header('Location: index.php?error=payment_failed');
        exit;
    }
}

header('Location: index.php');
exit;
