<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}
require_once '../config/database.php';

// Função para log
function debug_log($message) {
    error_log(print_r($message, true));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    debug_log("Dados recebidos:");
    debug_log($_POST);

    $client_id = filter_input(INPUT_POST, 'client_id', FILTER_SANITIZE_NUMBER_INT);
    $description = filter_input(INPUT_POST, 'description', FILTER_SANITIZE_STRING);
    $total_amount = filter_input(INPUT_POST, 'total_amount', FILTER_SANITIZE_STRING);
    $installments = filter_input(INPUT_POST, 'installments', FILTER_SANITIZE_NUMBER_INT);
    $movement_date = filter_input(INPUT_POST, 'movement_date', FILTER_SANITIZE_STRING);

    debug_log("Dados após filtro:");
    debug_log([
        'client_id' => $client_id,
        'description' => $description,
        'total_amount' => $total_amount,
        'installments' => $installments,
        'movement_date' => $movement_date
    ]);

    // Converter valor total para formato do banco
    $total_amount = str_replace('.', '', $total_amount);
    $total_amount = str_replace(',', '.', $total_amount);

    // Calcular valor da parcela
    $installment_amount = $total_amount / $installments;

    debug_log("Valor total convertido: " . $total_amount);
    debug_log("Valor da parcela: " . $installment_amount);

    try {
        $pdo->beginTransaction();

        // Inserir movimento
        $stmt = $pdo->prepare("
            INSERT INTO movements 
            (user_id, client_id, description, total_amount, installments, installment_amount, movement_date) 
            VALUES 
            (?, ?, ?, ?, ?, ?, ?)
        ");
        
        debug_log("Executando insert do movimento");
        $result = $stmt->execute([
            $_SESSION['user_id'],
            $client_id,
            $description,
            $total_amount,
            $installments,
            $installment_amount,
            $movement_date
        ]);
        debug_log("Resultado do insert do movimento: " . ($result ? "sucesso" : "falha"));
        
        if (!$result) {
            debug_log("Erro no insert do movimento:");
            debug_log($stmt->errorInfo());
            throw new PDOException("Erro ao inserir movimento");
        }

        $movement_id = $pdo->lastInsertId();
        debug_log("ID do movimento criado: " . $movement_id);

        // Criar parcelas
        $stmt = $pdo->prepare("
            INSERT INTO installments 
            (movement_id, installment_number, amount, due_date, status) 
            VALUES 
            (?, ?, ?, ?, 'pending')
        ");
        
        debug_log("Criando parcelas");
        for ($i = 1; $i <= $installments; $i++) {
            $due_date = date('Y-m-d', strtotime($movement_date . " +$i month"));
            $result = $stmt->execute([$movement_id, $i, $installment_amount, $due_date]);
            
            if (!$result) {
                debug_log("Erro ao criar parcela $i:");
                debug_log($stmt->errorInfo());
                throw new PDOException("Erro ao criar parcela $i");
            }
            debug_log("Parcela $i criada com sucesso");
        }

        $pdo->commit();
        debug_log("Transação finalizada com sucesso");
        header('Location: index.php?success=created');
        exit;
    } catch (PDOException $e) {
        $pdo->rollBack();
        debug_log("Erro na transação:");
        debug_log($e->getMessage());
        header('Location: index.php?error=creation_failed');
        exit;
    }
}

header('Location: index.php');
exit;
