<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode([]);
    exit;
}

require_once '../config/database.php';

if (isset($_GET['movement_id'])) {
    $movement_id = filter_input(INPUT_GET, 'movement_id', FILTER_SANITIZE_NUMBER_INT);

    // Atualizar status das parcelas vencidas
    $pdo->query("
        UPDATE installments 
        SET status = 'overdue' 
        WHERE status = 'pending' 
        AND due_date < CURDATE()
    ");

    // Buscar parcelas do movimento
    $stmt = $pdo->prepare("
        SELECT 
            id,
            installment_number,
            amount,
            due_date,
            status,
            paid_at
        FROM installments 
        WHERE movement_id = ? 
        ORDER BY installment_number
    ");
    
    $stmt->execute([$movement_id]);
    $installments = $stmt->fetchAll(PDO::FETCH_ASSOC);

    header('Content-Type: application/json');
    echo json_encode($installments);
    exit;
}

header('Content-Type: application/json');
echo json_encode([]);
exit;
