<?php
require_once __DIR__ . '/../config/database.php';

try {
    // Verificar e criar tabela de movimentos se não existir
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS movements (
            id INT AUTO_INCREMENT PRIMARY KEY,
            client_id INT NOT NULL,
            description VARCHAR(255) NOT NULL,
            total_amount DECIMAL(10,2) NOT NULL,
            installments INT NOT NULL,
            created_at DATETIME NOT NULL,
            FOREIGN KEY (client_id) REFERENCES clients(id)
        )
    ");
    echo "Tabela movements verificada/criada com sucesso!\n";

    // Verificar e criar tabela de parcelas se não existir
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS installments (
            id INT AUTO_INCREMENT PRIMARY KEY,
            movement_id INT NOT NULL,
            installment_number INT NOT NULL,
            amount DECIMAL(10,2) NOT NULL,
            due_date DATE NOT NULL,
            status ENUM('pending', 'paid', 'overdue') NOT NULL DEFAULT 'pending',
            paid_at DATETIME NULL,
            FOREIGN KEY (movement_id) REFERENCES movements(id) ON DELETE CASCADE
        )
    ");
    echo "Tabela installments verificada/criada com sucesso!\n";

    // Verificar se a tabela clients existe
    $stmt = $pdo->query("SHOW TABLES LIKE 'clients'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("
            CREATE TABLE clients (
                id INT AUTO_INCREMENT PRIMARY KEY,
                name VARCHAR(255) NOT NULL,
                email VARCHAR(255),
                phone VARCHAR(20),
                monthly_fee DECIMAL(10,2),
                created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP
            )
        ");
        echo "Tabela clients criada com sucesso!\n";
    }

    // Verificar estrutura das tabelas
    echo "\nEstrutura atual das tabelas:\n";
    
    $tables = ['movements', 'installments', 'clients'];
    foreach ($tables as $table) {
        $stmt = $pdo->query("DESCRIBE $table");
        echo "\nTabela $table:\n";
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            echo "- {$row['Field']}: {$row['Type']} {$row['Null']} {$row['Key']} {$row['Default']}\n";
        }
    }

} catch (PDOException $e) {
    echo "Erro: " . $e->getMessage() . "\n";
}
