<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}
require_once '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = filter_input(INPUT_POST, 'name', FILTER_SANITIZE_STRING);
    $email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
    $phone = filter_input(INPUT_POST, 'phone', FILTER_SANITIZE_STRING);
    $monthly_fee = filter_input(INPUT_POST, 'monthly_fee', FILTER_SANITIZE_STRING);
    
    // Converter valor da mensalidade para formato do banco
    $monthly_fee = str_replace('.', '', $monthly_fee);
    $monthly_fee = str_replace(',', '.', $monthly_fee);

    try {
        $stmt = $pdo->prepare("INSERT INTO clients (user_id, name, email, phone, monthly_fee) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$_SESSION['user_id'], $name, $email, $phone, $monthly_fee]);
        
        header('Location: index.php?success=created');
        exit;
    } catch (PDOException $e) {
        header('Location: index.php?error=creation_failed');
        exit;
    }
}

header('Location: index.php');
exit;
