@extends('relatorios.default', ['title' => 'Relatório de Contas a Pagar'])

@section('css')
<style type="text/css">
    .summary-container {
        display: flex;
        flex-wrap: nowrap;
        justify-content: space-between;
        gap: 6px;
        margin-bottom: 12px;
        width: 100%;
    }

    .summary-box {
        flex: 0 0 33.3333%;
        background-color: #f9fbfc;
        border-left: 4px solid #ccc;
        border-radius: 4px;
        padding: 6px 8px;
        font-size: 8px;
        text-align: center;
        box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05);
        min-width: 0;
    }

    .summary-title {
        font-weight: bold;
        color: #333;
        margin-bottom: 4px;
        text-transform: uppercase;
        font-size: 8px;
    }

    .summary-value {
        font-size: 10px;
        font-weight: bold;
    }

    .summary-box.pago {
        border-left-color: #28a745;
    }

    .summary-box.apagar {
        border-left-color: #007bff;
    }

    .summary-box.vencido {
        border-left-color: #dc3545;
    }

    .summary-box.pago .summary-value {
        color: #28a745;
    }

    .summary-box.apagar .summary-value {
        color: #007bff;
    }

    .summary-box.vencido .summary-value {
        color: #dc3545;
    }

    .pagamentos-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 8px;
    }

    .pagamentos-table th, .pagamentos-table td {
        border: 1px solid #ddd;
        padding: 3px 5px;
        vertical-align: middle;
    }

    .pagamentos-table th {
        background-color: #f1f1f1;
        font-weight: bold;
        text-transform: uppercase;
        color: #2c3e50;
    }

    .pagamentos-table tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    .status-pendente {
        color: #856404;
        background-color: #fff3cd;
        padding: 2px 5px;
        border-radius: 3px;
        font-weight: bold;
        font-size: 7px;
    }

    .status-quitado {
        color: #155724;
        background-color: #d4edda;
        padding: 2px 5px;
        border-radius: 3px;
        font-weight: bold;
        font-size: 7px;
    }

    .text-right { text-align: right; }
    .text-center { text-align: center; }
</style>
@endsection

@section('content')

@php
    $totalPago = $data->where('status', '>', 0)->sum('valor_integral');
    $totalAPagar = $data->where('status', 0)->sum('valor_integral');
    $totalVencidas = $data->where('status', 0)->where('data_vencimento', '<', date('Y-m-d'))->sum('valor_integral');
@endphp

<div class="summary-container">
    <div class="summary-box pago">
        <div class="summary-title">Total Pago</div>
        <div class="summary-value">{{ __moeda($totalPago) }}</div>
    </div>
    <div class="summary-box apagar">
        <div class="summary-title">Total a Pagar</div>
        <div class="summary-value">{{ __moeda($totalAPagar) }}</div>
    </div>
    <div class="summary-box vencido">
        <div class="summary-title">Vencidas</div>
        <div class="summary-value">{{ __moeda($totalVencidas) }}</div>
    </div>
</div>

<table class="pagamentos-table">
    <thead>
        <tr>
            <th style="width: 32%">Fornecedor</th>
            <th style="width: 15%" class="text-right">Valor</th>
            <th style="width: 15%" class="text-center">Vencimento</th>
            <th style="width: 12%" class="text-center">Status</th>
            @if(__countLocalAtivo() > 1)
            <th style="width: 12%">Local</th>
            @endif
        </tr>
    </thead>
    <tbody>
        @foreach($data as $item)
        <tr>
            <td>{{ $item->fornecedor?->razao_social ?? '--' }}</td>
            <td class="text-right">{{ __moeda($item->valor_integral) }}</td>
            <td class="text-center">{{ __data_pt($item->data_vencimento, 0) }}</td>
            <td class="text-center">
                <span class="{{ $item->status == 0 ? 'status-pendente' : 'status-quitado' }}">
                    {{ $item->status == 0 ? 'Pendente' : 'Quitado' }}
                </span>
            </td>
            @if(__countLocalAtivo() > 1)
            <td>{{ $item->localizacao->descricao }}</td>
            @endif
        </tr>
        @endforeach
    </tbody>
</table>

@endsection
