@extends('layouts.landing')

@section('content')
<!-- Hero Section -->
<section class="hero-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 col-md-12" data-aos="fade-right">
                <span class="badge mb-3">Sistema ERP para Pequenas Empresas</span>
                <h1 class="hero-title">Simplifique a Gestão da sua Empresa</h1>
                <p class="hero-subtitle">O melhor sistema ERP para pequenas empresas e MEIs. Controle financeiro, estoque, emissão de notas fiscais (NFe/NFCe) e PDV em uma única plataforma.</p>
                <div class="d-flex flex-wrap gap-3">
                    <a href="#contato" class="btn btn-outline-primary">
                        <i class="ri-whatsapp-line"></i>Falar com Consultor
                    </a>
                </div>
            </div>
            <div class="col-lg-6 col-md-12" data-aos="fade-left">
                <picture class="d-block">
                    <source srcset="{{ asset('imgs/optimized/Dashboard.webp') }}" type="image/webp">
                    <source srcset="{{ asset('imgs/optimized/Dashboard.avif') }}" type="image/avif">
                    <img src="{{ asset('imgs/optimized/Dashboard.png') }}" alt="Dashboard do Sistema ERP {{ env('APP_NAME') }}" class="img-fluid" width="600" height="400" loading="lazy" style="max-width: 100%; height: auto;">
                </picture>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="py-4">
    <div class="container">
        <div class="row g-4">
            <div class="col-lg-4 col-md-6 col-12" data-aos="fade-up">
                <div class="stats-card">
                    <div class="stats-icon">
                        <i class="ri-user-line"></i>
                    </div>
                    <div class="stats-number">350+</div>
                    <p class="stats-label">Usuários Ativos</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 col-12" data-aos="fade-up" data-aos-delay="100">
                <div class="stats-card">
                    <div class="stats-icon">
                        <i class="ri-file-list-3-line"></i>
                    </div>
                    <div class="stats-number">10.000+</div>
                    <p class="stats-label">Notas Emitidas</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 col-12" data-aos="fade-up" data-aos-delay="200">
                <div class="stats-card">
                    <div class="stats-icon">
                        <i class="ri-exchange-dollar-line"></i>
                    </div>
                    <div class="stats-number">25.000+</div>
                    <p class="stats-label">Transações Realizadas</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Showcase Section -->
<section class="py-5" id="showcase">
    <div class="container">
        <div class="section-title text-center mb-5">
            <span class="badge bg-primary bg-opacity-10 text-primary mb-2">
                <i class="ri-code-line me-2"></i>Interface Moderna
            </span>
            <h2>Conheça o Sistema</h2>
            <p>Interface moderna e intuitiva para sua empresa</p>
        </div>

        <div class="modern-container system-showcase">
            <!-- Primeira Linha -->
            <div class="row g-4 mb-4">
                <div class="col-12 col-lg-8" data-aos="fade-right">
                    <div class="showcase-item position-relative">
                        <img src="/imgs/Dashboard_1.png" alt="Dashboard" class="img-fluid rounded-4 w-100 h-auto" 
                            style="max-height: 600px; object-fit: contain;" 
                            data-bs-toggle="modal" data-bs-target="#imageModal"
                            onclick="showImageModal(this.src, 'Dashboard')">
                    </div>
                </div>
                <div class="col-12 col-lg-4" data-aos="fade-left">
                    <div class="showcase-item position-relative">
                        <img src="/imgs/iMPRESSAO PDV.png" alt="Impressão PDV" class="img-fluid rounded-4 w-100 h-auto" 
                            style="max-height: 300px; object-fit: contain;"
                            data-bs-toggle="modal" data-bs-target="#imageModal"
                            onclick="showImageModal(this.src, 'Impressão PDV')">
                    </div>
                </div>
            </div>

            <!-- Segunda Linha -->
            <div class="row g-4 mb-4">
                <div class="col-12 col-md-4" data-aos="fade-up">
                    <div class="showcase-item position-relative">
                        <img src="/imgs/PRODUTOS.png" alt="Produtos" class="img-fluid rounded-4 w-100 h-auto" 
                            style="max-height: 300px; object-fit: contain;"
                            data-bs-toggle="modal" data-bs-target="#imageModal"
                            onclick="showImageModal(this.src, 'Produtos')">
                    </div>
                </div>
                <div class="col-12 col-md-4" data-aos="fade-up" data-aos-delay="100">
                    <div class="showcase-item position-relative">
                        <img src="/imgs/RELATORIO ESTOQUE.png" alt="Relatório de Estoque" class="img-fluid rounded-4 w-100 h-auto" 
                            style="max-height: 300px; object-fit: contain;"
                            data-bs-toggle="modal" data-bs-target="#imageModal"
                            onclick="showImageModal(this.src, 'Relatório de Estoque')">
                    </div>
                </div>
                <div class="col-12 col-md-4" data-aos="fade-up" data-aos-delay="200">
                    <div class="showcase-item position-relative">
                        <img src="/imgs/FECHAMENTO PDV.png" alt="Fechamento de Caixa" class="img-fluid rounded-4 w-100 h-auto" 
                            style="max-height: 300px; object-fit: contain;"
                            data-bs-toggle="modal" data-bs-target="#imageModal"
                            onclick="showImageModal(this.src, 'Fechamento de Caixa')">
                    </div>
                </div>
            </div>

            <!-- Terceira Linha -->
            <div class="row g-4">
                <div class="col-12 col-md-6" data-aos="fade-up">
                    <div class="showcase-item position-relative">
                        <img src="/imgs/PDV_1.png" alt="PDV" class="img-fluid rounded-4 w-100 h-auto" 
                            style="max-height: 400px; object-fit: contain;"
                            data-bs-toggle="modal" data-bs-target="#imageModal"
                            onclick="showImageModal(this.src, 'PDV')">
                    </div>
                </div>
                <div class="col-12 col-md-6" data-aos="fade-up" data-aos-delay="100">
                    <div class="showcase-item position-relative">
                        <img src="/imgs/RELATORIO ESTOQUE.png" alt="Gestão de Estoque" class="img-fluid rounded-4 w-100 h-auto" 
                            style="max-height: 400px; object-fit: contain;"
                            data-bs-toggle="modal" data-bs-target="#imageModal"
                            onclick="showImageModal(this.src, 'Gestão de Estoque')">
                    </div>
                </div>
            </div>

            <!-- Terceira Linha -->
            <div class="row g-4">
                <div class="col-12 col-md-6" data-aos="fade-up">
                    <div class="showcase-item position-relative">
                        <img src="/imgs/Comandas.png" alt="PDV" class="img-fluid rounded-4 w-100 h-auto" 
                            style="max-height: 400px; object-fit: contain;"
                            data-bs-toggle="modal" data-bs-target="#imageModal"
                            onclick="showImageModal(this.src, 'Gestão de Comandas/Mesas')">
                    </div>
                </div>
                <div class="col-12 col-md-6" data-aos="fade-up" data-aos-delay="100">
                    <div class="showcase-item position-relative">
                        <img src="/imgs/Estoque_Movimento.png" alt="Gestão de Estoque" class="img-fluid rounded-4 w-100 h-auto" 
                            style="max-height: 400px; object-fit: contain;"
                            data-bs-toggle="modal" data-bs-target="#imageModal"
                            onclick="showImageModal(this.src, 'Movimento de Estoque')">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Modal para Visualização de Imagens -->
<div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content bg-transparent border-0">
            <div class="modal-header border-0">
                <h5 class="modal-title text-white" id="imageModalLabel"></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center p-0">
                <img src="" id="modalImage" class="img-fluid rounded-4" style="max-height: 90vh; width: auto;">
            </div>
        </div>
    </div>
</div>

<!-- Estilos CSS Adicionais -->
<style>
.showcase-item {
    position: relative;
    overflow: hidden;
    border-radius: 1rem;
    transition: all 0.3s ease;
    cursor: pointer;
}

.showcase-item:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 20px rgba(0,0,0,0.1);
}

.showcase-item img {
    transition: transform 0.3s ease;
}

.showcase-item:hover img {
    transform: scale(1.02);
}

/* Estilos para o Modal */
.modal-backdrop.show {
    opacity: 0.9;
}

        /* Ajustes Mobile */
        @media (max-width: 768px) {
            .showcase-item {
                margin-bottom: 1rem;
            }
            
            .hero-section {
                padding: 4rem 0 2rem !important;
            }
            
            .section-title {
                margin-bottom: 2rem !important;
            }
            
            .modern-container {
                padding: 2rem 1rem !important;
            }
            
            .showcase-item img {
                border-radius: 12px !important;
            }
            
            .stats-card {
                text-align: center;
            }
            
            .feature-list li {
                font-size: 0.95rem !important;
                padding: 0.5rem 0 !important;
            }
            
            .card-icon {
                width: 50px !important;
                height: 50px !important;
                font-size: 1.5rem !important;
            }
        }
        
        @media (max-width: 576px) {
            .hero-section {
                padding: 3rem 0 1.5rem !important;
            }
            
            .section-title {
                margin-bottom: 1.5rem !important;
            }
            
            .modern-container {
                padding: 1.5rem 0.75rem !important;
            }
            
            .showcase-item {
                margin-bottom: 0.75rem !important;
            }
            
            .feature-list li {
                font-size: 0.9rem !important;
                padding: 0.4rem 0 !important;
            }
            
            .card-icon {
                width: 45px !important;
                height: 45px !important;
                font-size: 1.25rem !important;
            }
            
            .modern-card h4 {
                font-size: 1.25rem !important;
            }
        }
</style>

<!-- Script para o Modal -->
<script>
function showImageModal(src, title) {
    document.getElementById('modalImage').src = src;
    document.getElementById('imageModalLabel').textContent = title;
}

// Ajuste de altura das imagens em mobile
function adjustImageHeights() {
    const showcaseImages = document.querySelectorAll('.showcase-item img');
    
    showcaseImages.forEach(img => {
        if (window.innerWidth <= 576) {
            img.style.maxHeight = '180px';
        } else if (window.innerWidth <= 768) {
            img.style.maxHeight = '200px';
        } else if (window.innerWidth <= 1024) {
            img.style.maxHeight = '250px';
        } else {
            img.style.maxHeight = '300px';
        }
    });
}

// Otimizações para dispositivos móveis
function mobileOptimizations() {
    if (window.innerWidth <= 768) {
        // Desabilitar animações hover em dispositivos touch
        document.querySelectorAll('.modern-card, .showcase-item, .stats-card').forEach(element => {
            element.style.transition = 'none';
        });
        
        // Ajustar espaçamentos
        document.querySelectorAll('.section-title').forEach(title => {
            title.style.marginBottom = '2rem';
        });
    }
}

window.addEventListener('load', function() {
    adjustImageHeights();
    mobileOptimizations();
});

window.addEventListener('resize', function() {
    adjustImageHeights();
    mobileOptimizations();
});

// Otimização para orientação landscape em mobile
window.addEventListener('orientationchange', function() {
    setTimeout(function() {
        adjustImageHeights();
        mobileOptimizations();
    }, 100);
});
</script>

<!-- Recursos Section -->
<section id="recursos" class="py-5">
    <div class="container">
        <div class="section-title" data-aos="fade-up">
            <span class="badge">Recursos Completos</span>
            <h2>Sistema de Gestão Completo para sua Empresa</h2>
            <p>Tudo que sua pequena empresa ou MEI precisa para uma gestão eficiente e profissional.</p>
        </div>

        <div class="row g-4">
            <!-- Controle Financeiro -->
            <div class="col-lg-4 col-md-6 col-12" data-aos="fade-up">
                <div class="modern-card h-100">
                    <div class="card-icon bg-gradient-1">
                        <i class="ri-refund-2-fill"></i>
                    </div>
                    <h4>Controle Financeiro</h4>
                    <ul class="feature-list">
                        <li><i class="ri-check-line"></i>Contas a pagar e receber</li>
                        <li><i class="ri-check-line"></i>Fluxo de caixa automatizado</li>
                        <li><i class="ri-check-line"></i>Conciliação bancária</li>
                        <li><i class="ri-check-line"></i>DRE e relatórios gerenciais</li>
                    </ul>
                </div>
            </div>

            <!-- Emissão de Notas -->
            <div class="col-lg-4 col-md-6 col-12" data-aos="fade-up" data-aos-delay="100">
                <div class="modern-card h-100">
                   <div class="card-icon bg-gradient-warning">
                        <i class="ri-file-list-3-line"></i>
                    </div>
                    <h4>Emissão de Notas Fiscais</h4>
                    <ul class="feature-list">
                        <li><i class="ri-check-line"></i>NFe e NFCe integradas</li>
                        <li><i class="ri-check-line"></i>Emissão automática</li>
                        <li><i class="ri-check-line"></i>Gestão de impostos</li>
                        <li><i class="ri-check-line"></i>Certificado digital A1</li>
                    </ul>
                </div>
            </div>

            <!-- Controle de Estoque -->
            <div class="col-lg-4 col-md-6 col-12" data-aos="fade-up" data-aos-delay="200">
                <div class="modern-card h-100">
                    <div class="card-icon bg-gradient-info">
                        <i class=" ri-layout-masonry-line"></i>
                    </div>
                    <h4>Controle de Estoque</h4>
                    <ul class="feature-list">
                        <li><i class="ri-check-line"></i>Gestão de produtos</li>
                        <li><i class="ri-check-line"></i>Controle de entrada/saída</li>
                        <li><i class="ri-check-line"></i>Inventário automático</li>
                        <li><i class="ri-check-line"></i>Alertas de estoque baixo</li>
                    </ul>
                </div>
            </div>

            <!-- PDV -->
            <div class="col-lg-4 col-md-6 col-12" data-aos="fade-up" data-aos-delay="300">
                <div class="modern-card h-100">
                    <div class="card-icon bg-gradient-warning">
                        <i class="ri-shopping-cart-line"></i>
                    </div>
                    <h4>PDV (Ponto de Venda)</h4>
                    <ul class="feature-list">
                        <li><i class="ri-check-line"></i>Vendas rápidas</li>
                        <li><i class="ri-check-line"></i>Controle de caixa</li>
                        <li><i class="ri-check-line"></i>Múltiplas formas de pagamento</li>
                        <li><i class="ri-check-line"></i>Emissão de NFCe integrada</li>
                    </ul>
                </div>
            </div>

            <!-- Ordens de Serviço -->
            <div class="col-lg-4 col-md-6 col-12" data-aos="fade-up" data-aos-delay="400">
                <div class="modern-card h-100">
                <div class="card-icon bg-gradient-warning">
                        <i class="ri-tools-line"></i>
                    </div>
                    <h4>Ordens de Serviço</h4>
                    <ul class="feature-list">
                        <li><i class="ri-check-line"></i>Gestão de serviços</li>
                        <li><i class="ri-check-line"></i>Agendamento</li>
                        <li><i class="ri-check-line"></i>Status em tempo real</li>
                        <li><i class="ri-check-line"></i>Histórico de atendimentos</li>
                    </ul>
                </div>
            </div>

            <!-- Relatórios -->
            <div class="col-lg-4 col-md-6 col-12" data-aos="fade-up" data-aos-delay="500">
                <div class="modern-card h-100">
                    <div class="card-icon bg-gradient-success">
                        <i class="ri-line-chart-line"></i>
                    </div>
                    <h4>Relatórios Gerenciais</h4>
                    <ul class="feature-list">
                        <li><i class="ri-check-line"></i>Dashboard personalizado</li>
                        <li><i class="ri-check-line"></i>Análise de vendas</li>
                        <li><i class="ri-check-line"></i>Lucratividade</li>
                        <li><i class="ri-check-line"></i>Indicadores de desempenho</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Integrações Section -->
<section class="py-5" id="integracoes">
    <div class="container">
        <div class="section-title text-center mb-5">
            <span class="badge bg-primary bg-opacity-10 text-primary mb-2">
                <i class="ri-plug-line me-2"></i>Integrações
            </span>
            <h2>Conecte-se com as Principais Plataformas</h2>
            <p>Integração completa com os principais marketplaces e meios de pagamento</p>
        </div>

        <div class="row g-4 justify-content-center">
            <div class="col-6 col-md-3 col-lg-3" data-aos="fade-up">
                <div class="modern-card text-center">
                    <img src="/imgs/WooCommerce_logo.svg.png" alt="WooCommerce" class="img-fluid mb-3" style="height: 50px; object-fit: contain;">
                    <h5 class="mb-0">WooCommerce</h5>
                </div>
            </div>
            <div class="col-6 col-md-3 col-lg-3" data-aos="fade-up" data-aos-delay="100">
                <div class="modern-card text-center">
                    <img src="/imgs/mercado-livre-logo-0-1.png" alt="Mercado Livre" class="img-fluid mb-3" style="height: 50px; object-fit: contain;">
                    <h5 class="mb-0">Mercado Livre</h5>
                </div>
            </div>
            <div class="col-6 col-md-3 col-lg-3" data-aos="fade-up" data-aos-delay="200">
                <div class="modern-card text-center">
                    <img src="/imgs/Nuvemshop-logo.png" alt="Nuvem Shop" class="img-fluid mb-3" style="height: 50px; object-fit: contain;">
                    <h5 class="mb-0">Nuvem Shop</h5>
                </div>
            </div>
            <div class="col-6 col-md-3 col-lg-3" data-aos="fade-up" data-aos-delay="300">
                <div class="modern-card text-center">
                    <img src="/imgs/mercado pago.png" alt="Mercado Pago" class="img-fluid mb-3" style="height: 50px; object-fit: contain;">
                    <h5 class="mb-0">Mercado Pago</h5>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-5" style="background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 text-center" data-aos="fade-up">
                <span class="badge bg-primary bg-opacity-10 text-primary mb-3" style="font-size: 1rem;">
                    <i class="ri-rocket-line me-2"></i>Comece Agora
                </span>
                <h2 class="display-5 fw-bold mb-4">Pronto para Começar?</h2>
                <p class="lead text-muted mb-4">
                    Descubra como podemos ajudar seu negócio a crescer.
                </p>
                <div class="d-flex gap-3 justify-content-center flex-wrap">
                    <a href="{{ route('login') }}" class="btn btn-outline-primary">
                        <i class="ri-login-circle-line"></i>Acessar Sistema
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Contato Section -->
<section id="contato" class="py-5 bg-light">
    <div class="container">
        <div class="section-title" data-aos="fade-up">
            <span class="badge">Fale Conosco</span>
            <h2>Comece Agora Mesmo</h2>
            <p>Teste grátis por 15 dias o melhor sistema ERP para pequenas empresas. Sem compromisso e com suporte completo.</p>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-8 text-center" data-aos="fade-up">
                <div class="d-flex flex-wrap justify-content-center gap-3 mb-4">
                    <a href="https://api.whatsapp.com/send?phone=%205584996662713&text=Olá%2C+vim+pelo+site.%0AQuero+saber+mais+sobre+os+planos." target="_blank" class="btn btn-outline-primary" onclick="return gtag_report_conversion(this.href);">
                        <i class="ri-whatsapp-line"></i>
                        (84) 99666-2713
                    </a>
                </div>
                <p class="text-muted">Atendimento de segunda a sexta, das 8h às 18h</p>
            </div>
        </div>
    </div>
</section>

<!-- Formulário Section -->
<section class="py-5" style="background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8" data-aos="fade-up">
                <div class="modern-card">
                    <div class="section-title text-center mb-4">
                        <span class="badge bg-primary bg-opacity-10 text-primary mb-2">
                            <i class="ri-mail-send-line me-2"></i>Fale Conosco
                        </span>
                        <h2>Quer saber mais?</h2>
                        <p>Preencha o formulário e nossa equipe entrará em contato</p>
                    </div>
                    <form action="{{ route('leads.store') }}" method="POST">
                        @csrf
                        <div class="mb-4">
                            <label class="form-label">Nome</label>
                            <input type="text" class="form-control form-control-lg" name="name" required>
                        </div>
                        <div class="mb-4">
                            <label class="form-label">E-mail</label>
                            <input type="email" class="form-control form-control-lg" name="email" required>
                        </div>
                        <div class="mb-4">
                            <label class="form-label">Telefone</label>
                            <input type="tel" class="form-control form-control-lg" name="phone" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="ri-send-plane-line"></i>Enviar Mensagem
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection 