@extends('layouts.app', ['title' => 'Histórico de Recebimentos'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-header">
                <h4>Histórico de Recebimentos</h4>
                <div style="text-align: right; margin-top: -35px;">
                    <a href="{{ route('financeiro-plano.index') }}" class="btn btn-danger btn-sm px-3">
                        <i class="ri-arrow-left-double-fill"></i>Voltar
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="alert alert-success">
                            <h5>Total Recebido: {{ __moeda($totalRecebido) }}</h5>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="alert alert-primary">
                            <h5>Total Repasse: {{ __moeda($totalRepasse) }}</h5>
                        </div>
                    </div>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    {!!Form::open()->fill(request()->all())
                    ->get()
                    !!}

                    <div class="row mt-3">
                        <div class="col-md-3">
                            {!!Form::select('empresa', 'Pesquisar por empresa')
                            ->options($empresa ? [$empresa->id => $empresa->info] : [])
                            !!}
                        </div>
                        <div class="col-md-2">
                            {!!Form::select('revenda', 'Pesquisar por revenda', ['' => 'Todas'] + $revendas->pluck('nome', 'id')->toArray())
                            ->attrs(['class' => 'select2'])
                            ->value(request()->get('revenda'))
                            !!}
                        </div>
                        <div class="col-md-2">
                            {!!Form::date('start_date', 'Data de pagamento inicial')
                            !!}
                        </div>
                        <div class="col-md-2">
                            {!!Form::date('end_date', 'Data de pagamento final')
                            !!}
                        </div>
                        <div class="col-md-3 text-left ">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="{{ route('financeiro-plano.historico-recebimentos') }}"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    {!!Form::close()!!}
                    
                    @if(request()->get('revenda'))
                    <div class="mt-3">
                        <form action="{{ route('financeiro-plano.sincronizar-repasse') }}" method="POST">
                            @csrf
                            <input type="hidden" name="revenda" value="{{ request()->get('revenda') }}">
                            <button type="submit" class="btn btn-warning">
                                <i class="ri-refresh-line"></i> Sincronizar Valores de Repasse
                            </button>
                            <small class="text-muted ms-2">
                                Atualiza recebimentos sem valor de repasse com os valores do financeiro
                            </small>
                        </form>
                    </div>
                    @endif
                </div>
                <div class="col-md-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-centered">
                            <thead class="table-dark">
                                <tr>
                                    <th>Empresa</th>
                                    <th>Plano</th>
                                    <th>Revenda</th>
                                    <th>Data do Pagamento</th>
                                    <th>Valor Pago</th>
                                    <th>Valor Repasse</th>
                                    <th>Forma de Pagamento</th>
                                    <th>Registrado por</th>
                                    <th>Observação</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($recebimentos as $item)
                                <tr>
                                    <td>{{ $item->financeiroPlano->empresa->info }}</td>
                                    <td>{{ $item->financeiroPlano->plano->nome }}</td>
                                    <td>{{ $item->financeiroPlano->revenda ? $item->financeiroPlano->revenda->nome : '-' }}</td>
                                    <td>{{ __data_pt($item->data_pagamento, 0) }}</td>
                                    <td>{{ __moeda($item->valor_pago) }}</td>
                                    <td>{{ $item->valor_repasse ? __moeda($item->valor_repasse) : '-' }}</td>
                                    <td>{{ $item->forma_pagamento }}</td>
                                    <td>{{ $item->usuario ? $item->usuario->name : 'Sistema' }}</td>
                                    <td>{{ $item->observacao }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-4">
                        {{ $recebimentos->appends(request()->except('page'))->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
    $(document).ready(function(){
        $('.select2').select2({
            placeholder: "Selecione"
        });
    });
</script>
@endsection 