@extends('layouts.app', ['title' => 'Fechando caixa'])
@section('content')

<div class="card mt-1">
    <div class="card-header">
        <h4>Fechar Caixa</h4>
        @if($item->contaEmpresa)
        <h6 class="text-danger">{{ $item->contaEmpresa->nome }}</h6>
        @endif
        <div style="text-align: right; margin-top: -35px;">
            <a href="{{ route('caixa.index') }}" class="btn btn-danger btn-sm px-3">
                <i class="ri-arrow-left-double-fill"></i>Voltar
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Seção de informações do valor em caixa -->
        <div class="alert alert-info mb-4">
            <h5 class="alert-heading">Valor em Caixa: R$ {{ __moeda($valorEmCaixa) }}</h5>
            <p class="mb-1">Este valor é calculado considerando:</p>
            <ul class="mb-0 ps-3">
                <li>Suprimentos</li>
                <li>Vendas recebidas (excluindo crediário, boleto bancário e crédito loja)</li>
                <li>Movimentações de Recebimentos (contas recebidas)</li>
                <li>Sangrias (subtraído)</li>
            </ul>
        </div>
        
        {!!Form::open()
        ->post()
        ->route('caixa.fechar-tipos-pagamento', [$item->id])
        !!}
        <div class="pl-lg-4">
            @include('caixa._listar_pagamentos')
        </div>
        {!!Form::close()!!}
    </div>
</div>

@if(isset($data))
    @php
        $vendasCanceladas = collect($data)->where('estado', 'cancelado');
    @endphp
    @if($vendasCanceladas->count() > 0)
        <div class="alert alert-warning mt-4">
            <h5 class="alert-heading">Vendas Canceladas neste Caixa</h5>
            <table class="table table-bordered table-sm mb-0">
                <thead>
                    <tr>
                        <th>Número</th>
                        <th>Cliente</th>
                        <th>Valor</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($vendasCanceladas as $venda)
                        <tr>
                            <td>{{ $venda->numero_sequencial ?? $venda->id }}</td>
                            <td>{{ $venda->cliente->razao_social ?? $venda->cliente_nome ?? '--' }}</td>
                            <td>R$ {{ __moeda($venda->total) }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif
@endif
@endsection

@section('js')
<script type="text/javascript" src="/js/controla_conta_empresa.js"></script>
<script type="text/javascript" src="/js/conta_empresa.js"></script>
@endsection
