/**
 * Script para substituir as imagens de logo por texto estilizado
 * que se adapta automaticamente aos temas claro e escuro
 */
document.addEventListener('DOMContentLoaded', function() {
    // Encontrar todas as imagens de logo existentes
    const logoImages = document.querySelectorAll('img.logo-painel');
    
    logoImages.forEach(function(img) {
        // Verificar se a imagem é de avatar de usuário (não substituir)
        const isUserAvatar = img.classList.contains('rounded-circle') || 
            (img.parentElement && (
                img.parentElement.classList.contains('account-user-avatar') ||
                img.parentElement.classList.contains('rounded-circle')
            ));
        
        // Somente substituir se não for avatar
        if (!isUserAvatar) {
            // Obter atributos da imagem para preservar configurações
            const parentElement = img.parentElement;
            const altText = img.getAttribute('alt') || 'Web Erp';
            const classList = img.classList;
            
            // Criar o novo logotipo em texto
            const logoTextElement = document.createElement('span');
            logoTextElement.className = 'ngb-prime-logo';
            if (classList.contains('logo-sm')) {
                logoTextElement.classList.add('compact');
            }
            
            // Adicionar os componentes do texto do logotipo
            logoTextElement.innerHTML = '<span class="ngb" style="color:#2A4B9C;font-weight:bold;">NEXT</span><span class="prime" style="color:#888;font-weight:bold;"> ERP</span>';
            
            // Substituir a imagem pelo texto
            if (parentElement) {
                parentElement.replaceChild(logoTextElement, img);
            }
        }
    });
    
    // Observar mudanças de tema no HTML para atualizar as cores do logotipo
    const observeThemeChanges = function() {
        const htmlElement = document.documentElement;
        
        // Verificar os atributos de tema iniciais
        updateLogoAppearance();
        
        // Configurar o observer para monitorar mudanças nos atributos
        const observer = new MutationObserver(function(mutations) {
            mutations.forEach(function(mutation) {
                if (mutation.type === 'attributes' && 
                   (mutation.attributeName === 'data-bs-theme' || 
                    mutation.attributeName === 'data-menu-color')) {
                    updateLogoAppearance();
                }
            });
        });
        
        // Iniciar o observer
        observer.observe(htmlElement, { attributes: true });
    };
    
    // Função para atualizar a aparência do logotipo com base nos temas
    const updateLogoAppearance = function() {
        // A atualização da aparência é feita automaticamente via CSS
        // Este gatilho pode ser usado para implementar animações ou efeitos adicionais
        const logos = document.querySelectorAll('.ngb-prime-logo');
        logos.forEach(logo => {
            logo.classList.add('theme-transition');
            // Remover a classe após a transição para evitar problemas
            setTimeout(() => {
                logo.classList.remove('theme-transition');
            }, 300);
        });
    };
    
    // Iniciar a observação de mudanças de tema
    observeThemeChanges();
}); 