<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRevendaToPlanoEmpresasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('plano_empresas', function (Blueprint $table) {
            $table->foreignId('revenda_id')->nullable()->after('empresa_id')->constrained('revendas');
            $table->decimal('valor_repasse', 10, 2)->nullable()->after('valor');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('plano_empresas', function (Blueprint $table) {
            $table->dropForeign(['revenda_id']);
            $table->dropColumn('revenda_id');
            $table->dropColumn('valor_repasse');
        });
    }
} 