<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Nfe;
use App\Models\Nfce;
use App\Models\Cte;
use App\Models\Empresa;
use App\Models\Mdfe;
use App\Models\PlanoEmpresa;
use Illuminate\Support\Facades\Auth;
use App\Models\Cliente;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */

    protected $empresa_id = 1;

    public function __construct()
    {
        $this->middleware('validaCashBack');
    }

    public function homeContador(){

    }

    public function index()
    {
        $totalEmitidoMes = 0;
        $plano = PlanoEmpresa::where('empresa_id', request()->empresa_id)
        ->orderBy('data_expiracao', 'desc')
        ->first();

        $msgPlano = "";
        if($plano == null){
            $msgPlano = "Empresa sem plano atribuído!";
        }

        if($plano != null){
            if(date('Y-m-d') > $plano->data_expiracao){
                $msgPlano = "Plano expirado!";
            }
        }

        if(__isMaster()){
            return redirect()->route('empresas.index');
        }

        if(__isSuporte()){
            return redirect()->route('suporte.index');
        }

        $periodo = request('periodo', 'today');
        $customDateRange = request('customDateRange', null);

        switch ($periodo) {
            case 'week':
                $startDate = now()->startOfWeek();
                $endDate = now()->endOfWeek();
                break;
            case 'month':
                $startDate = now()->startOfMonth();
                $endDate = now()->endOfMonth();
                break;
            case 'year':
                $startDate = now()->startOfYear();
                $endDate = now()->endOfYear();
                break;
            case 'custom':
                $dates = explode(' to ', $customDateRange);
                $startDate = \Carbon\Carbon::createFromFormat('d/m/Y', trim($dates[0]));
                $endDate = isset($dates[1]) ? \Carbon\Carbon::createFromFormat('d/m/Y', trim($dates[1])) : $startDate;
                break;
            default: // today
                $startDate = now()->startOfDay();
                $endDate = now()->endOfDay();
                break;
        }









        // Totais e quantidades de NFe e NFCe emitidas (aprovadas, não canceladas)
        $nfeCount = Nfe::where('empresa_id', request()->empresa_id)
            ->where('estado', 'aprovado')
            ->where('tpNF', 1)
            ->whereBetween('created_at', [$startDate, $endDate])
            ->count();

        $nfeTotal = Nfe::where('empresa_id', request()->empresa_id)
            ->where('estado', 'aprovado')
            ->where('tpNF', 1)
            ->whereBetween('created_at', [$startDate, $endDate])
            ->sum('total');

        $nfceCount = Nfce::where('empresa_id', request()->empresa_id)
            ->where('estado', 'aprovado')
            ->whereBetween('created_at', [$startDate, $endDate])
            ->count();

        $nfceTotal = Nfce::where('empresa_id', request()->empresa_id)
            ->where('estado', 'aprovado')
            ->whereBetween('created_at', [$startDate, $endDate])
            ->sum('total');

        $totalNfe = Nfe::where('empresa_id', request()->empresa_id)
            ->where(function($q) {
                $q->where('estado', 'aprovado')->orWhere('estado', 'cancelado');
            })
            ->where('tpNF', 1)
            ->whereBetween('created_at', [$startDate, $endDate])
            ->sum('total');

        $totalNfce = Nfce::where('empresa_id', request()->empresa_id)
            ->where(function($q) {
                $q->where('estado', 'aprovado')->orWhere('estado', 'cancelado');
            })
            ->whereBetween('created_at', [$startDate, $endDate])
            ->sum('total');

        $totalEmitidoMes = $totalNfce + $totalNfe;

        $totalNfeCount = Nfe::where('empresa_id', request()->empresa_id)
            ->where(function($q) {
                $q->where('estado', 'aprovado')->orWhere('estado', 'cancelado');
            })
            ->where('tpNF', 1)
            ->whereBetween('created_at', [$startDate, $endDate])
            ->count();

        $totalNfceCount = Nfce::where('empresa_id', request()->empresa_id)
            ->where(function($q) {
                $q->where('estado', 'aprovado')->orWhere('estado', 'cancelado');
            })
            ->whereBetween('created_at', [$startDate, $endDate])
            ->count();


        // $nfeCount = Nfe::where('empresa_id', request()->empresa_id)
        //     ->where('estado', 'aprovado')
        //     ->where('tpNF', 1)
        //     ->count();
        // $nfeTotal = Nfe::where('empresa_id', request()->empresa_id)
        //     ->where('estado', 'aprovado')
        //     ->where('tpNF', 1)
        //     ->sum('total');

        // $nfceCount = Nfce::where('empresa_id', request()->empresa_id)
        //     ->where('estado', 'aprovado')
        //     ->count();
        // $nfceTotal = Nfce::where('empresa_id', request()->empresa_id)
        //     ->where('estado', 'aprovado')
        //     ->sum('total');

        // $totalNfe = Nfe::where('empresa_id', request()->empresa_id)
        // ->where(function($q) {
        //     $q->where('estado', 'aprovado')->orWhere('estado', 'cancelado');
        // })
        // ->where('tpNF', 1)
        // ->whereMonth('created_at', date('m'))
        // ->sum('total');

        // $totalNfce = Nfce::where('empresa_id', request()->empresa_id)
        // ->where(function($q) {
        //     $q->where('estado', 'aprovado')->orWhere('estado', 'cancelado');
        // })
        // ->whereMonth('created_at', date('m'))
        // ->sum('total');

        // $totalEmitidoMes = $totalNfce + $totalNfe;

        // $totalNfeCount = Nfe::where('empresa_id', request()->empresa_id)
        //     ->where(function($q) {
        //         $q->where('estado', 'aprovado')->orWhere('estado', 'cancelado');
        //     })
        //     ->where('tpNF', 1)
        //     ->whereMonth('created_at', date('m'))
        //     ->count();

        // $totalNfceCount = Nfce::where('empresa_id', request()->empresa_id)
        //     ->where(function($q) {
        //         $q->where('estado', 'aprovado')->orWhere('estado', 'cancelado');
        //     })
        //     ->whereMonth('created_at', date('m'))
        //     ->count();

        // FIM


        $totalCteCount = Cte::where('empresa_id', request()->empresa_id)
        ->where(function($q) {
            $q->where('estado', 'aprovado')->orWhere('estado', 'cancelado');
        })
        ->whereMonth('created_at', date('m'))
        ->count('id');

        $totalMdfeCount = Mdfe::where('empresa_id', request()->empresa_id)
        ->where(function($q) {
            $q->where('estado_emissao', 'aprovado')->orWhere('estado_emissao', 'cancelado');
        })
        ->whereMonth('created_at', date('m'))
        ->count('id');

        $empresa = Empresa::find(request()->empresa_id);
        if($empresa == null){
            return redirect()->route('config.index');
        }

        $totalVendasMes = 0;
        $mesAtual = date('m');
        $mes = $this->meses()[$mesAtual-1];

        $somaVendasMesesAnteriores = $this->somaVendasMesesAnteriores();
        $totalVendasMes = $this->somaVendasMes();

        $totalComprasMes = $this->somaComprasMes();
        $somaComprasMesesAnteriores = $this->somaComprasMesesAnteriores();

        $somaVendasMesesAnteriores[$mes] = $totalVendasMes;

        // Buscar aniversariantes do mês
        $aniversariantesMes = Cliente::whereNotNull('data_aniversario')
            ->whereMonth('data_aniversario', date('m'))
            ->orderByRaw('DAY(data_aniversario) ASC')
            ->get();

        return view('home', compact(
            'plano', 'msgPlano', 'totalEmitidoMes', 'totalNfe', 'totalNfce', 'totalNfeCount', 'totalNfceCount',
            'nfeCount', 'nfeTotal', 'nfceCount', 'nfceTotal',
            'totalVendasMes', 'totalComprasMes', 'somaVendasMesesAnteriores', 'somaComprasMesesAnteriores', 'mes', 'aniversariantesMes',
            'totalCteCount', 'totalMdfeCount', 'empresa'
        ));
    }

    private function somaComprasMes(){
        $totalCompra = Nfe::where('empresa_id', request()->empresa_id)
        ->where('estado', '!=', 'cancelado')
        ->whereMonth('created_at', date('m'))
        ->where('tpNF', 0)
        ->sum('total');

        return $totalCompra;
    }

    private function somaVendasMes(){
        $totalNfe = Nfe::where('empresa_id', request()->empresa_id)
        ->whereIn('estado', ['novo', 'aprovado'])
        ->whereMonth('created_at', date('m'))
        ->where('tpNF', 1)
        ->where('orcamento', 0)
        ->sum('total');

        $totalNfce = Nfce::where('empresa_id', request()->empresa_id)
        ->whereIn('estado', ['novo', 'aprovado'])
        ->whereMonth('created_at', date('m'))
        ->sum('total');

        return $totalNfce + $totalNfe;
    }

    private function somaComprasMesesAnteriores(){
        $data = [];
        $meses = 3;
        $mesAtual = date('m')-2;

        $cont = 0;
        $i = 0;
        while($cont < $meses){
            if(isset($this->meses()[$mesAtual])){
                $mes = $this->meses()[$mesAtual];
            }else{
                $mes = 'Dezembro';
                $mesAtual = 11;
            }

            $totalNfe = Nfe::where('empresa_id', request()->empresa_id)
            ->where('estado', '!=', 'cancelado')
            ->whereMonth('created_at', $mesAtual+1)
            ->where('tpNF', 0)
            ->sum('total');

            $mesAtual--;
            $cont++;
            $data[$mes] = $totalNfe;
        }

        return $data;
    }

    private function somaVendasMesesAnteriores(){
        $data = [];
        $meses = 3;
        $mesAtual = date('m')-2;

        $cont = 0;
        $i = 0;
        while($cont < $meses){
            if(isset($this->meses()[$mesAtual])){
                $mes = $this->meses()[$mesAtual];
            }else{
                $mes = 'Dezembro';
                $mesAtual = 11;
            }

            $totalNfe = Nfe::where('empresa_id', request()->empresa_id)
            ->whereIn('estado', ['novo', 'aprovado'])
            ->whereMonth('created_at', $mesAtual+1)
            ->where('tpNF', 1)
            ->where('orcamento', 0)
            ->sum('total');

            $totalNfce = Nfce::where('empresa_id', request()->empresa_id)
            ->whereIn('estado', ['novo', 'aprovado'])
            ->whereMonth('created_at', $mesAtual+1)
            ->sum('total');

            $mesAtual--;
            $cont++;
            $data[$mes] = $totalNfce + $totalNfe;
        }

        return $data;
    }

    private function meses(){
        return [
            'Janeiro',
            'Fevereiro',
            'Março',
            'Abril',
            'Maio',
            'Junho',
            'Julho',
            'Agosto',
            'Setembro',
            'Outubro',
            'Novembro',
            'Dezembro',
        ];
    }

    public function nfe(Request $request)
    {
        $empresa_id = $request->empresa;
        $start_date = $request->start_date;
        $end_date = $request->end_date;
        $estado = $request->estado;

        $data = NFe::orderBy("id", "desc")
        ->when(!empty($start_date), function ($query) use ($start_date) {
            return $query->whereDate('data_emissao', '>=', $start_date);
        })
        ->when(!empty($end_date), function ($query) use ($end_date) {
            return $query->whereDate('data_emissao', '<=', $end_date);
        })
        ->when(!empty($empresa_id), function ($query) use ($empresa_id) {
            return $query->where('empresa_id', $empresa_id);
        })
        ->when(!empty($estado), function ($query) use ($estado) {
            return $query->where('estado', $estado);
        })
        ->paginate(30);

        $empresa = null;
        if($empresa_id){
            $empresa = Empresa::findOrFail($empresa_id);
        }

        return view('nfe.all', compact('data', 'empresa'));
    }

    public function nfce(Request $request)
    {
        $empresa_id = $request->empresa;
        $start_date = $request->start_date;
        $end_date = $request->end_date;
        $estado = $request->estado;

        $data = Nfce::orderBy("id", "desc")
        ->when(!empty($start_date), function ($query) use ($start_date) {
            return $query->whereDate('data_emissao', '>=', $start_date);
        })
        ->when(!empty($end_date), function ($query) use ($end_date) {
            return $query->whereDate('data_emissao', '<=', $end_date);
        })
        ->when(!empty($empresa_id), function ($query) use ($empresa_id) {
            return $query->where('empresa_id', $empresa_id);
        })
        ->when(!empty($estado), function ($query) use ($estado) {
            return $query->where('estado', $estado);
        })
        ->paginate(30);

        $empresa = null;
        if($empresa_id){
            $empresa = Empresa::findOrFail($empresa_id);
        }

        return view('nfce.all', compact('data', 'empresa'));
    }

    public function cte(Request $request)
    {
        $empresa_id = $request->empresa;
        $start_date = $request->start_date;
        $end_date = $request->end_date;
        $estado = $request->estado;

        $data = Cte::orderBy("id", "desc")
        ->when(!empty($start_date), function ($query) use ($start_date) {
            return $query->whereDate('created_at', '>=', $start_date);
        })
        ->when(!empty($end_date), function ($query) use ($end_date) {
            return $query->whereDate('created_at', '<=', $end_date);
        })
        ->when(!empty($empresa_id), function ($query) use ($empresa_id) {
            return $query->where('empresa_id', $empresa_id);
        })
        ->when(!empty($estado), function ($query) use ($estado) {
            return $query->where('estado', $estado);
        })
        ->paginate(30);

        $empresa = null;
        if($empresa_id){
            $empresa = Empresa::findOrFail($empresa_id);
        }

        return view('cte.all', compact('data', 'empresa'));
    }

    public function mdfe(Request $request)
    {
        $empresa_id = $request->empresa;
        $start_date = $request->start_date;
        $end_date = $request->end_date;
        $estado = $request->estado;

        $data = Mdfe::orderBy("id", "desc")
        ->when(!empty($start_date), function ($query) use ($start_date) {
            return $query->whereDate('created_at', '>=', $start_date);
        })
        ->when(!empty($end_date), function ($query) use ($end_date) {
            return $query->whereDate('created_at', '<=', $end_date);
        })
        ->when(!empty($empresa_id), function ($query) use ($empresa_id) {
            return $query->where('empresa_id', $empresa_id);
        })
        ->when(!empty($estado), function ($query) use ($estado) {
            return $query->where('estado', $estado);
        })
        ->paginate(30);

        $empresa = null;
        if($empresa_id){
            $empresa = Empresa::findOrFail($empresa_id);
        }

        return view('mdfe.all', compact('data', 'empresa'));
    }
}
