<?php $__env->startSection('css'); ?>
<style>
.modal-backdrop {
    opacity: 0.5 !important;
}
.modal {
    background: rgba(0,0,0,0.5);
}
.modal-dialog {
    margin: 1.75rem auto;
}
</style>
<?php $__env->stopSection(); ?>

<?php if(__countLocalAtivo() > 1 && __escolheLocalidade()): ?>
<div class="row mb-2">
    <div class="col-md-3">
        <label for="">Local</label>
        <select id="inp-local_id" required class="select2 class-required" data-toggle="select2" name="local_id">
            <option value="">Selecione</option>
            <?php $__currentLoopData = __getLocaisAtivoUsuario(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $local): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option <?php if(isset($item)): ?> <?php if($item->local_id == $local->id): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($local->id); ?>"><?php echo e($local->descricao); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
</div>
<?php endif; ?>

<div class="row">
    <div class="col-md-12">
        <?php if(isset($item)): ?>
        <?php if($item->fornecedor): ?>
        <?php
        $isCompra = 1;
        ?>
        <?php endif; ?>
        <?php endif; ?>
        <?php if(isset($isCompra)): ?>
        <input type="hidden" id="is_compra" name="is_compra" value="1">
        <?php endif; ?>

        <?php if(isset($isOrdemServico)): ?>
        <input type="hidden" name="ordem_servico_id" value="<?php echo e($item->id); ?>">
        <?php endif; ?>

        <?php if(isset($isPedidoEcommerce)): ?>
        <input type="hidden" name="pedido_ecommerce_id" value="<?php echo e($item->id); ?>">
        <?php endif; ?>

        <?php if(isset($isPedidoMercadoLivre)): ?>
        <input type="hidden" name="pedido_mercado_livre_id" value="<?php echo e($item->id); ?>">
        <?php endif; ?>

        <?php if(isset($isPedidoNuvemShop)): ?>
        <input type="hidden" name="pedido_nuvem_shop_id" value="<?php echo e($item->id); ?>">
        <?php endif; ?>

        <?php if(isset($cotacao)): ?>
        <input type="hidden" name="cotacao_id" value="<?php echo e($cotacao->id); ?>">
        <?php endif; ?>

        <?php if(isset($isReserva)): ?>
        <input type="hidden" name="reserva_id" value="<?php echo e($item->id); ?>">
        <?php endif; ?>

        <?php if(isset($isPedidoWoocommerce)): ?>
        <input type="hidden" name="pedido_woocommerce_id" value="<?php echo e($item->id); ?>">
        <?php endif; ?>

        <?php if(isset($orcamentosId)): ?>
        <?php $__currentLoopData = $orcamentosId; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <input type="hidden" name="orcamento_id[]" value="<?php echo e($i); ?>">
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <ul class="nav nav-tabs nav-primary" role="tablist">
            <li class="nav-item" role="presentation">
                <a class="nav-link active" data-bs-toggle="tab" href="#operacoes" role="tab" aria-selected="true">
                    <div class="d-flex align-items-center">
                        <div class="tab-icon"><i class='fa fa-cogs me-2'></i>
                        </div>
                        <div class="tab-title">
                            <i class="ri-settings-3-line"></i>
                            Operações NFe
                        </div>
                    </div>
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link" data-bs-toggle="tab" href="#cliente" role="tab" aria-selected="false">
                    <div class="d-flex align-items-center">
                        <div class="tab-icon"><i class='fa fa-user me-2'></i>
                        </div>
                        <div class="tab-title">
                            <i class="ri-file-user-fill"></i>
                            <?php if(isset($isCompra)): ?> Fornecedor <?php else: ?> Cliente <?php endif; ?>
                        </div>
                    </div>
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link" data-bs-toggle="tab" href="#produtos" role="tab" aria-selected="false">
                    <div class="d-flex align-items-center">
                        <div class="tab-icon"><i class='fa fa-shopping-cart me-2'></i>
                        </div>
                        <div class="tab-title">
                            <i class="ri-box-2-line"></i>
                            Produtos
                        </div>
                    </div>
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link" data-bs-toggle="tab" href="#transportadora" role="tab" aria-selected="false">
                    <div class="d-flex align-items-center">
                        <div class="tab-icon"><i class='fa fa-truck me-2'></i>
                        </div>
                        <div class="tab-title">
                            <i class="ri-truck-line"></i>
                            Frete
                        </div>
                    </div>
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link" data-bs-toggle="tab" href="#fatura" role="tab" aria-selected="false">
                    <div class="d-flex align-items-center">
                        <div class="tab-icon"><i class='fa fa-money-bill me-2'></i>
                        </div>
                        <div class="tab-title">
                            <i class="ri-coins-line"></i>
                            Fatura
                        </div>
                    </div>
                </a>
            </li>
        </ul>
        <hr>
        <div class="tab-content">
            <div class="tab-pane fade show active" id="operacoes" role="tabpanel">
                <div class="card">
                    <div class="row m-3">
                        <?php if(__isPlanoFiscal()): ?>
                        <!-- PRIMEIRA LINHA -->
                        <div class="col-md-3">
                            <?php if(isset($isOrdemServico) || isset($isPedidoEcommerce) || isset($isPedidoMercadoLivre) || isset($isReserva)): ?>
                            <?php echo Form::tel('numero_nfe', 'Número NFe')
                            ->required()
                            ->value($numeroNfe); ?>

                            <?php else: ?>
                            <?php echo Form::tel('numero_nfe', 'Número NFe')
                            ->required()
                            ->value(isset($item) ? $item->numero : $numeroNfe); ?>

                            <?php endif; ?>
                        </div>
                        <div class="col-md-3">
                            <?php echo Form::select('natureza_id', 'Natureza de Operação', ['' => 'Selecione'] + $naturezas->pluck('descricao', 'id')->all())
                            ->attrs(['class' => 'form-select'])
                            ->value(isset($item) ? $item->natureza_id : (isset($naturezaPadrao) && $naturezaPadrao != null ? $naturezaPadrao->id : '') )
                            ->required(); ?>

                        </div>
                        <div class="col-md-3">
                            <?php if(!isset($isCompra)): ?>
                            <?php echo Form::select('tpNF', 'Tipo NFe', ['1' => 'Saída', '0' => 'Entrada'])
                            ->attrs(['class' => 'form-select']); ?>

                            <?php else: ?>
                            <?php echo Form::select('tpNF', 'Tipo NFe', ['0' => 'Entrada'])
                            ->attrs(['class' => 'form-select']); ?>

                            <?php endif; ?>
                        </div>
                        <div class="col-md-3">
                            <?php echo Form::date('data_emissao_saida', 'Data Emissão Saída')
                            ->value(isset($item) ? $item->data_emissao_saida : date('Y-m-d')); ?>

                        </div>
                        
                        <!-- SEGUNDA LINHA -->
                        <div class="col-md-3 mt-3">
                            <?php echo Form::date('data_emissao_retroativa', 'Data Emissão Retroativa')
                            ->value(isset($item) ? $item->data_emissao_retroativa : date('Y-m-d')); ?>

                        </div>
                        <div class="col-md-3 mt-3">
                            <?php echo Form::date('data_entrega', 'Data de Entrega')
                            ->value(isset($item) ? $item->data_entrega : date('Y-m-d')); ?>

                        </div>
                        <div class="col-md-3 mt-3">
                            <?php echo Form::select('finNFe', 'Finalidade NFe', [
                            '1' => 'NFe normal',
                            '2' => 'NFe complementar',
                            '3' => 'NFe de ajuste',
                            '4' => 'Devolução de mercadoria'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <div class="col-md-3 mt-3">
                            <?php echo Form::tel('referencia', 'Referência NFe')
                            ->attrs(['class' => 'form-control', 'onblur' => 'limparEspacosReferencia(this)', 'id' => 'campo-referencia']); ?>

                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade show" id="cliente" role="tabpanel">
                <div class="card">
                    <?php if(!isset($isCompra)): ?>
                    <div class="row m-3">
                        <div class="col-md-5">
                            <label class="required">Cliente</label>
                            <div class="input-group flex-nowrap">
                                <select required id="inp-cliente_id" name="cliente_id" class="cliente_id">
                                    <?php if(isset($item) && $item->cliente): ?>
                                    <option value="<?php echo e($item->cliente_id); ?>"><?php echo e($item->cliente->razao_social); ?></option>
                                    <?php endif; ?>
                                </select>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('clientes_create')): ?>
                                <button class="btn btn-dark" data-bs-toggle="modal" data-bs-target="#modal_novo_cliente" type="button">
                                    <i class="ri-add-circle-fill"></i>
                                </button>
                                <?php endif; ?>
                            </div>
                        </div>
                        <hr class="mt-3">
                        <div class="row d-cliente">
                            <div class="col-md-3">
                                <?php echo Form::text('cliente_nome', 'Razão Social')->attrs(['class' => ''])->required()
                                ->value(isset($item) ? $item->cliente->razao_social : ''); ?>

                            </div>
                            <div class="col-md-3">
                                <?php echo Form::text('nome_fantasia', 'Nome Fantasia')->attrs(['class' => ''])
                                ->value(isset($item) ? $item->cliente->nome_fantasia : ''); ?>

                            </div>
                            <div class="col-md-2">
                                <?php echo Form::tel('cliente_cpf_cnpj', 'CPF/CNPJ')->attrs(['class' => 'cpf_cnpj'])->required()
                                ->value(isset($item) ? $item->cliente->cpf_cnpj : ''); ?>

                            </div>
                            <div class="col-md-2">
                                <?php echo Form::text('ie', 'IE')->attrs(['class' => ''])
                                ->value(isset($item) ? $item->cliente->ie : ''); ?>

                            </div>
                            <div class="col-md-2">
                                <?php echo Form::tel('telefone', 'Fone')->attrs(['class' => 'fone'])
                                ->value(isset($item) ? $item->cliente->telefone : ''); ?>

                            </div>
                            <div class="col-md-2 mt-3">
                                <?php echo Form::select('contribuinte', 'Contribuinte', [0 => 'Não', 1 => 'Sim'])->attrs(['class' => 'form-select'])
                                ->value(isset($item) ? $item->cliente->contribuinte : ''); ?>

                            </div>
                            <div class="col-md-2 mt-3">
                                <?php echo Form::select('consumidor_final', 'Consumidor Final', [0 => 'Não', 1 => 'Sim'])->attrs(['class' => 'form-select'])->required()
                                ->value(isset($item) ? $item->cliente->consumidor_final : ''); ?>

                            </div>
                            <div class="col-md-4 mt-3">
                                <?php echo Form::text('email', 'E-mail')->attrs(['class' => ''])
                                ->value(isset($item) ? $item->cliente->email : ''); ?>

                            </div>
                            <div class="col-md-4 mt-3">
                                <label for="">Cidade</label>
                                <select required class="form-control select2 cidade_id" name="cliente_cidade" id="inp-cidade_cliente">
                                    <option value="">Selecione..</option>
                                    <?php $__currentLoopData = $cidades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php if(isset($item)): ?> <?php if($item->cliente->cidade_id == $c->id): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($c->id); ?>"><?php echo e($c->nome); ?> - <?php echo e($c->uf); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-3 mt-3">
                                <?php echo Form::text('cliente_rua', 'Rua')->attrs(['class' => ''])->required()
                                ->value(isset($item) ? $item->cliente->rua : ''); ?>

                            </div>
                            <div class="col-md-1 mt-3">
                                <?php echo Form::text('cliente_numero', 'Número')->attrs(['class' => ''])->required()
                                ->value(isset($item) ? $item->cliente->numero : ''); ?>

                            </div>
                            <div class="col-md-2 mt-3">
                                <?php echo Form::text('cep', 'CEP')->attrs(['class' => 'cep'])->required()
                                ->value(isset($item) ? $item->cliente->cep : ''); ?>

                            </div>
                            <div class="col-md-2 mt-3">
                                <?php echo Form::text('cliente_bairro', 'Bairro')->attrs(['class' => ''])->required()
                                ->value(isset($item) ? $item->cliente->bairro : ''); ?>

                            </div>
                            <div class="col-md-4 mt-3">
                                <?php echo Form::text('complemento', 'Complemento')->attrs(['class' => ''])
                                ->value(isset($item) ? $item->cliente->complemento : ''); ?>

                            </div>
                        </div>
                    </div>

                    <?php else: ?>

                    <div class="row m-3">

                        <div class="col-md-5">
                            <label>Fornecedor</label>
                            <div class="input-group flex-nowrap">
                                <select id="inp-fornecedor_id" name="fornecedor_id" class="fornecedor_id">
                                    <?php if(isset($cotacao)): ?>
                                    <option value="<?php echo e($cotacao->fornecedor_id); ?>"><?php echo e($cotacao->fornecedor->razao_social); ?></option>

                                    <?php else: ?>
                                    <?php if(isset($item)): ?>
                                    <option value="<?php echo e($item->fornecedor_id); ?>"><?php echo e($item->fornecedor->razao_social); ?></option>
                                    <?php endif; ?>
                                    <?php endif; ?>

                                </select>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('fornecedores_create')): ?>
                                <button class="btn btn-dark" data-bs-toggle="modal" data-bs-target="#modal_novo_fornecedor" type="button">
                                    <i class="ri-add-circle-fill"></i>
                                </button>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <hr class="mt-3">
                        <div class="row d-cliente">
                            <div class="col-md-3">
                                <?php echo Form::text('fornecedor_nome', 'Razão Social')->attrs(['class' => ''])->required()
                                ->value(isset($item) ? $item->fornecedor->razao_social : ''); ?>

                            </div>
                            <div class="col-md-3">
                                <?php echo Form::text('nome_fantasia', 'Nome Fantasia')->attrs(['class' => ''])->required()
                                ->value(isset($item) ? $item->fornecedor->nome_fantasia : ''); ?>

                            </div>
                            <div class="col-md-2">
                                <?php echo Form::tel('fornecedor_cpf_cnpj', 'CPF/CNPJ')->attrs(['class' => 'cpf_cnpj'])->required()
                                ->value(isset($item) ? $item->fornecedor->cpf_cnpj : ''); ?>

                            </div>
                            <div class="col-md-2">
                                <?php echo Form::text('ie', 'IE')->attrs(['class' => ''])
                                ->value(isset($item) ? $item->fornecedor->ie : ''); ?>

                            </div>
                            <div class="col-md-2">
                                <?php echo Form::tel('telefone', 'Fone')->attrs(['class' => 'fone'])
                                ->value(isset($item) ? $item->fornecedor->telefone : ''); ?>

                            </div>
                            <div class="col-md-2 mt-3">
                                <?php echo Form::select('contribuinte', 'Contribuinte', [0 => 'Não', 1 => 'Sim'])->attrs(['class' => 'form-select'])
                                ->value(isset($item) ? $item->fornecedor->contribuinte : ''); ?>

                            </div>
                            <div class="col-md-2 mt-3">
                                <?php echo Form::select('consumidor_final', 'Consumidor Final', [0 => 'Não', 1 => 'Sim'])->attrs(['class' => 'form-select'])->required()
                                ->value(isset($item) ? $item->fornecedor->consumidor_final : ''); ?>

                            </div>
                            <div class="col-md-4 mt-3">
                                <?php echo Form::text('email', 'E-mail')->attrs(['class' => ''])
                                ->value(isset($item) ? $item->fornecedor->email : ''); ?>

                            </div>
                            <div class="col-md-4 mt-3">
                                <label for="">Cidade</label>
                                <select required class="form-control select2 cidade_id" name="fornecedor_cidade" id="inp-fornecedor_cidade">
                                    <option value="">Selecione..</option>
                                    <?php $__currentLoopData = $cidades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php if(isset($item)): ?> <?php if($item->fornecedor->cidade_id == $c->id): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($c->id); ?>"><?php echo e($c->nome); ?> - <?php echo e($c->uf); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-3 mt-3">
                                <?php echo Form::text('fornecedor_rua', 'Rua')->attrs(['class' => ''])->required()
                                ->value(isset($item) ? $item->fornecedor->rua : ''); ?>

                            </div>
                            <div class="col-md-1 mt-3">
                                <?php echo Form::text('fornecedor_numero', 'Número')->attrs(['class' => ''])->required()
                                ->value(isset($item) ? $item->fornecedor->numero : ''); ?>

                            </div>
                            <div class="col-md-2 mt-3">
                                <?php echo Form::text('cep', 'CEP')->attrs(['class' => 'cep'])->required()
                                ->value(isset($item) ? $item->fornecedor->cep : ''); ?>

                            </div>
                            <div class="col-md-2 mt-3">
                                <?php echo Form::text('fornecedor_bairro', 'Bairro')->attrs(['class' => ''])->required()
                                ->value(isset($item) ? $item->fornecedor->bairro : ''); ?>

                            </div>
                            <div class="col-md-4 mt-3">
                                <?php echo Form::text('complemento', 'Complemento')->attrs(['class' => ''])
                                ->value(isset($item) ? $item->fornecedor->complemento : ''); ?>

                            </div>
                        </div>
                    </div>

                    <?php endif; ?>
                </div>
            </div>
            <div class="tab-pane fade" id="produtos" role="tabpanel">
                <div class="card">
                    <div class="row m-3">

                        <div class="table-responsive">
                            <table class="table table-dynamic table-produtos" style="width: 2800px">
                                <thead>
                                    <tr>
                                        <th class="sticky-col first-col">Produto</th>
                                        <th>Quantidade</th>
                                        <th>Valor Unit.</th>
                                        <th>Subtotal</th>
                                        <th>%ICMS</th>
                                        <th>%PIS</th>
                                        <th>%COFINS</th>
                                        <th>%IPI</th>
                                        <th>%RED BC</th>
                                        <th>CFOP</th>
                                        <th>NCM</th>
                                        <th>Código benefício</th>
                                        <th>CST CSOSN</th>
                                        <th>CST PIS</th>
                                        <th>CST COFINS</th>
                                        <th>CST IPI</th>
                                        <th>Nº do pedido</th>
                                        <th>Nº item do pedido</th>
                                        <th>Informação adicional do item</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php if(isset($item)): ?>

                                    <?php $__currentLoopData = $item->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $prod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <?php if(isset($isOrdemServico)): ?>
                                    <?php echo $__env->make('ordem_servico.partials.itens', ['prod' => $prod], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php elseif(isset($isPedidoEcommerce)): ?>
                                    <?php echo $__env->make('pedido_ecommerce.partials.itens', ['prod' => $prod, 'cfop_estadual' => $item->cliente->cidade->uf], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php elseif(isset($isPedidoMercadoLivre)): ?>
                                    <?php echo $__env->make('mercado_livre_pedidos.partials.itens', ['prod' => $prod, 'cfop_estadual' => $item->cliente->cidade->uf], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                    <?php elseif(isset($isReserva)): ?>
                                    <?php echo $__env->make('mercado_livre_pedidos.partials.itens', ['prod' => $prod, 'cfop_estadual' => $item->cliente->cidade->uf], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php elseif(isset($isPedidoWoocommerce)): ?>
                                    <?php echo $__env->make('woocommerce_pedidos.partials.itens', ['prod' => $prod, 'cfop_estadual' => $item->cliente->cidade->uf], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php elseif(isset($isPedidoNuvemShop)): ?>
                                    <?php echo $__env->make('woocommerce_pedidos.partials.itens', ['prod' => $prod, 'cfop_estadual' => $item->cliente->cidade->uf], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php else: ?>

                                    <tr class="dynamic-form">
                                        <td class="sticky-col first-col">
                                            <input type="hidden" class="_key" name="_key[]" value="<?php echo e($key); ?>">
                                            <div class="dimensoes-hidden dh_<?php echo e($key); ?>">
                                                <?php if(isset($prod->itensDimensao) && sizeof($prod->itensDimensao) > 0): ?>
                                                <?php $__currentLoopData = $prod->itensDimensao; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $it): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <input type='hidden' name='dimensao_altura[]' value='<?php echo e($it->altura); ?>' />
                                                <input type='hidden' name='dimensao_espessura[]' value='<?php echo e($it->espessura); ?>' />
                                                <input type='hidden' name='dimensao_largura[]' value='<?php echo e($it->largura); ?>' />
                                                <input type='hidden' name='dimensao_m2_total[]' value='<?php echo e($it->m2_total); ?>' />
                                                <input type='hidden' name='dimensao_observacao[]' value='<?php echo e($it->observacao); ?>' />
                                                <input type='hidden' name='dimensao_quantidade[]' value='<?php echo e($it->quantidade); ?>' />
                                                <input type='hidden' name='dimensao_sub_total[]' value='<?php echo e($it->sub_total); ?>' />
                                                <input type='hidden' name='dimensao_valor_unitario_m2[]' value='<?php echo e($it->valor_unitario_m2); ?>' />
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>

                                                <input type='hidden' name='_line[]' value='<?php echo e($key); ?>' />

                                            </div>
                                            <select class="form-control select2 produto_id" name="produto_id[]" id="inp-produto_id">
                                                <option value="<?php echo e($prod->produto_id); ?>"><?php echo e($prod->produto->nome); ?></option>
                                            </select>
                                            <?php if($prod->variacao_id): ?>
                                            <span>variação: <strong><?php echo e($prod->produtoVariacao->descricao); ?></strong></span>
                                            <?php endif; ?>
                                            <input name="variacao_id[]" type="hidden" value="<?php echo e($prod->variacao_id); ?>">
                                            <div style="width: 500px;"></div>
                                            <?php if(isset($prod->itensDimensao) && sizeof($prod->itensDimensao) > 0): ?>
                                            <a onclick="alterarDimensoesItem('<?php echo e($prod->id); ?>', '<?php echo e($key); ?>')" href="#!">Alterar dimensões</a>
                                            <?php endif; ?>
                                        </td>
                                        <td width="80">
                                            <input style="width: 150px" value="<?php echo e(__moeda($prod->quantidade)); ?>" class="form-control qtd next" type="tel" name="quantidade[]" id="inp-quantidade">
                                        </td>
                                        <td width="100">
                                            <input style="width: 150px" value="<?php echo e(__moeda($prod->valor_unitario)); ?>" class="form-control moeda valor_unit next" type="tel" name="valor_unitario[]" id="inp-valor_unitario">
                                        </td>
                                        <td width="150">
                                            <input style="width: 150px" value="<?php echo e(__moeda($prod->sub_total)); ?>" class="form-control moeda sub_total next" type="tel" name="sub_total[]" id="inp-subtotal">
                                        </td>
                                        <td width="120">
                                            <input style="width: 120px" value="<?php echo e($prod->perc_icms); ?>" class="form-control percentual" type="tel" name="perc_icms[]" id="inp-perc_icms">
                                        </td>
                                        <td width="120">
                                            <input style="width: 120px" value="<?php echo e($prod->perc_pis); ?>" class="form-control percentual" type="tel" name="perc_pis[]" id="inp-perc_pis">
                                        </td>
                                        <td width="120">
                                            <input style="width: 120px" value="<?php echo e($prod->perc_cofins); ?>" class="form-control percentual" type="tel" name="perc_cofins[]" id="inp-perc_cofins">
                                        </td>
                                        <td width="120">
                                            <input style="width: 120px" value="<?php echo e($prod->perc_ipi); ?>" class="form-control percentual" type="tel" name="perc_ipi[]" id="inp-perc_ipi">
                                        </td>
                                        <td width="120">
                                            <input style="width: 120px" value="<?php echo e($prod->perc_red_bc); ?>" class="form-control percentual ignore" type="tel" name="perc_red_bc[]" id="inp-perc_red_bc">
                                        </td>
                                        <td width="120">
                                            <input style="width: 120px" required value="<?php echo e($prod->cfop); ?>" class="form-control cfop" type="tel" name="cfop[]" id="inp-cfop_estadual">
                                        </td>

                                        <td width="150">
                                            <input style="width: 120px" required value="<?php echo e($prod->ncm); ?>" class="form-control ncm" type="tel" name="ncm[]" id="inp-ncm2">
                                        </td>
                                        <td width="120">
                                            <input style="width: 120px" value="<?php echo e($prod->codigo_beneficio_fiscal); ?>" class="form-control ignore codigo_beneficio_fiscal" type="text" name="codigo_beneficio_fiscal[]">
                                        </td>

                                        <td>
                                            <select name="cst_csosn[]" class="form-control select2">
                                                <?php $__currentLoopData = App\Models\Produto::listaCSTCSOSN(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php if($prod->cst_csosn == $key): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($c); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div style="width: 400px"></div>
                                        </td>
                                        <td>
                                            <select name="cst_pis[]" class="form-control select2">
                                                <?php $__currentLoopData = App\Models\Produto::listaCST_PIS_COFINS(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php if($prod->cst_pis == $key): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($c); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div style="width: 400px"></div>
                                        </td>
                                        <td>
                                            <select name="cst_cofins[]" class="form-control select2">
                                                <?php $__currentLoopData = App\Models\Produto::listaCST_PIS_COFINS(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php if($prod->cst_cofins == $key): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($c); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div style="width: 400px"></div>
                                        </td>
                                        <td>
                                            <select name="cst_ipi[]" class="form-control select2">
                                                <?php $__currentLoopData = App\Models\Produto::listaCST_IPI(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php if($prod->cst_ipi == $key): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($c); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div style="width: 400px"></div>
                                        </td>
                                        <td>
                                            <input class="form-control ignore" value="<?php echo e($prod->xPed); ?>" maxlength="15" type="text" name="xPed[]">
                                            <div style="width: 200px"></div>
                                        </td>
                                        <td>
                                            <input class="form-control ignore" value="<?php echo e($prod->nItemPed); ?>" maxlength="6" type="text" name="nItemPed[]">
                                            <div style="width: 200px"></div>
                                        </td>
                                        <td>
                                            <input class="form-control ignore" value="<?php echo e($prod->infAdProd); ?>" maxlength="200" type="text" name="infAdProd[]">
                                            <div style="width: 300px"></div>
                                        </td>
                                        <td width="30">
                                            <button class="btn btn-danger btn-remove-tr">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php elseif(isset($cotacao)): ?>
                                    <?php $__currentLoopData = $cotacao->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo $__env->make('cotacoes.partials.itens', ['prod' => $prod, 'mesmo_estado' => $cotacao->fornecedor->cidade->uf == $empresa->cidade->uf], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php else: ?>
                                    <tr class="dynamic-form">
                                        <td class="sticky-col first-col">
                                            <input type="hidden" class="_key" name="_key[]" value="0">
                                            <div class="dimensoes-hidden">

                                            </div>
                                            <select required class="form-control select2 produto_id" name="produto_id[]" id="inp-produto_id">
                                            </select>
                                            <div style="width: 400px;"></div>
                                            <input name="variacao_id[]" type="hidden" value="">
                                        </td>
                                        <td width="120">
                                            <input style="width: 120px" class="form-control qtd next" type="tel" name="quantidade[]" id="inp-quantidade">
                                        </td>
                                        <td width="150">
                                            <input style="width: 120px" class="form-control moeda valor_unit next" type="tel" name="valor_unitario[]" id="inp-valor_unitario">
                                        </td>
                                        <td width="150">
                                            <input style="width: 120px" readonly class="form-control moeda sub_total sub_total_new next" type="tel" name="sub_total[]" id="inp-subtotal">
                                        </td>
                                        <td width="120">
                                            <input style="width: 120px" class="form-control percentual" type="tel" name="perc_icms[]" id="inp-perc_icms">
                                        </td>
                                        <td width="120">
                                            <input style="width: 120px" class="form-control percentual" type="tel" name="perc_pis[]" id="inp-perc_pis">
                                        </td>
                                        <td width="120">
                                            <input style="width: 120px" class="form-control percentual" type="tel" name="perc_cofins[]" id="inp-perc_cofins">
                                        </td>
                                        <td width="120">
                                            <input style="width: 120px" class="form-control percentual" type="tel" name="perc_ipi[]" id="inp-perc_ipi">
                                        </td>
                                        <td width="120">
                                            <input style="width: 120px" class="form-control percentual ignore" type="tel" name="perc_red_bc[]" id="inp-perc_red_bc">
                                        </td>
                                        <td width="150">
                                            <input style="width: 120px" required class="form-control cfop" type="tel" name="cfop[]" id="inp-cfop_estadual">
                                        </td>

                                        <td width="150">
                                            <input style="width: 120px" required class="form-control ncm" type="tel" name="ncm[]" id="inp-ncm2">
                                        </td>

                                        <td width="120">
                                            <input style="width: 120px" class="form-control codigo_beneficio_fiscal ignore" type="text" name="codigo_beneficio_fiscal[]">
                                        </td>

                                        <td>
                                            <select name="cst_csosn[]" class="form-control select2">
                                                <?php $__currentLoopData = App\Models\Produto::listaCSTCSOSN(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>"><?php echo e($c); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div style="width: 400px"></div>
                                        </td>
                                        <td>
                                            <select name="cst_pis[]" class="form-control select2">
                                                <?php $__currentLoopData = App\Models\Produto::listaCST_PIS_COFINS(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>"><?php echo e($c); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div style="width: 400px"></div>
                                        </td>
                                        <td>
                                            <select name="cst_cofins[]" class="form-control select2">
                                                <?php $__currentLoopData = App\Models\Produto::listaCST_PIS_COFINS(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>"><?php echo e($c); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div style="width: 400px"></div>
                                        </td>
                                        <td>
                                            <select name="cst_ipi[]" class="form-control select2">
                                                <?php $__currentLoopData = App\Models\Produto::listaCST_IPI(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>"><?php echo e($c); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div style="width: 400px"></div>
                                        </td>
                                        <td>
                                            <input class="form-control ignore" maxlength="15" type="text" name="xPed[]">
                                            <div style="width: 200px"></div>
                                        </td>
                                        <td>
                                            <input class="form-control ignore" maxlength="6" type="text" name="nItemPed[]">
                                            <div style="width: 200px"></div>
                                        </td>
                                        <td>
                                            <input class="form-control ignore" maxlength="200" type="text" name="infAdProd[]">
                                            <div style="width: 300px"></div>
                                        </td>
                                        <td width="30">
                                            <button class="btn btn-danger btn-remove-tr">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="row col-12 col-lg-2 mt-3">
                            <br>
                            <button type="button" class="btn btn-dark btn-add-tr-nfe px-2">
                                <i class="ri-add-fill"></i>
                                Adicionar Produto
                            </button>
                        </div>
                        <div class="mt-3">
                            <h5>Total de Produtos: <strong class="total_prod">R$</strong></h5>
                        </div>
                        <input type="hidden" class="total_prod" name="valor_produtos" id="" value="">

                    </div>
                </div>
            </div>
            <div class="tab-pane fade show" id="transportadora" role="tabpanel">
                <div class="card">
                    <div class="row m-3">
                        <div class="col-md-5">
                            <?php echo Form::select('transportadora_id', 'Transportadora',['' => 'Selecione..'] + $transportadoras->pluck('razao_social', 'id')->all())
                            ->attrs(['class' => 'select2 transportadora_id']); ?>

                        </div>
                        <hr class="mt-3">
                        <div class="row">
                            <div class="col-md-3">
                                <?php echo Form::text('razao_social_transp', 'Razão Social')
                                ->value(isset($item->transportadora) ? $item->transportadora->razao_social : ''); ?>

                            </div>
                            <div class="col-md-3">
                                <?php echo Form::text('nome_fantasia_transp', 'Nome Fantasia')
                                ->value(isset($item->transportadora) ? $item->transportadora->nome : ''); ?>

                            </div>
                            <div class="col-md-2">
                                <?php echo Form::tel('cpf_cnpj_transp', 'CNPJ')
                                ->attrs(['class' => 'cpf_cnpj'])
                                ->value(isset($item->transportadora) ? $item->transportadora->cpf_cnpj : ''); ?>

                            </div>
                            <div class="col-md-2">
                                <?php echo Form::tel('ie_transp', 'Incrição Estadual')
                                ->value(isset($item->transportadora) ? $item->transportadora->ie : ''); ?>

                            </div>
                            <div class="col-md-2">
                                <?php echo Form::tel('antt', 'ANTT')
                                ->value(isset($item->transportadora) ? $item->transportadora->antt : ''); ?>

                            </div>
                            <div class="col-md-3 mt-3">
                                <?php echo Form::tel('rua_transp', 'Rua')
                                ->value(isset($item->transportadora) ? $item->transportadora->rua : ''); ?>

                            </div>
                            <div class="col-md-1 mt-3">
                                <?php echo Form::tel('numero_transp', 'Número')
                                ->value(isset($item->transportadora) ? $item->transportadora->numero : ''); ?>

                            </div>
                            <div class="col-md-3 mt-3">
                                <?php echo Form::select('cidade_transp', 'Cidade')
                                ->attrs(['class' => 'select2 cidade_select2'])
                                ->options(isset($item->transportadora) && isset($item->transportadora->cidade) ? [$item->transportadora->cidade_id => $item->transportadora->cidade->nome] : []); ?>

                            </div>
                            <div class="col-md-2 mt-3">
                                <?php echo Form::tel('cep_transp', 'CEP')
                                ->attrs(['class' => 'cep'])
                                ->value(isset($item->transportadora) ? $item->transportadora->cep : ''); ?>

                            </div>
                            <div class="col-md-3 mt-3">
                                <?php echo Form::text('email_transp', 'E-mail')
                                ->value(isset($item->transportadora) ? $item->transportadora->email : ''); ?>

                            </div>
                            <div class="col-md-2 mt-3">
                                <?php echo Form::tel('telefone_transp', 'Telefone')
                                ->attrs(['class' => 'fone'])
                                ->value(isset($item->transportadora) ? $item->transportadora->telefone : ''); ?>

                            </div>
                            <div class="col-md-3 mt-3">
                                <?php echo Form::text('bairro_transp', 'Bairro')
                                ->value(isset($item->transportadora) ? $item->transportadora->bairro : ''); ?>

                            </div>
                            <div class="col-md-3 mt-3">
                                <?php echo Form::text('complemento_transp', 'Complemento')
                                ->value(isset($item->transportadora) ? $item->transportadora->complemento : ''); ?>

                            </div>
                            <hr class="mt-3">
                            <h4 class="mt-3">Informações do Frete</h4>
                            <div class="col-md-2 mt-2">
                                <?php echo Form::tel('valor_frete', 'Valor do Frete')
                                ->attrs(['class' => 'moeda valor_frete'])
                                ->value(isset($item) ? __moeda($item->valor_frete) : (isset($cotacao) ? __moeda($cotacao->valor_frete) : '')); ?>

                            </div>
                            <div class="col-md-2 mt-2">
                                <?php echo Form::tel('qtd_volumes', 'Qtd de Volumes')
                                ->attrs(['class' => '']); ?>

                            </div>
                            <div class="col-md-2 mt-2">
                                <?php echo Form::tel('numeracao_volumes', 'Número de Volumes')
                                ->attrs(['class' => '']); ?>

                            </div>
                            <div class="col-md-2 mt-2">
                                <?php echo Form::tel('peso_bruto', 'Peso Bruto')
                                ->attrs(['class' => 'peso']); ?>

                            </div>
                            <div class="col-md-2 mt-2">
                                <?php echo Form::tel('peso_liquido', 'Peso Líquido')
                                ->attrs(['class' => 'peso']); ?>

                            </div>
                            <div class="col-md-3 mt-3">
                                <?php echo Form::text('especie', 'Espécie')
                                ->attrs(['class' => '']); ?>

                            </div>
                            <div class="col-md-3 mt-3">
                                <?php echo Form::select('tipo', 'Tipo', App\Models\Nfe::tiposFrete())
                                ->attrs(['class' => 'form-select']); ?>

                            </div>
                            <div class="col-md-2 mt-3">
                                <?php echo Form::text('placa', 'Placa')
                                ->attrs(['class' => 'placa']); ?>

                            </div>
                            <div class="col-md-1 mt-3">
                                <?php echo Form::select('uf', 'UF', App\Models\Cidade::estados())
                                ->attrs(['class' => 'form-select']); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade show" id="fatura" role="tabpanel">
                <div class="card">
                    <div class="row m-3">
                        <div class="col-md-3">
                            <?php echo Form::tel('acrescimo', 'Acréscimo')
                            ->attrs(['class' =>'acrescimo moeda'])
                            ->value(isset($item) ? __moeda($item->acrescimo) : ''); ?>

                        </div>
                        <div class="col-md-3">
                            <?php echo Form::tel('desconto', 'Desconto')
                            ->attrs(['class' => 'desconto moeda'])
                            ->value(isset($item) ? __moeda($item->desconto) : ''); ?>

                        </div>
                        <div class="col-md-6">
                            <?php echo Form::text('observacao', 'Observação')
                            ->attrs(['class' => '']); ?>

                        </div>
                        
                        <?php if(!isset($item)): ?>
                        <div class="col-md-2 mt-3 div-conta-receber">
                            <?php echo Form::select('gerar_conta_receber', 'Gerar conta a receber', [
                            0 => 'Não',
                            1 => 'Sim'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <?php else: ?>
                        <?php if(isset($item) && $item->orcamento == 0): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('conta_receber_create')): ?>
                        <div class="col-md-2 mt-3 div-conta-receber">
                            <?php echo Form::select('gerar_conta_receber', 'Gerar conta a receber', [
                            0 => 'Não',
                            1 => 'Sim'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <?php endif; ?>

                        <?php endif; ?>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('conta_pagar_create')): ?>
                        <div class="col-md-2 mt-3 div-conta-pagar d-none">
                            <?php echo Form::select('gerar_conta_pagar', 'Gerar conta a pagar', [
                            0 => 'Não',
                            1 => 'Sim'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <?php endif; ?>

                        <?php if(isset($isOrcamento) && $isOrcamento == 1): ?>
                        <input type="hidden" value="1" name="orcamento">
                        <?php else: ?>
                        <?php if(!isset($isCompra)): ?>
                        <?php if(!isset($item)): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orcamento_create')): ?>
                        <div class="col-md-2 mt-3">
                            <?php echo Form::select('orcamento', 'Salvar como Orçamento', [
                            0 => 'Não',
                            1 => 'Sim'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <?php endif; ?>
                        <?php endif; ?>
                        <?php endif; ?>
                        <?php endif; ?>

                        <?php if(!isset($isCompra)): ?>
                        <div class="col-md-3 mt-3">
                            <?php echo Form::select('funcionario_id', 'Vendedor')
                            ->options(isset($item) && $item->funcionario ? [$item->funcionario->id => $item->funcionario->nome] : []); ?>

                        </div>
                        <?php endif; ?>

                    </div>
                </div>
                <div class="card mt-1">
                    <div class="row m-3">
                        <div class="col-12">

                            <button type="button" class="btn btn-dark px-5 btn-gerar-fatura">
                                <i class="ri-list-indefinite"></i>
                                Gerar Fatura
                            </button>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-dynamic table-fatura" style="width: 800px">
                                <thead>
                                    <tr>
                                        <th>Tipo de Pagamento</th>
                                        <th>Data Vencimento</th>
                                        <th>Valor</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody id="body-pagamento" class="datatable-body">
                                    <?php if(isset($cotacao)): ?>
                                    <?php if(sizeof($cotacao->fatura) > 0): ?>
                                    <?php $__currentLoopData = $cotacao->fatura; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="dynamic-form">
                                        <td width="300">
                                            <select name="tipo_pagamento[]" class="form-control tipo_pagamento select2">
                                                <option value="">Selecione..</option>
                                                <?php $__currentLoopData = App\Models\Nfe::tiposPagamento(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php if($f->tipo_pagamento == $key): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($c); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </td>
                                        <td width="150">
                                            <input value="<?php echo e($f->data_vencimento); ?>" type="date" class="form-control" name="data_vencimento[]" id="">
                                        </td>
                                        <td width="150">
                                            <input value="<?php echo e(__moeda($f->valor)); ?>" type="tel" class="form-control moeda valor_fatura" name="valor_fatura[]">
                                        </td>
                                        <td width="30">
                                            <button class="btn btn-danger btn-remove-tr">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <tr class="dynamic-form">
                                        <td width="300">
                                            <select name="tipo_pagamento[]" class="form-control tipo_pagamento select2">
                                                <option value="">Selecione..</option>
                                                <?php $__currentLoopData = App\Models\Nfe::tiposPagamento(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>"><?php echo e($c); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </td>
                                        <td width="150">
                                            <input type="date" class="form-control date_atual" name="data_vencimento[]" id="" value="">
                                        </td>
                                        <td width="150">
                                            <input type="tel" class="form-control moeda valor_fatura" name="valor_fatura[]" id="valor">
                                        </td>
                                        <td width="30">
                                            <button class="btn btn-danger btn-remove-tr">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                    
                                    <?php else: ?>
                                    <?php if(isset($item) && isset($item->fatura) && sizeof($item->fatura) > 0 && !isset($isOrdemServico)): ?>
                                    <?php $__currentLoopData = $item->fatura; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="dynamic-form">
                                        <td width="300">
                                            <select name="tipo_pagamento[]" class="form-control tipo_pagamento select2">
                                                <option value="">Selecione..</option>
                                                <?php $__currentLoopData = App\Models\Nfe::tiposPagamento(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php if($f->tipo_pagamento == $key): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($c); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </td>
                                        <td width="150">
                                            <input value="<?php echo e($f->data_vencimento); ?>" type="date" class="form-control" name="data_vencimento[]" id="">
                                        </td>
                                        <td width="150">
                                            <input value="<?php echo e(__moeda($f->valor)); ?>" type="tel" class="form-control moeda valor_fatura" name="valor_fatura[]" id="valor">
                                        </td>
                                        <td width="30">
                                            <button class="btn btn-danger btn-remove-tr">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>

                                    <tr class="dynamic-form">
                                        <td width="300">
                                            <select name="tipo_pagamento[]" class="form-control tipo_pagamento select2">
                                                <option value="">Selecione..</option>
                                                <?php $__currentLoopData = App\Models\Nfe::tiposPagamento(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>"><?php echo e($c); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </td>
                                        <td width="150">
                                            <input type="date" class="form-control date_atual" name="data_vencimento[]" id="" value="">
                                        </td>
                                        <td width="150">
                                            <input type="tel" class="form-control moeda valor_fatura" name="valor_fatura[]" id="valor">
                                        </td>
                                        <td width="30">
                                            <button class="btn btn-danger btn-remove-tr">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    
                                    <?php endif; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <button type="button" class="btn btn-info btn-add-tr px-5">
                                    <i class="ri-add-fill"></i>
                                    Adicionar Pagamento
                                </button>
                            </div>
                        </div>
                        <div class="col-3 mt-4">
                            <h5>Total da Fatura: <strong class="total_fatura">R$</strong></h5>
                        </div>
                        <div class="col-3 mt-4">
                            <h5>Total de Produtos: <strong class="total_prod">R$</strong></h5>
                        </div>
                        <div class="col-3 mt-4">
                            <h5>Total do Frete: <strong class="total_frete">R$</strong></h5>
                        </div>
                        <div class="col-3 mt-4">
                            <h5>Total da NFe: <strong class="total_nfe text-success">R$</strong></h5>
                        </div>
                        <input type="hidden" class="valor_total" name="valor_total" id="" value="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <hr class="mt-4">
    <div class="col-12" style="text-align: right;">
        <button type="submit" class="btn btn-success btn-salvar-nfe px-5 m-3">Salvar</button>
    </div>
</div>

<?php echo $__env->make('modals._cartao_credito', ['not_submit' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._variacao', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._fatura_venda', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
// Função para limpar espaços do campo referencia
function limparEspacosReferencia(input) {
    if (input.value) {
        // Remove todos os espaços, pontos, hífens e outros caracteres especiais
        input.value = input.value.replace(/[\s\-\.]/g, '');
        
        // Verifica se tem exatamente 44 dígitos apenas se o usuário interagiu com o campo
        if (input.value.length !== 44 && input === document.activeElement) {
            swal({
                title: "Erro de Validação",
                text: "A chave de referência deve ter exatamente 44 dígitos!",
                icon: "error",
                button: "OK"
            });
            input.focus();
        }
    }
}

// Aplicar limpeza também no carregamento da página
document.addEventListener('DOMContentLoaded', function() {
    var campoReferencia = document.querySelector('input[name=\"referencia\"]');
    if (campoReferencia && campoReferencia.value) {
        // Apenas limpar espaços, sem validar automaticamente
        campoReferencia.value = campoReferencia.value.replace(/[\s\-\.]/g, '');
    }
    
    // Validação para NFe de devolução
    var campoFinNFe = document.querySelector('select[name=\"finNFe\"]');
    var campoReferencia = document.querySelector('#campo-referencia');
    
    if (campoFinNFe && campoReferencia) {
        campoFinNFe.addEventListener('change', function() {
            if (this.value == '4') {
                campoReferencia.setAttribute('required', 'required');
                campoReferencia.classList.add('is-invalid');
                campoReferencia.setAttribute('placeholder', 'Referência NFe (OBRIGATÓRIO para devolução)');
            } else {
                campoReferencia.removeAttribute('required');
                campoReferencia.classList.remove('is-invalid');
                campoReferencia.setAttribute('placeholder', 'Referência NFe');
            }
        });
        
        // Verificar estado inicial
        if (campoFinNFe.value == '4') {
            campoReferencia.setAttribute('required', 'required');
            campoReferencia.classList.add('is-invalid');
            campoReferencia.setAttribute('placeholder', 'Referência NFe (OBRIGATÓRIO para devolução)');
        }
        
        // Para devolução, permitir que o usuário escolha o tipo NFe
        var campoTpNF = document.querySelector('select[name=\"tpNF\"]');
        if (campoFinNFe && campoTpNF) {
            campoFinNFe.addEventListener('change', function() {
                if (this.value == '4') {
                    // Para devolução de mercadoria, manter o tpNF selecionado pelo usuário
                    campoTpNF.disabled = false; // Permitir alteração
                    console.log('Devolução selecionada - tpNF mantido conforme seleção do usuário');
                } else {
                    campoTpNF.disabled = false; // Habilitar novamente
                    console.log('Outra finalidade selecionada - tpNF habilitado');
                }
            });
            
            // Verificar estado inicial
            if (campoFinNFe.value == '4') {
                campoTpNF.disabled = false; // Permitir alteração
                console.log('Estado inicial - Devolução detectada, tpNF mantido conforme seleção');
            }
        }

        // Validação com SweetAlert apenas no envio do formulário
        var form = document.querySelector('form');
        if (form) {
            form.addEventListener('submit', function(e) {
                if (campoFinNFe.value == '4') {
                    if (!campoReferencia.value || campoReferencia.value.length < 44) {
                        e.preventDefault();
                        swal({
                            title: "Erro de Validação",
                            text: "NFe de devolução deve possuir documento fiscal referenciado com 44 dígitos.",
                            icon: "error",
                            button: "OK"
                        });
                        campoReferencia.focus();
                        return false;
                    }
                }
            });
        }
    }
});
</script>


<?php /**PATH C:\laragon\www\erp\resources\views/nfe/_forms.blade.php ENDPATH**/ ?>