<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('consignacoes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('empresa_id');
            $table->unsignedBigInteger('usuario_id');
            $table->unsignedBigInteger('cliente_id');
            $table->unsignedBigInteger('funcionario_id');
            $table->string('numero_consignacao')->unique();
            $table->datetime('data_consignacao');
            $table->datetime('data_vencimento')->nullable();
            $table->decimal('valor_total', 10, 2)->default(0);
            $table->text('observacao')->nullable();
            $table->enum('status', ['ativa', 'finalizada', 'cancelada'])->default('ativa');
            $table->unsignedBigInteger('nfce_id')->nullable(); // ID da NFCe quando convertida em venda
            $table->unsignedBigInteger('comprovante_nao_fiscal_id')->nullable(); // ID do comprovante quando convertida em venda não fiscal
            $table->unsignedBigInteger('local_id')->nullable();
            $table->timestamps();

            $table->foreign('empresa_id')->references('id')->on('empresas')->onDelete('cascade');
            $table->foreign('usuario_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('cliente_id')->references('id')->on('clientes')->onDelete('cascade');
            $table->foreign('funcionario_id')->references('id')->on('funcionarios')->onDelete('cascade');
            $table->foreign('nfce_id')->references('id')->on('nfces')->onDelete('set null');
            $table->foreign('local_id')->references('id')->on('localizacaos')->onDelete('set null');

            $table->index(['empresa_id', 'status']);
            $table->index(['cliente_id', 'status']);
            $table->index(['funcionario_id', 'status']);
            $table->index('data_consignacao');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('consignacoes');
    }
};
