<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDevolucoesTabelas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('devolucoes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('empresa_id');
            $table->unsignedBigInteger('usuario_id');
            $table->unsignedBigInteger('venda_id');
            $table->string('tipo_venda', 10); // 'nfe' ou 'nfce'
            $table->decimal('valor_total', 10, 2);
            $table->string('tipo_pagamento', 10);
            $table->unsignedBigInteger('cliente_id')->nullable();
            $table->text('observacao')->nullable();
            $table->timestamp('data_devolucao');
            $table->timestamps();
            
            $table->foreign('empresa_id')->references('id')->on('empresas');
            $table->foreign('usuario_id')->references('id')->on('users');
            $table->foreign('cliente_id')->references('id')->on('clientes');
        });
        
        Schema::create('itens_devolucao', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('devolucao_id');
            $table->unsignedBigInteger('item_id');
            $table->string('tipo_item', 20); // 'item_nfe' ou 'item_nfce'
            $table->decimal('quantidade', 10, 3);
            $table->decimal('valor_unitario', 10, 2);
            $table->unsignedBigInteger('produto_id');
            $table->unsignedBigInteger('variacao_id')->nullable();
            $table->timestamps();
            
            $table->foreign('devolucao_id')->references('id')->on('devolucoes')->onDelete('cascade');
            $table->foreign('produto_id')->references('id')->on('produtos');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('itens_devolucao');
        Schema::dropIfExists('devolucoes');
    }
} 