<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\NewLead;

class LeadController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:20',
        ]);

        // Envia o e-mail
        Mail::to(env('MAIL_NOVAEMPRESA'))->send(new NewLead($validated));

        return back()->with('success', 'Obrigado! Em breve nossa equipe entrará em contato.');
    }
} 