# 📋 Collection do Postman - Sistema ERP

Esta collection contém todos os endpoints principais do sistema ERP para uso no Postman.

## 📁 Arquivos

- `ERP_System_Postman_Collection.json` - Collection principal com endpoints básicos
- `ERP_System_Additional_Endpoints.json` - Endpoints adicionais específicos
- `README_Postman_Collection.md` - Este arquivo de documentação

## 🚀 Como Importar

1. Abra o Postman
2. Clique em "Import" (botão no canto superior esquerdo)
3. Arraste o arquivo `ERP_System_Postman_Collection.json` para a área de importação
4. Clique em "Import"

## ⚙️ Configuração Inicial

### 1. Variáveis de Ambiente

Após importar, configure as seguintes variáveis:

- `base_url`: URL base do seu sistema (ex: `http://localhost:8000`)
- `auth_token`: Token de autenticação (será preenchido após login)
- `empresa_id`: ID da empresa (padrão: `1`)

### 2. Autenticação

1. Execute o endpoint "Login" em `🔐 Autenticação`
2. Copie o token retornado
3. Cole o token na variável `auth_token`

## 📋 Estrutura da Collection

### 🔐 Autenticação
- **Login**: Autenticação do usuário
- **Logout**: Encerrar sessão

### 🏥 Health Check
- **Health Check**: Verificar status do sistema

### 📦 Produtos
- **Listar Produtos**: GET `/produtos`
- **Buscar Produto por ID**: GET `/produtos/{id}`
- **Criar Produto**: POST `/produtos`
- **Atualizar Produto**: PUT `/produtos/{id}`
- **Deletar Produto**: DELETE `/produtos/{id}`
- **Buscar por Código de Barras**: GET `/api/produtos/findByBarcode`
- **Produtos com Estoque**: GET `/api/produtos/com-estoque`

### 👥 Clientes
- **Listar Clientes**: GET `/clientes`
- **Buscar Cliente por ID**: GET `/clientes/{id}`
- **Criar Cliente**: POST `/clientes`
- **Atualizar Cliente**: PUT `/clientes/{id}`
- **Deletar Cliente**: DELETE `/clientes/{id}`
- **Buscar por Nome**: GET `/api/clientes/find`
- **Histórico do Cliente**: GET `/clientes/historico/{id}`

### 💰 Vendas (PDV)
- **Listar Vendas**: GET `/frontbox`
- **Criar Venda**: POST `/frontbox`
- **Buscar Venda por ID**: GET `/frontbox/{id}`
- **Adicionar Produto à Venda**: GET `/api/frenteCaixa/linhaProdutoVendaAdd`
- **Imprimir Venda**: GET `/frontbox/imprimir/{id}`

### 📄 Documentos Fiscais
- **NFe - Listar**: GET `/nfe`
- **NFe - Criar**: POST `/nfe`
- **NFe - Emitir**: POST `/api/nfe/emitir`
- **NFCe - Listar**: GET `/nfce`
- **NFCe - Criar**: POST `/nfce`
- **NFCe - Emitir**: POST `/api/nfce/emitir`

### 💳 Financeiro
- **Contas a Receber - Listar**: GET `/conta-receber`
- **Contas a Receber - Criar**: POST `/conta-receber`
- **Contas a Pagar - Listar**: GET `/conta-pagar`
- **Contas a Pagar - Criar**: POST `/conta-pagar`

### 📊 Relatórios
- **Relatório de Vendas**: GET `/relatorios/vendas`
- **Relatório de Estoque**: GET `/relatorios/estoque`
- **Relatório de Clientes**: GET `/relatorios/clientes`

### 🛠️ Utilitários
- **Buscar Cidade por Nome**: GET `/api/cidadePorNome/{nome}`
- **Buscar Cidade por Código IBGE**: GET `/api/cidadePorCodigoIbge/{codigo}`
- **Listar Contas da Empresa**: GET `/api/contas-empresa`

## 🔧 Endpoints Adicionais

### 📋 Fornecedores
- **Listar Fornecedores**: GET `/fornecedores`
- **Buscar Fornecedor por ID**: GET `/api/fornecedores/find/{id}`
- **Criar Fornecedor**: POST `/fornecedores`

### 👨‍💼 Funcionários
- **Listar Funcionários**: GET `/funcionarios`
- **Buscar Funcionário**: GET `/api/funcionarios/find`

### 📦 Estoque
- **Listar Estoque**: GET `/estoque`
- **Movimentação de Produto**: GET `/produtos/movimentacao/{id}`
- **Validar Estoque**: GET `/api/produtos/valida-estoque`

### 🛒 Compras
- **Listar Compras**: GET `/compras`
- **Criar Compra**: POST `/compras`

### 📋 Ordem de Serviço
- **Listar Ordens de Serviço**: GET `/ordem-servico`
- **Criar Ordem de Serviço**: POST `/ordem-servico`
- **Buscar Ordem de Serviço**: GET `/api/ordemServico/find/{id}`

### 📊 Gráficos e Dashboards
- **Gráfico de Vendas por Mês**: GET `/api/graficos/grafico-vendas-mes`
- **Gráfico de Compras por Mês**: GET `/api/graficos/grafico-compras-mes`
- **Dados dos Cards**: GET `/api/graficos/dados-cards`

### 🔄 Consignação
- **Buscar Produtos Consignação**: GET `/api/consignacao/produtos`
- **Buscar Produto por Código**: GET `/api/consignacao/produto-codigo`
- **Calcular Total Consignação**: POST `/api/consignacao/calcular-total`

### 📱 Delivery
- **Categorias Delivery**: GET `/api/delivery/categorias`
- **Produto Delivery**: GET `/api/delivery/produto/{id}`
- **Configuração Delivery**: GET `/api/delivery/config`

### 🛍️ E-commerce
- **Calcular Frete**: GET `/api/ecommerce/calcular-frete`
- **Validar Email**: GET `/api/ecommerce/valida-email`

## 📝 Exemplos de Uso

### Criar um Produto
```json
POST /produtos
{
  "nome": "Produto Teste",
  "codigo_barras": "7891234567890",
  "categoria_id": 1,
  "preco_venda": 10.50,
  "preco_custo": 8.00,
  "estoque_minimo": 5,
  "estoque_atual": 100,
  "empresa_id": 1
}
```

### Criar um Cliente
```json
POST /clientes
{
  "razao_social": "Cliente Teste LTDA",
  "nome_fantasia": "Cliente Teste",
  "cpf_cnpj": "12.345.678/0001-90",
  "ie": "123456789",
  "email": "cliente@teste.com",
  "telefone": "(11) 99999-9999",
  "cep": "01234-567",
  "endereco": "Rua Teste, 123",
  "bairro": "Centro",
  "cidade_id": 1,
  "empresa_id": 1
}
```

### Criar uma Venda
```json
POST /frontbox
{
  "cliente_id": 1,
  "funcionario_id": 1,
  "itens": [
    {
      "produto_id": 1,
      "quantidade": 2,
      "valor_unitario": 10.50,
      "valor_total": 21.00
    }
  ],
  "valor_total": 21.00,
  "forma_pagamento": "dinheiro",
  "empresa_id": 1
}
```

## 🔐 Autenticação e Permissões

O sistema utiliza autenticação baseada em tokens. Alguns endpoints requerem permissões específicas:

- `produtos_create`: Criar produtos
- `produtos_edit`: Editar produtos
- `produtos_view`: Visualizar produtos
- `produtos_delete`: Deletar produtos
- `clientes_create`: Criar clientes
- `clientes_edit`: Editar clientes
- `clientes_view`: Visualizar clientes
- `clientes_delete`: Deletar clientes
- `pdv_create`: Criar vendas
- `pdv_edit`: Editar vendas
- `pdv_view`: Visualizar vendas
- `pdv_delete`: Deletar vendas

## 🚨 Observações Importantes

1. **Autenticação**: Sempre faça login antes de usar outros endpoints
2. **Empresa ID**: Certifique-se de que a variável `empresa_id` está configurada corretamente
3. **Permissões**: Verifique se o usuário tem as permissões necessárias para cada operação
4. **Validação**: Todos os endpoints fazem validação dos dados enviados
5. **Paginação**: Endpoints de listagem suportam paginação com parâmetros `page` e `per_page`

## 🔧 Troubleshooting

### Erro 401 - Unauthorized
- Verifique se o token de autenticação está válido
- Faça login novamente se necessário

### Erro 403 - Forbidden
- Verifique se o usuário tem as permissões necessárias
- Entre em contato com o administrador do sistema

### Erro 422 - Validation Error
- Verifique se todos os campos obrigatórios foram preenchidos
- Confirme se os tipos de dados estão corretos

### Erro 500 - Internal Server Error
- Verifique se o servidor está rodando
- Consulte os logs do sistema

## 📞 Suporte

Para dúvidas ou problemas com a collection, entre em contato com a equipe de desenvolvimento.

---

**Versão**: 1.0  
**Data**: 2024  
**Sistema**: ERP Laravel 