<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Verificar se o usuário é admin
if (!isset($_SESSION['is_admin']) || $_SESSION['is_admin'] != 1) {
    header("Location: lancamentos.php");
    exit();
}

require_once 'config/database.php';
$database = new Database();
$db = $database->getConnection();

// Buscar logs
$query = "SELECT l.*, u.nome as usuario_nome, DATE_FORMAT(l.data_hora, '%d/%m/%Y %H:%i:%s') as data_formatada
          FROM logs l
          JOIN usuarios u ON l.usuario_id = u.id
          ORDER BY l.data_hora DESC";
$stmt = $db->prepare($query);
$stmt->execute();
$logs = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Definir título da página
$titulo = "Logs do Sistema";

// Conteúdo da página
ob_start();
?>

<!-- Conteúdo Principal -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Logs do Sistema</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table" id="logsTable">
                <thead>
                    <tr>
                        <th>Data/Hora</th>
                        <th>Usuário</th>
                        <th>Ação</th>
                        <th>Tabela</th>
                        <th>Detalhes</th>
                        <th>Justificativa</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($logs as $log): ?>
                        <tr>
                            <td><?php echo $log['data_formatada']; ?></td>
                            <td><?php echo htmlspecialchars($log['usuario_nome']); ?></td>
                            <td>
                                <span class="badge <?php 
                                    echo match($log['acao']) {
                                        'criar' => 'bg-success',
                                        'editar' => 'bg-primary',
                                        'excluir' => 'bg-danger',
                                        'pagar' => 'bg-info',
                                        default => 'bg-secondary'
                                    };
                                ?>">
                                    <?php echo ucfirst($log['acao']); ?>
                                </span>
                            </td>
                            <td><?php echo ucfirst($log['tabela']); ?></td>
                            <td>
                                <button type="button" class="btn btn-sm btn-info" onclick="verDetalhes('<?php 
                                    echo htmlspecialchars(json_encode([
                                        'dados_anteriores' => json_decode($log['dados_anteriores'], true),
                                        'dados_novos' => json_decode($log['dados_novos'], true)
                                    ]), ENT_QUOTES);
                                ?>')">
                                    <i class="fas fa-eye"></i> Ver
                                </button>
                            </td>
                            <td>
                                <?php if ($log['justificativa']): ?>
                                    <button type="button" class="btn btn-sm btn-secondary" onclick="verJustificativa('<?php echo htmlspecialchars($log['justificativa']); ?>')">
                                        <i class="fas fa-comment"></i> Ver
                                    </button>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal de Detalhes -->
<div class="modal fade" id="modalDetalhes" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detalhes do Log</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6>Dados Anteriores:</h6>
                        <pre id="dadosAnteriores" class="bg-light p-2" style="max-height: 300px; overflow-y: auto;"></pre>
                    </div>
                    <div class="col-md-6">
                        <h6>Dados Novos:</h6>
                        <pre id="dadosNovos" class="bg-light p-2" style="max-height: 300px; overflow-y: auto;"></pre>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Justificativa -->
<div class="modal fade" id="modalJustificativa" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Justificativa</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p id="textoJustificativa"></p>
            </div>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();

// JavaScript adicional
$extra_js = '
<script>
$(document).ready(function() {
    $("#logsTable").DataTable({
        language: {
            url: "//cdn.datatables.net/plug-ins/1.11.5/i18n/pt-BR.json"
        },
        order: [[0, "desc"]], // Ordenar por data/hora decrescente
        pageLength: 10,
        lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]]
    });
});

function verDetalhes(dados) {
    const json = JSON.parse(dados);
    $("#dadosAnteriores").text(JSON.stringify(json.dados_anteriores, null, 2));
    $("#dadosNovos").text(JSON.stringify(json.dados_novos, null, 2));
    new bootstrap.Modal(document.getElementById("modalDetalhes")).show();
}

function verJustificativa(texto) {
    $("#textoJustificativa").text(texto);
    new bootstrap.Modal(document.getElementById("modalJustificativa")).show();
}
</script>
';

// Incluir o layout
require_once 'includes/layout.php';
?>
