<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

require_once 'config/database.php';
$database = new Database();
$db = $database->getConnection();

// Processar formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'criar' || $_POST['action'] === 'editar') {
        $nome = $_POST['nome'];
        
        if ($_POST['action'] === 'criar') {
            $query = "INSERT INTO formas_pagamento (nome, ativo) VALUES (:nome, 1)";
        } else {
            $id = $_POST['id'];
            $query = "UPDATE formas_pagamento SET nome = :nome WHERE id = :id";
        }
        
        $stmt = $db->prepare($query);
        $stmt->bindParam(':nome', $nome);
        if ($_POST['action'] === 'editar') {
            $stmt->bindParam(':id', $id);
        }
        
        if ($stmt->execute()) {
            header("Location: formas_pagamento.php");
            exit();
        }
    } elseif ($_POST['action'] === 'desativar' && isset($_POST['id'])) {
        $id = $_POST['id'];
        $query = "UPDATE formas_pagamento SET ativo = 0 WHERE id = :id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $id);
        
        if ($stmt->execute()) {
            header("Location: formas_pagamento.php");
            exit();
        }
    }
}

// Buscar formas de pagamento
$query = "SELECT * FROM formas_pagamento ORDER BY nome";
$stmt = $db->prepare($query);
$stmt->execute();
$formas_pagamento = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Definir título da página
$titulo = "Formas de Pagamento";

// Conteúdo da página
ob_start();
?>

<!-- Modal de Forma de Pagamento -->
<div class="modal fade" id="formaPagamentoModal" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Forma de Pagamento</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="formaPagamentoForm" method="POST">
                    <input type="hidden" name="action" value="criar">
                    <input type="hidden" name="id" value="">
                    
                    <div class="mb-3">
                        <label for="nome" class="form-label">Nome</label>
                        <input type="text" class="form-control" id="nome" name="nome" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="submit" form="formaPagamentoForm" class="btn btn-primary">Salvar</button>
            </div>
        </div>
    </div>
</div>

<!-- Conteúdo Principal -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Formas de Pagamento</h5>
        <button type="button" class="btn btn-primary" onclick="novaFormaPagamento()">
            Nova Forma de Pagamento
        </button>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table" id="formasPagamentoTable">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Status</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($formas_pagamento as $forma): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($forma['nome']); ?></td>
                            <td>
                                <span class="badge <?php echo $forma['ativo'] ? 'bg-success' : 'bg-danger'; ?>">
                                    <?php echo $forma['ativo'] ? 'Ativo' : 'Inativo'; ?>
                                </span>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-sm btn-primary" onclick='editarFormaPagamento(<?php echo json_encode($forma); ?>)'>
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <?php if ($forma['ativo']): ?>
                                        <button type="button" class="btn btn-sm btn-danger" onclick='desativarFormaPagamento(<?php echo $forma["id"]; ?>)'>
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();

// JavaScript adicional
$extra_js = '
<script>
$(document).ready(function() {
    // Inicializar DataTable
    $("#formasPagamentoTable").DataTable({
        // Configurar o idioma para Português do Brasil
        language: {
            url: "//cdn.datatables.net/plug-ins/1.11.5/i18n/pt-BR.json"
        },
        // Definir a ordem padrão como nome crescente
        order: [[0, "asc"]],
        // Configurar o número de registros por página
        pageLength: 5,
        // Opções de quantidade de registros por página
        lengthMenu: [[5, 10, 25, 50], [5, 10, 25, 50]]
    });
});

function novaFormaPagamento() {
    $("#formaPagamentoForm")[0].reset();
    $("#formaPagamentoForm [name=action]").val("criar");
    $("#formaPagamentoForm [name=id]").val("");
    $("#formaPagamentoModal").modal("show");
}

function editarFormaPagamento(forma) {
    $("#formaPagamentoForm")[0].reset();
    $("#formaPagamentoForm [name=action]").val("editar");
    $("#formaPagamentoForm [name=id]").val(forma.id);
    $("#nome").val(forma.nome);
    $("#formaPagamentoModal").modal("show");
}

function desativarFormaPagamento(id) {
    if (confirm("Tem certeza que deseja desativar esta forma de pagamento?")) {
        const form = document.createElement("form");
        form.method = "POST";
        form.innerHTML = `
            <input type="hidden" name="action" value="desativar">
            <input type="hidden" name="id" value="${id}">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}
</script>
';

// Incluir o layout
require_once 'includes/layout.php';
?>
