# Sistema Financeiro

Sistema de gerenciamento financeiro desenvolvido em PHP para controle de lançamentos, contas a receber e fluxo de caixa.

## 📋 Requisitos

- PHP 7.4 ou superior
- MySQL 5.7 ou superior
- Servidor Web (Apache/XAMPP)
- Navegador Web atualizado

## 🚀 Instalação

1. Clone ou baixe este repositório para a pasta `htdocs` do seu XAMPP
2. Importe o arquivo `sql/database.sql` para criar o banco de dados e tabelas
3. Configure a conexão com o banco em `includes/conexao.php`
4. Acesse o sistema através do navegador: `http://localhost/caixa`

## 💻 Funcionalidades

### 1. Login e Controle de Acesso
- Acesse o sistema com seu usuário e senha
- Sistema de sessão para garantir a segurança

### 2. Lançamentos
- Registre entradas e saídas
- Selecione a forma de pagamento
- Adicione descrição e valor
- Visualize o histórico de lançamentos
- Filtre por período e tipo (entrada/saída)
- Imprima relatórios de lançamentos

### 3. Contas a Receber
- Cadastre contas a receber
- Registre pagamentos
- Acompanhe vencimentos
- Filtre por:
  - Período (data início e fim)
  - Status (Pago/Pendente)
- Imprima relatórios com totalizadores

### 4. Formas de Pagamento
- Gerencie as formas de pagamento disponíveis
- Adicione, edite ou desative formas de pagamento

## 📊 Relatórios

### Relatório de Lançamentos
- Visualize todos os lançamentos por período
- Totalizadores de entradas e saídas
- Saldo do período
- Opção de impressão formatada

### Relatório de Contas a Receber
- Lista de contas a receber por período
- Totalizadores:
  - Total Geral
  - Total Pendente
  - Total Pago
- Opção de impressão formatada

## 🔧 Uso do Sistema

### 1. Cadastrando um Lançamento
1. Acesse "Lançamentos" no menu
2. Clique em "Novo Lançamento"
3. Preencha:
   - Descrição
   - Valor
   - Tipo (Entrada/Saída)
   - Forma de Pagamento
   - Data
4. Clique em "Salvar"

### 2. Gerenciando Contas a Receber
1. Acesse "Contas a Receber" no menu
2. Visualize todas as contas cadastradas
3. Para registrar pagamento:
   - Clique no botão "Registrar Pagamento"
   - Informe a data do pagamento
   - Confirme a operação
4. Para filtrar:
   - Selecione o período desejado
   - Escolha o status (opcional)
   - Clique em "Filtrar"

### 3. Imprimindo Relatórios
1. Acesse a tela desejada (Lançamentos ou Contas a Receber)
2. Aplique os filtros necessários
3. Clique no botão "Imprimir"
4. O relatório será formatado para impressão
5. Use a função de impressão do navegador

## 🔍 Dicas e Boas Práticas

1. **Lançamentos**
   - Sempre confira os valores antes de salvar
   - Use descrições claras e objetivas
   - Mantenha as formas de pagamento atualizadas

2. **Contas a Receber**
   - Registre os pagamentos assim que recebidos
   - Acompanhe diariamente os vencimentos
   - Use os filtros para melhor organização

3. **Relatórios**
   - Faça backup periódico dos dados
   - Verifique os totalizadores antes de imprimir
   - Use os filtros para relatórios mais precisos

## 🆘 Suporte

Em caso de dúvidas ou problemas:
1. Verifique se todos os campos obrigatórios foram preenchidos
2. Confira a conexão com o banco de dados
3. Limpe o cache do navegador
4. Entre em contato com o suporte técnico

## 🔒 Segurança

- Faça logout ao sair do sistema
- Troque sua senha periodicamente
- Não compartilhe suas credenciais
- Mantenha o sistema e servidor atualizados

## 📝 Notas Importantes

- O sistema registra todas as operações realizadas
- Backup diário é recomendado
- Mantenha os dados do banco atualizados
- Utilize navegadores modernos para melhor experiência
