<?php
session_start();
require_once 'config/database.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Usuário não autenticado']);
    exit();
}

// Criar conexão com o banco de dados
$database = new Database();
$pdo = $database->getConnection();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['cheque_id'])) {
    $cheque_id = $_POST['cheque_id'];
    $user_id = $_SESSION['user_id'];
    
    try {
        $pdo->beginTransaction();
        
        // Verifica se o cheque pertence ao usuário atual e está pendente
        $stmt = $pdo->prepare("SELECT id FROM cheques WHERE id = :cheque_id AND user_id = :user_id AND status_pagamento = 'pendente'");
        $stmt->execute([
            ':cheque_id' => $cheque_id,
            ':user_id' => $user_id
        ]);
        
        if ($stmt->rowCount() > 0) {
            // Exclui o cheque
            $stmt = $pdo->prepare("DELETE FROM cheques WHERE id = :cheque_id AND user_id = :user_id");
            if ($stmt->execute([
                ':cheque_id' => $cheque_id,
                ':user_id' => $user_id
            ])) {
                $pdo->commit();
                echo json_encode(['success' => true, 'message' => 'Cheque excluído com sucesso']);
            } else {
                $pdo->rollBack();
                echo json_encode(['success' => false, 'message' => 'Erro ao excluir o cheque']);
            }
        } else {
            $pdo->rollBack();
            echo json_encode(['success' => false, 'message' => 'Cheque não encontrado, já foi quitado ou não pertence ao usuário']);
        }
    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log('Erro ao excluir cheque: ' . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'Erro ao excluir cheque. Por favor, tente novamente.']);
    }
    exit();
}

echo json_encode(['success' => false, 'message' => 'Requisição inválida']);
exit();
