$(document).ready(function() {
    // Máscara para campos de valor
    $('.money').mask('#.##0,00', {reverse: true});

    // Função para calcular juros
    window.calcularJuros = function() {
        const valor = $('#valor').val().replace(/\./g, '').replace(',', '.');
        const dataVencimento = new Date($('#data_vencimento').val());
        const dataTroca = new Date($('#data_troca').val());

        if (!valor || !dataVencimento || !dataTroca) {
            alert('Por favor, preencha todos os campos necessários.');
            return;
        }

        // Calcula a diferença em dias
        const diffTime = Math.abs(dataVencimento - dataTroca);
        const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));

        // Taxa de juros (4% ao mês)
        const taxaMensal = 0.04;
        const taxaDiaria = taxaMensal / 30;

        // Calcula juros
        const juros = valor * taxaDiaria * diffDays;
        const valorLiquido = parseFloat(valor) - juros;

        // Atualiza o resultado
        $('#valorChequeResult').text('R$ ' + parseFloat(valor).toLocaleString('pt-BR', { minimumFractionDigits: 2 }));
        $('#diasResult').text(diffDays + ' dias');
        $('#jurosResult').text('R$ ' + juros.toLocaleString('pt-BR', { minimumFractionDigits: 2 }));
        $('#valorLiquidoResult').text('R$ ' + valorLiquido.toLocaleString('pt-BR', { minimumFractionDigits: 2 }));

        // Mostra o resultado e o botão de salvar
        $('#resultado').show();
        $('.btn-salvar').show();

        // Armazena o cálculo atual
        calculoAtual = {
            valor: parseFloat(valor),
            dias: diffDays,
            juros: juros,
            valorLiquido: valorLiquido
        };
    }

    // Função para salvar cheque
    window.salvarCheque = function() {
        if (!calculoAtual) {
            alert('Por favor, calcule os valores primeiro.');
            return;
        }

        // Validar campos obrigatórios
        if (!$('#cliente').val().trim()) {
            alert('Por favor, preencha o nome do cliente.');
            $('#cliente').focus();
            return;
        }

        const formData = {
            cliente: $('#cliente').val().trim(),
            numero_cheque: $('#numero_cheque').val().trim(),
            banco: $('#banco').val().trim(),
            valor: calculoAtual.valor,
            data_troca: $('#data_troca').val(),
            data_vencimento: $('#data_vencimento').val(),
            juros: calculoAtual.juros,
            valor_liquido: calculoAtual.valorLiquido
        };

        // Mostrar loading
        $('.btn-salvar').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Salvando...');

        $.ajax({
            url: 'salvar_cheque.php',
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    alert('Cheque salvo com sucesso!');
                    window.location.reload();
                } else {
                    alert('Erro ao salvar: ' + (response.message || 'Erro desconhecido'));
                    console.error('Erro detalhado:', response.error);
                }
            },
            error: function(xhr, status, error) {
                console.error('Erro na requisição:', {
                    status: status,
                    error: error,
                    response: xhr.responseText
                });
                alert('Erro ao comunicar com o servidor. Verifique o console para mais detalhes.');
            },
            complete: function() {
                // Restaurar botão
                $('.btn-salvar').prop('disabled', false).html('<i class="fas fa-save"></i> Confirmar e Salvar');
            }
        });
    }
}); 