<?php
session_start();

// Verificar se o usuário está logado
if (!isset($_SESSION['usuario_id'])) {
    header('Location: login.php');
    exit;
}

$usuario_nome = $_SESSION['usuario_nome'] ?? 'Usuário';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>To-Do List - Sistema Moderno</title>
    <link rel="stylesheet" href="css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>
    <div class="container">
        <header class="header">
            <h1><i class="fas fa-tasks"></i> Minha Lista de Tarefas</h1>
            <div class="header-controls">
                <div class="user-info">
                    <span class="welcome-text">
                        <i class="fas fa-user"></i> Olá, <?php echo htmlspecialchars($usuario_nome); ?>!
                    </span>
                    <a href="auth.php?logout=1" class="btn-logout" title="Sair">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </a>
                </div>
                <button id="themeToggle" class="btn-theme">
                    <i class="fas fa-moon"></i>
                </button>
                <button id="addTaskBtn" class="btn-primary">
                    <i class="fas fa-plus"></i> Nova Tarefa
                </button>
            </div>
        </header>

        <div class="search-section">
            <div class="search-container">
                <i class="fas fa-search"></i>
                <input type="text" id="searchInput" placeholder="Buscar tarefas...">
            </div>
            <div class="filter-container">
                <input type="date" id="dateFilter" title="Filtrar por data">
                <button id="clearFilters" class="btn-secondary">
                    <i class="fas fa-times"></i> Limpar
                </button>
            </div>
        </div>

        <main class="main-content">
            <div id="tasksContainer" class="tasks-grid">
                <!-- Tarefas serão carregadas aqui -->
            </div>
            
            <div id="emptyState" class="empty-state" style="display: none;">
                <i class="fas fa-clipboard-list"></i>
                <h3>Nenhuma tarefa encontrada</h3>
                <p>Adicione uma nova tarefa para começar!</p>
            </div>
        </main>
    </div>

    <!-- Modal para Adicionar/Editar Tarefa -->
    <div id="taskModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2 id="modalTitle">Nova Tarefa</h2>
                <button id="closeModal" class="btn-close">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <form id="taskForm">
                <div class="form-group">
                    <label for="taskTitle">Título *</label>
                    <input type="text" id="taskTitle" required maxlength="255">
                </div>
                <div class="form-group">
                    <label for="taskDate">Data *</label>
                    <input type="date" id="taskDate" required>
                </div>
                <div class="form-group">
                    <label for="taskDescription">Descrição</label>
                    <textarea id="taskDescription" rows="4" placeholder="Adicione uma descrição..."></textarea>
                </div>
                <div class="form-actions">
                    <button type="button" id="cancelBtn" class="btn-secondary">Cancelar</button>
                    <button type="submit" id="saveBtn" class="btn-primary">
                        <i class="fas fa-save"></i> Salvar
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Toast para Notificações -->
    <div id="toast" class="toast"></div>

    <script src="js/main.js"></script>
</body>
</html>