<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Tenant extends Model
{
    protected $fillable = [
        'name',
        'slug',
    ];

    public function users(): HasMany
    {
        return $this->hasMany(User::class);
    }

    // ACRESCENTAR SEMPRE QUE CRIAR UMA NOVA TABELA OU MODEL
    public function clients(): HasMany
    {
        return $this->hasMany(Client::class);
    }

    public function categorias(): HasMany
    {
        return $this->hasMany(Categoria::class);
    }

    public function marcas(): HasMany
    {
        return $this->hasMany(Marca::class);
    }

    public function modelos(): HasMany
    {
        return $this->hasMany(Modelo::class);
    }
    public function formasPagamento(): HasMany
    {
        return $this->hasMany(FormasPagamento::class);
    }
    
}
