<?php

namespace App\Http\Middleware;

use App\Enums\UserRole;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class UserAccess
{
    public function handle(Request $request, Closure $next): Response
    {
        $user = auth()->user();
        
        if ($user?->role === UserRole::ADMIN) {
            return redirect()->route('filament.admin.pages.dashboard');
        }

        if (!in_array($user?->role, [UserRole::GERENTE, UserRole::OPERADOR])) {
            abort(403);
        }

        return $next($request);
    }
}
