<?php

namespace App\Filament\User\Resources\MarcaResource\Pages;

use App\Filament\User\Resources\MarcaResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions\Action;
use Filament\Notifications\Notification;

class CreateMarca extends CreateRecord
{
    protected static string $resource = MarcaResource::class;

    // titulo
    public function getTitle(): string
    {
        return 'Nova Marca';
    }

    protected function getCreateFormAction(): Action
    {
        return parent::getCreateFormAction()
            ->label('Criar Marca')
            ->icon('heroicon-o-plus-circle')
            ->color('primary');
    }

    protected function getCreateAnotherFormAction(): Action
    {
        return parent::getCreateAnotherFormAction()
            ->label('Criar e criar outro')
            ->icon('heroicon-o-plus')
            ->color('primary');
    }

    protected function getCancelFormAction(): Action
    {
        return parent::getCancelFormAction()
            ->label('Cancelar')
            ->icon('heroicon-o-x-mark')
            ->color('warning');
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    protected function getCreatedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->color('success')
            ->icon('heroicon-o-check-circle')
            ->title('Marca criada!')
            ->body('A nova marca foi cadastrada com sucesso')
            ->duration(5000);
    }
}
