<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}
require_once '../config/database.php';

$id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);
if (!$id) {
    header('Location: index.php');
    exit;
}

// Buscar informações do movimento e cliente
$stmt = $pdo->prepare("
    SELECT m.*, c.name as client_name 
    FROM movements m 
    JOIN clients c ON m.client_id = c.id 
    WHERE m.id = ?
");
$stmt->execute([$id]);
$movement = $stmt->fetch();

if (!$movement) {
    header('Location: index.php');
    exit;
}

// Buscar parcelas
$stmt = $pdo->prepare("
    SELECT * FROM installments 
    WHERE movement_id = ? 
    ORDER BY installment_number
");
$stmt->execute([$id]);
$installments = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Parcelas - Sistema Financeiro</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    <?php include '../includes/navbar.php'; ?>

    <div id="content" class="py-4 px-4">
        <div class="container-fluid">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <h2>Parcelas do Movimento</h2>
                    <p class="text-muted">
                        Cliente: <?php echo htmlspecialchars($movement['client_name']); ?> | 
                        Total: R$ <?php echo number_format($movement['total_amount'], 2, ',', '.'); ?> | 
                        Parcelas: <?php echo $movement['number_of_installments']; ?>x
                    </p>
                </div>
                <a href="index.php" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Voltar
                </a>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Nº Parcela</th>
                                    <th>Valor</th>
                                    <th>Vencimento</th>
                                    <th>Status</th>
                                    <th>Data Pagamento</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($installments as $installment): ?>
                                <tr>
                                    <td><?php echo $installment['installment_number']; ?>ª Parcela</td>
                                    <td>R$ <?php echo number_format($installment['amount'], 2, ',', '.'); ?></td>
                                    <td><?php echo date('d/m/Y', strtotime($installment['due_date'])); ?></td>
                                    <td>
                                        <?php
                                        $status_class = '';
                                        $status_text = '';
                                        switch ($installment['status']) {
                                            case 'pending':
                                                $status_class = 'warning';
                                                $status_text = 'Pendente';
                                                break;
                                            case 'paid':
                                                $status_class = 'success';
                                                $status_text = 'Pago';
                                                break;
                                            case 'overdue':
                                                $status_class = 'danger';
                                                $status_text = 'Em Atraso';
                                                break;
                                        }
                                        ?>
                                        <span class="badge bg-<?php echo $status_class; ?>">
                                            <?php echo $status_text; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if ($installment['payment_date']): ?>
                                            <?php echo date('d/m/Y', strtotime($installment['payment_date'])); ?>
                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
