<?php
require_once __DIR__ . '/../config/database.php';

try {
    // Remover tabelas na ordem correta devido às chaves estrangeiras
    $pdo->exec("DROP TABLE IF EXISTS installments");
    $pdo->exec("DROP TABLE IF EXISTS movements");
    
    // Recriar tabela de movimentos
    $pdo->exec("
        CREATE TABLE movements (
            id INT AUTO_INCREMENT PRIMARY KEY,
            client_id INT NOT NULL,
            description VARCHAR(255) NOT NULL,
            total_amount DECIMAL(10,2) NOT NULL,
            installments INT NOT NULL,
            created_at DATETIME NOT NULL,
            FOREIGN KEY (client_id) REFERENCES clients(id)
        )
    ");
    echo "Tabela movements recriada com sucesso!\n";

    // Recriar tabela de parcelas
    $pdo->exec("
        CREATE TABLE installments (
            id INT AUTO_INCREMENT PRIMARY KEY,
            movement_id INT NOT NULL,
            installment_number INT NOT NULL,
            amount DECIMAL(10,2) NOT NULL,
            due_date DATE NOT NULL,
            status ENUM('pending', 'paid', 'overdue') NOT NULL DEFAULT 'pending',
            paid_at DATETIME NULL,
            FOREIGN KEY (movement_id) REFERENCES movements(id) ON DELETE CASCADE
        )
    ");
    echo "Tabela installments recriada com sucesso!\n";

    echo "\nEstrutura atualizada das tabelas:\n";
    
    $tables = ['movements', 'installments'];
    foreach ($tables as $table) {
        $stmt = $pdo->query("DESCRIBE $table");
        echo "\nTabela $table:\n";
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            echo "- {$row['Field']}: {$row['Type']} {$row['Null']} {$row['Key']} {$row['Default']}\n";
        }
    }

} catch (PDOException $e) {
    echo "Erro: " . $e->getMessage() . "\n";
}
