<?php $__env->startSection('css'); ?>
<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        background: #f8fafc;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
    }

    .login-container {
        display: flex;
        width: 100%;
        max-width: 1200px;
        height: 750px;
        background: white;
        border-radius: 20px;
        box-shadow: 0 25px 50px rgba(0, 0, 0, 0.1);
        overflow: hidden;
    }

    /* Lado esquerdo - Formulário */
    .login-left {
        flex: 1;
        padding: 80px 60px 50px 60px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        background: white;
    }

    .saas-logo {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 35px;
        margin-top: 10px;
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
    }

    .saas-logo img {
        width: 100%;
        height: 100%;
        object-fit: contain;
        border-radius: 50%;
    }

    .welcome-text h1 {
        font-size: 32px;
        font-weight: 700;
        color: #1f2937;
        margin-bottom: 12px;
        line-height: 1.2;
    }

    .welcome-text p {
        font-size: 16px;
        color: #6b7280;
        margin-bottom: 35px;
        line-height: 1.6;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-group label {
        display: block;
        font-size: 14px;
        font-weight: 500;
        color: #374151;
        margin-bottom: 8px;
    }

    .form-control {
        width: 100%;
        padding: 14px 16px;
        border: 2px solid #e5e7eb;
        border-radius: 12px;
        font-size: 16px;
        color: #1f2937;
        background: white;
        transition: all 0.2s ease;
    }

    .form-control:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .form-control.error {
        border-color: #ef4444;
    }

    .error-message {
        color: #ef4444;
        font-size: 14px;
        margin-top: 6px;
        display: none;
    }

    .error-message.show {
        display: block;
    }

    .btn-login {
        width: 100%;
        background: #667eea;
        color: white;
        border: none;
        padding: 14px 24px;
        border-radius: 8px;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.2s ease;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }

    .btn-login:hover {
        background: #5a67d8;
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
    }

    .btn-login:active {
        transform: translateY(0);
    }

    .signup-link {
        text-align: center;
        margin-top: 25px;
        color: #6b7280;
        font-size: 14px;
    }

    .signup-link a {
        color: #667eea;
        text-decoration: none;
        font-weight: 500;
    }

    .signup-link a:hover {
        text-decoration: underline;
    }

    .alert {
        padding: 12px 16px;
        border-radius: 8px;
        margin-bottom: 20px;
        font-size: 14px;
    }

    .alert-danger {
        background: #fef2f2;
        color: #dc2626;
        border: 1px solid #fecaca;
    }

    .alert-success {
        background: #f0fdf4;
        color: #16a34a;
        border: 1px solid #bbf7d0;
    }

    .alert-info {
        background: #eff6ff;
        color: #2563eb;
        border: 1px solid #bfdbfe;
    }

    .demo-buttons {
        display: grid;
        gap: 8px;
        margin-top: 12px;
    }

    .btn-demo {
        padding: 8px 16px;
        border-radius: 6px;
        border: none;
        font-size: 14px;
        cursor: pointer;
        transition: all 0.2s ease;
    }

    .btn-success {
        background: #16a34a;
        color: white;
    }

    .btn-success:hover {
        background: #15803d;
    }

    .btn-dark {
        background: #374151;
        color: white;
    }

    /* Lado direito - Background com animação de bolhas */
    .login-right {
        flex: 1;
        background: #667eea;
        position: relative;
        overflow: hidden;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    #animatedBg {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 1;
    }

    .right-content {
        position: relative;
        z-index: 2;
        text-align: center;
        color: white;
        padding: 40px;
    }

    .right-content h2 {
        font-size: 28px;
        font-weight: 600;
        margin-bottom: 16px;
        text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    .right-content p {
        font-size: 16px;
        line-height: 1.6;
        opacity: 0.9;
        text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
    }

    @media (max-width: 768px) {
        .login-container {
            flex-direction: column;
            height: auto;
            max-width: 100%;
        }

        .login-left {
            padding: 40px 30px;
        }

        .login-right {
            min-height: 300px;
        }

        .welcome-text h1 {
            font-size: 24px;
        }

        .right-content h2 {
            font-size: 24px;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="login-container">
    <!-- Lado esquerdo - Formulário -->
    <div class="login-left">
        <div class="saas-logo">
            <img src="<?php echo e(asset('logo_2.png')); ?>" alt="Logo" class="logo-image">
        </div>

        <div class="welcome-text">
            <h1>Criar Conta</h1>
            <p>Leva menos de um minuto para começar!</p>
        </div>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('register')); ?>">
            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="name">Nome</label>
                <input class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                       type="text" 
                       id="name" 
                       name="name" 
                       value="<?php echo e(old('name')); ?>"
                       placeholder="Digite seu nome completo" 
                       required>
                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="error-message show"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-group">
                <label for="email">Email</label>
                <input class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                       type="email" 
                       id="email" 
                       name="email" 
                       value="<?php echo e(old('email')); ?>"
                       placeholder="Digite seu email" 
                       required>
                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="error-message show"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-group">
                <label for="password">Senha</label>
                <input class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                       type="password" 
                       id="password" 
                       name="password" 
                       placeholder="Digite sua senha" 
                       required>
                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="error-message show"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-group">
                <label for="password_confirmation">Confirmar Senha</label>
                <input class="form-control <?php $__errorArgs = ['password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                       type="password" 
                       id="password_confirmation" 
                       name="password_confirmation" 
                       placeholder="Confirme sua senha" 
                       required>
                <?php $__errorArgs = ['password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="error-message show"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <button type="submit" class="btn-login">
                <i class="ri-user-add-line"></i>
                Criar Conta
            </button>
        </form>

        <div class="signup-link">
            Já tem uma conta? <a href="<?php echo e(route('login')); ?>">Fazer login</a>
        </div>
    </div>

    <!-- Lado direito - Background com animação -->
    <div class="login-right">
        <canvas id="animatedBg"></canvas>
        
        <div class="right-content">
            <h2>Bem-vindo ao Next ERP</h2>
            <p>Gerencie sua empresa de forma inteligente e eficiente. Comece hoje mesmo!</p>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    const canvas = document.getElementById('animatedBg');
    const ctx = canvas.getContext('2d');

    function resizeCanvas() {
        canvas.width = canvas.offsetWidth;
        canvas.height = canvas.offsetHeight;
    }
    resizeCanvas();
    window.addEventListener('resize', resizeCanvas);

    class Bubble {
        constructor() {
            this.reset();
        }

        reset() {
            this.x = Math.random() * canvas.width;
            this.y = canvas.height + Math.random() * 100;
            this.size = Math.random() * 15 + 10;
            this.speedY = Math.random() * 0.8 + 0.2;
            this.wobble = 0;
            this.wobbleSpeed = Math.random() * 0.02 + 0.005;
            this.amplitude = Math.random() * 1.5 + 0.5;
            this.opacity = Math.random() * 0.2 + 0.1;
            this.rotationAngle = Math.random() * Math.PI * 2;
            this.rotationSpeed = (Math.random() - 0.5) * 0.02;
            this.exploded = false;
            this.explosionParticles = [];
            this.explosionTime = 0;
        }

        update() {
            if (this.exploded) {
                // Atualizar partículas da explosão
                this.explosionTime++;
                this.explosionParticles.forEach(particle => {
                    particle.x += particle.vx;
                    particle.y += particle.vy;
                    particle.vy += 0.1; // gravidade
                    particle.opacity -= 0.02; // fade out
                });
                
                // Remover partículas com opacidade muito baixa
                this.explosionParticles = this.explosionParticles.filter(p => p.opacity > 0);
                
                // Se todas as partículas desapareceram, resetar a bolha
                if (this.explosionParticles.length === 0) {
                    this.reset();
                }
                return;
            }

            this.y -= this.speedY;
            this.wobble += this.wobbleSpeed;
            this.x += Math.sin(this.wobble) * this.amplitude;
            this.rotationAngle += this.rotationSpeed;

            // Verificar se chegou quase no topo da tela para explodir
            if (this.y <= canvas.height * 0.2 && !this.exploded) {
                this.explode();
            }

            if (this.y < -50) {
                this.reset();
            }
        }

        explode() {
            this.exploded = true;
            this.explosionTime = 0;
            
            // Criar partículas da explosão
            const particleCount = 8 + Math.floor(Math.random() * 5);
            for (let i = 0; i < particleCount; i++) {
                const angle = (Math.PI * 2 * i) / particleCount;
                const speed = Math.random() * 3 + 2;
                
                this.explosionParticles.push({
                    x: this.x,
                    y: this.y,
                    vx: Math.cos(angle) * speed,
                    vy: Math.sin(angle) * speed - 2,
                    size: Math.random() * 4 + 2,
                    opacity: 0.8
                });
            }
        }

        draw() {
            if (this.exploded) {
                // Desenhar partículas da explosão
                this.explosionParticles.forEach(particle => {
                    ctx.save();
                    ctx.globalAlpha = particle.opacity;
                    
                    ctx.beginPath();
                    ctx.arc(particle.x, particle.y, particle.size, 0, Math.PI * 2);
                    
                    const gradient = ctx.createRadialGradient(
                        particle.x, particle.y, 0,
                        particle.x, particle.y, particle.size
                    );
                    gradient.addColorStop(0, `rgba(255, 255, 255, ${particle.opacity})`);
                    gradient.addColorStop(1, `rgba(255, 255, 255, 0)`);
                    
                    ctx.fillStyle = gradient;
                    ctx.fill();
                    
                    ctx.restore();
                });
                return;
            }

            // Desenhar bolha normal
            ctx.save();
            ctx.translate(this.x, this.y);
            ctx.rotate(this.rotationAngle);
            
            ctx.beginPath();
            ctx.arc(0, 0, this.size, 0, Math.PI * 2);
            
            const gradient = ctx.createRadialGradient(0, 0, 0, 0, 0, this.size);
            gradient.addColorStop(0, `rgba(255, 255, 255, ${this.opacity * 0.5})`);
            gradient.addColorStop(0.5, `rgba(255, 255, 255, ${this.opacity * 0.3})`);
            gradient.addColorStop(0.8, `rgba(200, 230, 255, ${this.opacity * 0.4})`);
            gradient.addColorStop(1, `rgba(255, 255, 255, ${this.opacity * 0.1})`);
            
            ctx.fillStyle = gradient;
            ctx.fill();

            ctx.strokeStyle = `rgba(255, 255, 255, ${this.opacity * 0.5})`;
            ctx.lineWidth = 0.5;
            ctx.stroke();
            
            ctx.beginPath();
            ctx.arc(-this.size * 0.3, -this.size * 0.3, this.size * 0.4, 0, Math.PI * 2);
            const reflexGradient = ctx.createRadialGradient(
                -this.size * 0.3, -this.size * 0.3, 0,
                -this.size * 0.3, -this.size * 0.3, this.size * 0.4
            );
            reflexGradient.addColorStop(0, `rgba(255, 255, 255, ${this.opacity * 0.8})`);
            reflexGradient.addColorStop(1, 'rgba(255, 255, 255, 0)');
            ctx.fillStyle = reflexGradient;
            ctx.fill();
            
            ctx.beginPath();
            ctx.arc(this.size * 0.2, this.size * 0.2, this.size * 0.1, 0, Math.PI * 2);
            ctx.fillStyle = `rgba(255, 255, 255, ${this.opacity * 0.6})`;
            ctx.fill();
            
            ctx.restore();
        }
    }

    const bubbles = [];
    const bubbleCount = 15;
    for (let i = 0; i < bubbleCount; i++) {
        bubbles.push(new Bubble());
    }

    function animate() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);

        bubbles.forEach(bubble => {
            bubble.update();
            bubble.draw();
        });

        requestAnimationFrame(animate);
    }

    animate();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.header_auth', ['title' => 'Cadastre-se'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\erp\resources\views/auth/register.blade.php ENDPATH**/ ?>