<?php if(isset($abertura) && $abertura): ?>
<div class="modal fade modal-action-pos" id="sangria_caixa" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Sangria</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php echo Form::open()
                ->post()
                ->route('sangria.store')
                ->id('sangria-form'); ?>

                <div class="row">

                    <input type="hidden" name="caixa_id" value="<?php echo e($abertura->id); ?>">
                    <div class="col-md-4">
                        <?php echo Form::tel('valor', 'Valor')->attrs(['class' => 'moeda'])->required(); ?>

                    </div>
                    <div class="col-md-8 div-conta-empresa">
                        <?php echo Form::select('conta_empresa_sangria_id', 'Conta empresa')
                        ->attrs(['class' => 'conta_empresa']); ?>

                    </div>

                    <div class="col-md-12 mt-2">
                        <?php echo Form::text('observacao', 'Observação')->attrs(['class' => '']); ?>

                    </div>
                    <div class="mt-3 ms-auto">
                        <button type="submit" class="btn btn-primary px-3 float-end">Salvar Sangria</button>
                    </div>
                </div>
                <?php echo Form::close(); ?>

            </div>

        </div>
    </div>
</div>

<script>
// Prevenir o modal de sangria de congelar a tela
$(document).ready(function(){
    console.log('Modal sangria_caixa inicializado');
    
    $("#sangria-form").on('submit', function(e) {
        console.log('Formulário de sangria submetido');
        
        // Log dos dados do formulário
        var formData = $(this).serialize();
        console.log('Dados do formulário:', formData);
        
        // Se o valor estiver vazio ou for zero, mostrar erro
        var valor = $('input[name="valor"]', this).val();
        console.log('Valor da sangria:', valor);
        
        if (!valor || parseFloat(valor.replace(/\./g, '').replace(',', '.')) <= 0) {
            e.preventDefault();
            console.log('Valor inválido para sangria');
            toastr.error('Informe um valor válido para a sangria.');
            return false;
        }
        
        // Verificar se o caixa_id está presente
        var caixaId = $('input[name="caixa_id"]', this).val();
        console.log('ID do caixa:', caixaId);
        
        if (!caixaId) {
            e.preventDefault();
            console.log('ID do caixa não encontrado');
            toastr.error('Erro: ID do caixa não encontrado.');
            return false;
        }
        
        // Feedback visual de carregamento
        $('button[type="submit"]', this).prop('disabled', true).html('<i class="spinner-border spinner-border-sm me-1"></i> Processando...');
        
        console.log('Enviando formulário de sangria...');
        
        // Fechar o modal antes de submeter
        $('#sangria_caixa').modal('hide');
    });
});
</script>
<?php else: ?>
<div class="modal fade modal-action-pos" id="sangria_caixa" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Atenção</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <p>É necessário abrir o caixa antes de realizar uma sangria.</p>
                </div>
                <div class="text-center">
                    <a href="<?php echo e(route('caixa.create')); ?>" class="btn btn-primary">Abrir Caixa</a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\erp_dev\resources\views/modals/_sangria_caixa.blade.php ENDPATH**/ ?>