<?php if(!Session::has('flash_message')): ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php endif; ?>

<?php $__env->startSection('css'); ?>
<link href="https://cdn.jsdelivr.net/npm/remixicon@2.5.0/fonts/remixicon.css" rel="stylesheet">
<link href="<?php echo e(asset('css/pdv_modern.css')); ?>" rel="stylesheet">
<style>
    /* Manter azul apenas para botões e elementos específicos */
    .active {
        background: #f8f9fa !important;
        color: #495057 !important;
        border-color: #dee2e6 #dee2e6 #fff !important;
    }
    
    /* Estilo para links de navegação desabilitados */
    .disable-click {
        pointer-events: none !important;
        cursor: default !important;
    }
    
    .disable-click:not(.active) {
        opacity: 0.8 !important;
        cursor: not-allowed !important;
    }
    
    /* Botões com cores específicas */
    .btn-primary {
        background-color: #4e73df !important;
        border-color: #4e73df !important;
        color: #fff !important;
    }
    
    .btn-success {
        background-color: #1cc88a !important;
        border-color: #1cc88a !important;
        color: #fff !important;
    }
    
    .btn-danger {
        background-color: #e74a3b !important;
        border-color: #e74a3b !important;
        color: #fff !important;
    }
    
    .btn-secondary {
        background-color: #858796 !important;
        border-color: #858796 !important;
        color: #fff !important;
    }
    
    .btn-dark {
        background-color: #5a5c69 !important;
        border-color: #5a5c69 !important;
        color: #fff !important;
    }
    
    .btn-light {
        background-color: #f8f9fc !important;
        border-color: #f8f9fc !important;
        color: #5a5c69 !important;
    }

    #salvar_venda:hover {
        cursor: pointer;
    }

    .btn-cat{
        height: 30px;
        display: block;
        min-width: 200px;
    }

    .qrcode{
        display: block;
        margin-left: auto;
        margin-right: auto;
        width: 50%;
    }
    
    /* Layout principal PDV */
    .pdv-container {
        max-width: 100%;
        overflow-x: hidden;
        background-color: transparent !important;
    }
    
    /* Estilos para o novo layout de duas colunas */
    .pdv-col-esquerda {
        height: calc(100vh - 240px);
        background-color: transparent !important;
    }
    
    .pdv-col-direita {
        height: calc(100vh - 240px);
        display: flex;
        flex-direction: column;
        background-color: transparent !important;
    }
    
    /* Estilos para o campo de código de barras - Versão clean */
    .codigo-barras-container {
        background-color: #f8f9fa;
        border-radius: 6px;
        padding: 6px;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08);
        margin-bottom: 8px;
        position: relative;
        border-left: 4px solid #4e73df;
    }
    
    .codigo-barras-container h4 {
        color: #4e73df;
        font-weight: bold;
        font-size: 0.9rem;
        margin-bottom: 4px;
        text-align: center;
    }
    
    #codBarras {
        font-size: 1.3em;
        height: 40px;
        border: 2px solid #4e73df;
        font-weight: 600;
        padding-left: 15px;
        letter-spacing: 0.5px;
    }
    
    #codBarras:focus {
        box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        border-color: #4e73df;
    }
    
    .codigo-barras-input {
        position: relative;
    }
    
    .input-group-text {
        background-color: #4e73df;
        color: white;
        border: 2px solid #4e73df;
        font-size: 1.2em;
    }
    
    /* Status de quantidade e leitor */
    .scanner-status {
        display: flex;
        justify-content: space-between;
        margin-top: 4px;
        padding: 0 5px;
    }
    
    .scanner-info {
        font-size: 0.85em;
        background-color: #eef2ff;
        border-radius: 20px;
        padding: 3px 10px;
        display: flex;
        align-items: center;
        margin-right: 10px;
    }
    
    /* Indicador de quantidade */
    .quantidade-badge {
        position: absolute;
        top: -15px;
        right: 60px;
        background-color: #28a745;
        color: white;
        font-weight: bold;
        border-radius: 20px;
        font-size: 0.9em;
        padding: 3px 10px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.2);
        z-index: 1000;
        display: none;
    }
    
    /* Animação para o indicador de quantidade */
    .animated-badge {
        animation: pulse 2s infinite;
    }
    
    @keyframes pulse {
        0% {
            box-shadow: 0 0 0 0 rgba(40, 167, 69, 0.7);
        }
        70% {
            box-shadow: 0 0 0 8px rgba(40, 167, 69, 0);
        }
        100% {
            box-shadow: 0 0 0 0 rgba(40, 167, 69, 0);
        }
    }
    
    /* Leitor ativado/desativado */
    .leitor_ativado {
        color: #198754 !important;
        font-weight: bold;
        cursor: pointer;
    }
    
    .leitor_desativado {
        color: #dc3545;
        font-weight: bold;
        cursor: pointer;
    }
    
    /* Instruções rápidas */
    .quick-help {
        background-color: #fff9e6;
        border-radius: 6px;
        padding: 4px 8px;
        margin-top: 3px;
        font-size: 0.8em;
        color: #664d03;
        display: flex;
        align-items: center;
        border-left: 3px solid #ffc107;
    }
    
    .quick-help i {
        margin-right: 6px;
        font-size: 1.1em;
    }
    
    /* Widgets e cards compactos */
    .widget-compact {
        margin-bottom: 8px;
        border-radius: 6px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.04);
        transition: all 0.2s ease;
        background-color: #fff !important;
    }
    
    .widget-compact:hover {
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.08);
    }
    
    .widget-compact .card-body {
        padding: 8px;
    }
    
    .widget-compact h5 {
        font-size: 0.8rem;
        margin-bottom: 3px;
    }
    
    .widget-compact h6 {
        font-size: 1rem;
        margin-bottom: 0;
    }
    
    /* Estilos para as seções de produtos */
    .produto-header {
        background-color: #858796 !important;
        color: white;
        padding: 8px;
        border-radius: 8px 8px 0 0;
        margin-bottom: 0;
    }
    
    /* Remover qualquer fundo azul indesejado */
    .tab-pane, 
    .tab-content,
    .nav-pills,
    .nav-item,
    .pdv-container,
    .pdv-col-esquerda,
    .pdv-col-direita,
    .container-fluid,
    .page-content,
    .panel,
    .panel-body {
        background-color: transparent !important;
    }
    
    /* Garantir que cards tenham fundo branco */
    .card, .card-body {
        background-color: #fff !important;
    }
    
    /* Cores de texto específicas */
    .text-primary {
        color: #4e73df !important;
    }
    
    .text-success {
        color: #1cc88a !important;
    }
    
    .text-danger {
        color: #e74a3b !important;
    }
    
    .text-warning {
        color: #f6c23e !important;
    }
    
    /* Melhoria na tabela de produtos */
    .table-responsive {
        border-radius: 0 0 8px 8px;
        overflow: hidden;
    }
    
    /* Estilização da barra de rolagem da tabela de produtos */
    .tabela-produtos-pdv {
        overflow-y: auto;
        scrollbar-width: thin;
        scrollbar-color: #4e73df #f8f9fa;
    }
    
    .tabela-produtos-pdv::-webkit-scrollbar {
        width: 8px;
    }
    
    .tabela-produtos-pdv::-webkit-scrollbar-track {
        background: #f8f9fa;
        border-radius: 4px;
    }
    
    .tabela-produtos-pdv::-webkit-scrollbar-thumb {
        background-color: #4e73df;
        border-radius: 4px;
        border: 2px solid #f8f9fa;
    }
    
    .tabela-produtos-pdv::-webkit-scrollbar-thumb:hover {
        background-color: #3558c8;
    }
    
    .table-itens thead {
        position: sticky;
        top: 0;
        z-index: 1;
        background-color: #f2f2f2;
    }
    
    .table-itens th {
        padding: 6px;
        font-weight: 600;
        font-size: 0.8rem;
    }
    
    .table-itens td {
        padding: 4px 6px;
        font-size: 0.8rem;
    }
    
    /* Campo de quantidade destacado */
    .quantidade-highlight {
        font-size: 1em;
        border: 2px solid #4e73df;
    }
    
    .quantidade-highlight:focus {
        box-shadow: 0 0 0 0.15rem rgba(78, 115, 223, 0.25);
        border-color: #4e73df;
    }
    
    /* Efeito de transição para o destaque do campo de quantidade */
    .quantidade-highlight {
        transition: background-color 0.3s ease;
    }
    
    /* Botões de ação mais claros e compactos */
    .btn-sm {
        padding: 0.15rem 0.3rem;
        font-size: 0.7rem;
    }
    
    /* Secção de produtos mais compacta */
    .produtos-container {
        margin-bottom: 4px;
    }
    
    .produto-form {
        background-color: #f9f9f9;
        border-radius: 6px;
        padding: 6px;
        margin-bottom: 4px;
        border: 1px solid #eaeaea;
    }
    
    /* Tabela de produtos responsiva e mais compacta */
    .tabela-produtos-pdv {
        transition: height 0.3s ease;
    }
    
    /* Redução de altura de todos os componentes principais */
    .form-control, .form-select, .input-group {
        min-height: auto;
        height: calc(1.5em + 0.5rem + 2px);
    }
    
    .btn {
        padding-top: 0.25rem;
        padding-bottom: 0.25rem;
    }
    
    .card-body {
        padding: 0.5rem;
    }
    
    .mb-1 {
        margin-bottom: 0.3rem !important;
    }
    
    .mb-2 {
        margin-bottom: 0.5rem !important;
    }
    
    .row {
        margin-bottom: 0.3rem;
    }
    
    /* Estilo para notificações de dicas */
    .pdv-dicas {
        font-size: 0.85rem;
    }
    
    .pdv-dicas ul {
        list-style-type: none;
    }
    
    .pdv-dicas li {
        margin-bottom: 3px;
        line-height: 1.3;
    }
    
    .pdv-dicas strong {
        color: #4e73df;
    }
    
    /* Personalização do toast */
    .toast-top-center {
        top: 15px;
    }
    
    #toast-container .toast-info {
        background-color: #ffffff;
        color: #333;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15);
        border-left: 5px solid #4e73df;
    }
    
    #toast-container .toast-info .toast-title {
        color: #4e73df;
        font-weight: 600;
        font-size: 0.95rem;
    }
    
    /* Novas classes para o layout reorganizado */
    .total-venda-card {
        background: linear-gradient(135deg, #4e73df 0%, #3558c8 100%);
        color: white;
        border: none;
        box-shadow: 0 4px 10px rgba(78, 115, 223, 0.3);
    }
    
    .total-venda-card h5 {
        color: rgba(255, 255, 255, 0.8);
    }
    
    .total-venda-card strong {
        color: white;
        font-size: 1.5rem;
    }
    
    .acoes-caixa-card {
        background-color: #f8f9fc;
        border: 1px solid #eaecf4;
    }
    
    /* Fazer tabela de produtos ocupar toda a altura disponível */
    .tabela-produtos-box {
        display: flex;
        flex-direction: column;
        height: 100%;
    }
    
    .tabela-produtos-box .card {
        flex-grow: 1;
        display: flex;
        flex-direction: column;
        margin-bottom: 0;
    }
    
    .tabela-produtos-box .table-responsive {
        flex-grow: 1;
    }
    
    /* Diminuir espaço entre elementos */
    .mb-pdv {
        margin-bottom: 0.5rem !important;
    }
    
    /* Botão de sair pequeno e discreto */
    .btn-sair-pdv {
        position: absolute;
        top: 5px;
        right: 5px;
        padding: 0.1rem 0.3rem;
        font-size: 0.65rem;
        z-index: 100;
        opacity: 0.7;
    }
    
    .btn-sair-pdv:hover {
        opacity: 1;
    }
    
    /* Campos de desconto e acréscimo menores */
    .valores-pequenos h5 {
        font-size: 0.7rem;
        margin-bottom: 0.1rem;
    }
    
    .valores-pequenos h3 {
        font-size: 0.9rem;
        margin-bottom: 0;
    }
    
    /* Ajustes para diminuir espaçamentos */
    .produto-form-compacto {
        margin-bottom: 0.2rem;
        padding: 3px;
    }
    
    .tabela-compacta {
        margin-top: 0.2rem;
    }
    
    /* Estilos para o novo layout com abas */
    .pdv-tabs .nav-pills {
        background-color: transparent;
        border-radius: 6px;
        padding: 8px;
        margin-bottom: 15px;
        border-bottom: 1px solid #dee2e6;
    }
    
    .pdv-tabs .nav-link {
        padding: 8px 16px;
        font-weight: 600;
        color: #495057;
        border-radius: 6px 6px 0 0;
        margin-right: 5px;
        background-color: #f8f9fa;
        border: 1px solid #dee2e6;
        border-bottom: none;
    }
    
    .pdv-tabs .nav-link.active {
        color: #495057;
        background-color: #fff;
        border-color: #dee2e6 #dee2e6 #fff;
    }
    
    .pdv-tabs .nav-link i {
        margin-right: 5px;
    }
    
    .pdv-tabs .tab-content {
        background-color: transparent;
        border-radius: 0;
        box-shadow: none;
        padding: 15px 0;
    }

    /* Novo painel de pagamentos */
    .pagamento-tab-content {
        padding: 15px;
        background-color: transparent !important;
    }
    
    /* Card com borda colorida à esquerda */
    .border-left-success {
        border-left: 4px solid #1cc88a !important;
    }
    
    .border-left-primary {
        border-left: 4px solid #4e73df !important;
    }
    
    .border-left-warning {
        border-left: 4px solid #f6c23e !important;
    }
    
    /* Sombras sutis para cards */
    .shadow {
        box-shadow: 0 .15rem 1.75rem 0 rgba(58,59,69,.15) !important;
    }
    
    .shadow-sm {
        box-shadow: 0 .125rem .25rem 0 rgba(58,59,69,.1) !important;
    }
    
    /* Cores de badges e textos */
    .text-xs {
        font-size: .7rem;
    }
    
    .text-gray-800 {
        color: #5a5c69 !important;
    }
    
    /* Otimização de espaço vertical para o PDV */
    .card-venda .card-body {
        padding: 0.75rem;
    }
    .card-venda .card-header,
    .card-venda .card-footer {
        padding: 0.5rem 0.75rem;
    }
    
    /* Reduzir espaços entre componentes de formulário */
    .form-group {
        margin-bottom: 0.5rem;
    }
    .input-group {
        margin-bottom: 0.5rem;
    }
    
    /* Compactar tabelas */
    .table-produtos th,
    .table-produtos td {
        padding: 0.4rem 0.5rem;
        vertical-align: middle;
    }
    
    /* Ajustar tamanho de campos e botões para economizar espaço */
    .form-control-sm, 
    .btn-sm {
        padding: 0.25rem 0.5rem;
        height: calc(1.75rem + 2px);
    }
    
    /* Reduzir margens entre componentes */
    .mb-3 {
        margin-bottom: 0.75rem !important;
    }
    
    /* Otimizar área de itens na venda */
    .lista-produtos {
        max-height: calc(100vh - 300px);
        overflow-y: auto;
    }
    
    /* Otimizar seção de pagamentos */
    .secao-pagamento {
        max-height: calc(100vh - 150px);
        overflow-y: auto;
    }
    
    /* Reduzir espaço entre itens do PDV */
    .itens-pdv > div {
        margin-bottom: 0.5rem;
    }
    
    /* Ajustar alturas de cards */
    .card-compact {
        margin-bottom: 0.5rem;
    }
    
    /* Estilos para o layout compacto das abas de pagamento */
    .pdv-tabs .nav-pills {
        background-color: transparent !important;
        border-radius: 6px;
        padding: 4px; /* Reduzido */
        margin-bottom: 8px; /* Reduzido */
        border-bottom: 1px solid #dee2e6;
    }
    
    .pdv-tabs .nav-link {
        padding: 6px 12px; /* Reduzido */
        font-weight: 600;
        color: #495057;
        border-radius: 6px 6px 0 0;
        margin-right: 5px;
        background-color: #f8f9fa;
        border: 1px solid #dee2e6;
        border-bottom: none;
    }
    
    .pdv-tabs .nav-link.active {
        color: #495057;
        background-color: #fff;
        border-color: #dee2e6 #dee2e6 #fff;
    }
    
    .pdv-tabs .tab-content {
        background-color: transparent !important;
        border-radius: 0;
        box-shadow: none;
        padding: 8px 0; /* Reduzido */
    }
    
    /* Ajustes para o painel de pagamentos */
    .pagamento-tab-content {
        padding: 4px; /* Reduzido */
        background-color: transparent !important;
    }
    
    /* Reduzir margens e paddings */
    .pagamento-tab-content .card {
        margin-bottom: 6px; /* Reduzido */
    }
    
    .pagamento-tab-content .card-body {
        padding: 0.3rem; /* Reduzido */
    }
    
    .pagamento-tab-content .card-header {
        padding: 0.4rem; /* Reduzido */
    }
    
    .pagamento-tab-content .form-label {
        margin-bottom: 0.1rem;
        font-size: 0.85rem;
    }
    
    /* Reduzir espaços entre elementos */
    .pagamento-tab-content .mb-3 {
        margin-bottom: 0.3rem !important; /* Reduzido */
    }
    
    .pagamento-tab-content .mb-2 {
        margin-bottom: 0.2rem !important; /* Reduzido */
    }
    
    /* Inputs e selects mais compactos */
    .pagamento-tab-content .form-control,
    .pagamento-tab-content .form-select,
    .pagamento-tab-content .btn {
        padding-top: 0.2rem;
        padding-bottom: 0.2rem;
        height: calc(1.4em + 0.4rem + 2px); /* Reduzido */
        font-size: 0.9rem;
    }
    
    /* Ajuste para textos */
    .pagamento-tab-content .h2,
    .pagamento-tab-content .h3 {
        font-size: 1.2rem;
        margin-bottom: 0;
    }
    
    /* Lista de pagamentos */
    .lista-pagamentos-box {
        max-height: calc(100vh - 350px); /* Ajustado */
        overflow-y: auto;
    }
    
    /* Botões mais compactos */
    .pagamento-tab-content .btn-sm {
        padding: 0.1rem 0.25rem; /* Reduzido */
        font-size: 0.75rem;
    }
    
    /* Reduzir tamanho da tabela */
    .pagamento-tab-content table.table-sm td, 
    .pagamento-tab-content table.table-sm th {
        padding: 0.15rem 0.4rem; /* Reduzido */
        font-size: 0.85rem;
    }
    
    /* Badge mais compacto */
    .badge.bg-warning, .badge.bg-success {
        padding: 0.3rem 0.5rem !important;
        font-size: 0.85rem;
    }

    .pdv-itens-scroll {
        max-height: 300px !important; /* ajuste conforme necessário */
        overflow-y: auto !important;
        overflow-x: hidden;
    }
    .pdv-itens-scroll table {
        width: 100%;
        margin-bottom: 0;
    }

    .pdv-tbody-scroll {
        display: block;
        max-height: 300px;
        overflow-y: auto;
        width: 100%;
    }
    .pdv-tbody-scroll tr {
        display: table;
        width: 100%;
        table-layout: fixed;
    }
    .pdv-tbody-scroll td, .pdv-tbody-scroll th {
        word-break: break-word;
    }

    .pdv-scroll-container {
        display: block !important;
        max-height: 300px !important;
        overflow-y: auto !important;
        overflow-x: auto !important;
        width: 100% !important;
        position: relative;
        border: 2px solid red !important; /* Para depuração visual */
    }
    .pdv-scroll-container table {
        width: 100% !important;
        margin-bottom: 0 !important;
        table-layout: fixed !important;
    }
    .pdv-scroll-container th, .pdv-scroll-container td {
        white-space: nowrap !important;
        text-overflow: ellipsis !important;
        overflow: hidden !important;
    }
</style>
<?php $__env->stopSection(); ?>

<input type="hidden" id="abertura" value="<?php echo e($abertura); ?>" name="">
<input type="hidden" id="tef_hash" value="" name="tef_hash">
<input type="hidden" id="config_tef" value="<?php echo e(isset($configTef) && $configTef != null ? 1 : 0); ?>">
<input type="hidden" id="agrupar_itens" value="<?php echo e($config ? $config->agrupar_itens : 0); ?>" name="">
<input type="hidden" id="venda_id" value="<?php echo e(isset($item) ? $item->id : ''); ?>">
<input type="hidden" id="lista_id" value="" name="lista_id">
<input type="hidden" id="alerta_sonoro" value="<?php echo e($config ? $config->alerta_sonoro : 0); ?>">
<input type="hidden" id="local_id" value="<?php echo e($caixa->localizacao->id); ?>">
<input type="hidden" id="empresa_id" value="<?php echo e($caixa->empresa_id); ?>">
<!-- Debug: empresa_id = <?php echo e($caixa->empresa_id); ?> -->
<input type="hidden" id="usuario_id" value="<?php echo e(Auth::user()->id); ?>">

<?php if($isVendaSuspensa): ?>
<input type="hidden" value="<?php echo e($item->id); ?>" name="venda_suspensa_id">
<?php endif; ?>

<?php if(isset($pedido)): ?>
<?php if(isset($isDelivery)): ?>
<input name="pedido_delivery_id" id="pedido_delivery_id" value="<?php echo e($pedido->id); ?>" class="d-none">
<input id="pedido_desconto" value="<?php echo e($pedido->desconto ? $pedido->desconto : 0); ?>" class="d-none">
<input name="valor_entrega" id="pedido_valor_entrega" value="<?php echo e($pedido->valor_entrega); ?>" class="d-none">
<?php else: ?>
<input name="pedido_id" id="pedido_id" value="<?php echo e($pedido->id); ?>" class="d-none">
<?php endif; ?>
<?php endif; ?>

<?php if(isset($config)): ?>
<input type="hidden" id="inp-abrir_modal_cartao" value="<?php echo e($config != null ? $config->abrir_modal_cartao : 0); ?>">
<input type="hidden" id="inp-senha_manipula_valor" value="<?php echo e($config != null ? $config->senha_manipula_valor : ''); ?>">
<?php else: ?>
<input type="hidden" id="inp-abrir_modal_cartao" value="0">
<input type="hidden" id="inp-senha_manipula_valor" value="">
<?php endif; ?>

<?php if(isset($agendamento)): ?>
<input name="agendamento_id" value="<?php echo e($agendamento->id); ?>" class="d-none">
<?php endif; ?>

<input type="hidden" id="estoque_view" value="<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('estoque_view')): ?> 1 <?php else: ?> 0 <?php endif; ?>">

<div class="pdv-container position-relative">
    <!-- Botão de Sair do PDV (REMOVIDO para não quebrar o fluxo e o estoque) -->
    <!-- <a class="btn btn-danger btn-sair-pdv" href="<?php echo e(route('frontbox.index')); ?>">
        <i class="ri-close-line"></i> Sair
    </a> -->

    <!-- Novo sistema de abas para PDV -->
    <div class="pdv-tabs">
        <ul class="nav nav-pills nav-justified mb-3 d-none" id="pdv-tabs" role="tablist">
            <li class="nav-item" role="presentation">
                <a class="nav-link active" id="tab-vendas-tab" data-bs-toggle="tab" href="#tab-vendas" role="tab" aria-controls="tab-vendas" aria-selected="true">
                    <i class="ri-shopping-cart-2-line"></i> Vendas
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link" id="tab-pagamentos-tab" data-bs-toggle="tab" href="#tab-pagamentos" role="tab" aria-controls="tab-pagamentos" aria-selected="false">
                    <i class="ri-bank-card-line"></i> Pagamentos
                </a>
            </li>
             <!-- NOVA ABA RECEBIMENTOS-->
             <li class="nav-item d-none" role="presentation">
                <a class="nav-link" id="tab-recebimentos-tab" data-bs-toggle="tab" href="#tab-recebimentos" role="tab" aria-controls="tab-recebimentos" aria-selected="false">
                    <i class="ri-cash-line"></i> Recebimentos
                </a>
            </li>
        </ul>
        
        <div class="tab-content" id="pdv-tabsContent">
            <!-- Tab Vendas -->
            <div class="tab-pane fade show active" id="tab-vendas" role="tabpanel" aria-labelledby="tab-vendas-tab">
                <!-- Conteúdo da aba de vendas - sem alterações -->
                <!-- Campo de código de barras no topo da tela -->
                <div class="row" style="margin-bottom: 0.2rem;">
                    <div class="col-12">
                        <div class="codigo-barras-container" style="margin-bottom: 0.2rem;">
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="small text-muted ps-1" style="font-size: 0.7rem; line-height: 1.1">
                                    <span class="me-2"><i class="ri-store-2-line me-1"></i>Cx: <strong><?php echo e($caixa->id); ?></strong></span>
                                    <span class="me-2"><i class="ri-user-line me-1"></i><?php echo e(Auth::user()->name); ?></span>
                                    <span><i class="ri-calendar-event-line me-1"></i><?php echo e(date('d/m/Y H:i')); ?></span>
                                </div>
                                <h4 class="mb-1 text-center flex-grow-1" style="font-size: 0.9rem;">PDV - PONTO DE VENDA</h4>
                                <div style="width: 200px;"></div><!-- Espaçador para manter o título centralizado -->
                            </div>
                            <div class="codigo-barras-input">
                                <div class="input-group">
                                    <input class="form-control mousetrap" type="text" autofocus 
                                           placeholder="Digite o código de barras ou quantidade*" 
                                           id="codBarras" name="" style="height: 34px;">
                                    <div class="input-group-append">
                                        <span class="input-group-text" style="height: 34px; padding: 0.25rem 0.5rem;">
                                            <i class="ri-barcode-line"></i>
                                        </span>
                                    </div>
                                    <span id="quantidade_multipla" class="quantidade-badge"></span>
                                </div>
                            </div>
                            
                            <!-- Campo de busca de pré-venda -->
                            <!-- <div class="pre-venda-busca mt-2">
                                <div class="input-group">
                                    <input class="form-control" type="text" 
                                           placeholder="Digite o código da pré-venda (ex: PRV0001)" 
                                           id="codigoPreVenda" name="codigo_pre_venda" style="height: 34px;">
                                    <div class="input-group-append">
                                        <button class="btn btn-info" type="button" id="btnBuscarPreVenda" style="height: 34px;">
                                            <i class="ri-search-line"></i> Buscar Pré-venda
                                        </button>
                                    </div>
                                </div>
                            </div> -->
                        </div>
                    </div>
                    
                    <!-- Produtos Form -->
                    <div class="col-12">
                        <div class="produto-form produto-form-compacto">
                            <div class="row g-1 align-items-end">
                                <div class="col-md-5 col-lg-5">
                                    <div class="form-group mb-0">
                                        <label for="inp-produto_id" class="mb-1 small">Produto</label>
                                        <div class="input-group">
                                            <select class="form-control produto_id" name="produto_id" id="inp-produto_id" style="height: 34px;"></select>
                                        </div>
                                        <input name="variacao_id" id="inp-variacao_id" type="hidden" value="">
                                    </div>
                                </div>
                                <div class="col-md-2 col-3">
                                    <div class="form-group mb-0">
                                        <label for="inp-quantidade" class="mb-1 small fw-bold">Quantidade</label>
                                        <div class="input-group">
                                            <input type="tel" class="form-control font-weight-bold quantidade-highlight" 
                                                   id="inp-quantidade" name="quantidade" data-mask="00000,000" 
                                                   data-mask-reverse="true" value="1,000">
                                            <div class="input-group-append">
                                                <span class="input-group-text bg-primary text-white" style="height: 34px; padding: 0.25rem 0.5rem;">
                                                    <i class="ri-numbers-line"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 col-5">
                                    <div class="form-group mb-0">
                                        <label for="inp-valor_unitario" class="mb-1 small fw-bold">Valor Unitário</label>
                                        <div class="input-group">
                                            <input type="tel" class="form-control font-weight-bold moeda value_unit" 
                                                   id="inp-valor_unitario" name="valor_unitario">
                                            <div class="input-group-append">
                                                <span class="input-group-text bg-success text-white" style="height: 34px; padding: 0.25rem 0.5rem;">
                                                    <i class="ri-money-dollar-circle-line"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2 col-4">
                                    <div class="form-group mb-0">
                                        <label class="mb-1 small fw-bold invisible">.</label> <!-- Invisível para ocupar espaço -->
                                        <div class="input-group">
                                            <button class="btn btn-primary btn-block btn-add-item w-100" type="button">
                                                <i class="ri-add-circle-line"></i> Adicionar
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <?php echo Form::hidden('subtotal', 'SubTotal')->attrs(['class' => 'moeda']); ?>

                                <?php echo Form::hidden('valor_total', 'valor Total')->attrs(['class' => 'moeda']); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <!-- Layout principal - Grid à esquerda, Totalizadores à direita -->
                <div class="row">
                    <!-- COLUNA ESQUERDA - Lista de Produtos da Venda -->
                    <div class="col-md-8">
                        <div class="card mb-pdv tabela-compacta">
                            <h5 class="produto-header text-center mb-0">Itens da Venda</h5>
                            
                            <div class="item-table-box <?php echo e((isset($item) && isset($item->itens) && count($item->itens) >= 10) ? 'pdv-scroll-container' : ''); ?>">
                                <table class="table table-striped table-hover table-sm mb-0 table-itens fade-in">
                                    <thead>
                                        <tr>
                                            <th>Produto</th>
                                            <th style="width: 150px;">Qtd.</th>
                                            <th style="width: 150px;">Valor Unit.</th>
                                            <th style="width: 150px;">Subtotal</th>
                                            <th style="width: 70px;" class="text-center">Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody class="<?php echo e((isset($item) && isset($item->itens) && count($item->itens) >= 3) ? 'pdv-tbody-scroll' : ''); ?>">
                                        <?php if(isset($item)): ?>
                                        <?php $__currentLoopData = $item->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="line-product">
                                            <input readonly type="hidden" name="key" class="form-control" value="<?php echo e($product->key); ?>">
                                            <input readonly type="hidden" name="produto_id[]" class="produto_row" value="<?php echo e($product->produto->id); ?>">
                                            <input name="variacao_id[]" type="hidden" value="<?php echo e($product->variacao_id); ?>">

                                            <td>
                                                <input readonly type="text" name="produto_nome[]" class="form-control" value="<?php echo e($product->produto->nome); ?> <?php if($product->produtoVariacao != null): ?> - <?php echo e($product->produtoVariacao->descricao); ?> <?php endif; ?>">
                                            </td>

                                            <td class="datatable-cell">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <button id="btn-subtrai" class="btn btn-danger btn-sm" type="button">-</button>
                                                    </div>
                                                    <input type="tel" readonly class="form-control qtd qtd_row" name="quantidade[]" value="<?php echo e(number_format($product->quantidade, 3, ',', '')); ?>">
                                                    <div class="input-group-append">
                                                        <button class="btn btn-success btn-sm" id="btn-incrementa" type="button">+</button>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <input readonly type="tel" name="valor_unitario[]" class="form-control value-unit" value="<?php echo e(__moeda($product->valor_unitario)); ?>">
                                            </td>
                                            <td>
                                                <input readonly type="tel" name="subtotal_item[]" class="form-control subtotal-item" value="<?php echo e(__moeda($product->valor_unitario * $product->quantidade)); ?>">
                                            </td>
                                            <td class="text-center">
                                                <button type="button" class="btn btn-danger btn-sm btn-delete-row"><i class="ri-delete-bin-line"></i></button>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>

                                        <?php if(isset($servicos)): ?>
                                        <?php $__currentLoopData = $servicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $servico): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <input readonly type="hidden" name="servico_id[]" class="form-control" value="<?php echo e($servico->servico->id); ?>">

                                            <td>
                                                <input readonly type="text" name="servico_nome[]" class="form-control" value="<?php echo e($servico->servico->nome); ?> [serviço]" style="color: darkred;">
                                            </td>
                                            <td>
                                                <div class="input-group">
                                                    <div class="input-group-prepend">  
                                                         <button disabled id="btn-subtrai" class="btn btn-danger btn-sm" type="button">-</button>
                                                    </div>
                                                    <input readonly type="tel" name="quantidade_servico[]" class="form-control qtd-item" value="<?php echo e(number_format($servico->quantidade,0)); ?>">
                                                    <div class="input-group-append">
                                                        <button disabled class="btn btn-success btn-sm" id="btn-incrementa" type="button">+</button>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <input readonly type="tel" name="valor_unitario_servico[]" class="form-control" value="<?php echo e(__moeda($servico->valor)); ?>">
                                            </td>
                                            <td>
                                                <input readonly type="tel" name="subtotal_servico[]" class="form-control subtotal-item" value="<?php echo e(__moeda($servico->valor * $servico->quantidade)); ?>">
                                            </td>
                                            <td class="text-center">
                                                <button disabled type="button" class="btn btn-danger btn-sm btn-delete-row"><i class="ri-delete-bin-line"></i></button>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>

                                        <?php if(isset($pedido) && isset($itens)): ?>
                                        <?php $__currentLoopData = $itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="line-product">
                                            <input readonly type="hidden" name="key" class="form-control" value="<?php echo e($product->key); ?>">
                                            <input readonly type="hidden" name="produto_id[]" class="produto_row" value="<?php echo e($product->produto->id); ?>">
                                            <input name="variacao_id[]" type="hidden" value="<?php echo e($product->variacao_id); ?>">

                                            <td>
                                                <input readonly type="text" name="produto_nome[]" class="form-control" value="<?php echo e($product->produto->nome); ?> <?php if($product->produtoVariacao != null): ?> - <?php echo e($product->produtoVariacao->descricao); ?> <?php endif; ?>">
                                            </td>

                                            <td class="datatable-cell">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <button id="btn-subtrai" class="btn btn-warning btn-sm" type="button">-</button>
                                                    </div>
                                                    <input type="tel" readonly class="form-control qtd qtd_row" name="quantidade[]" value="<?php echo e(number_format($product->quantidade, 3, ',', '')); ?>">
                                                    <div class="input-group-append">
                                                        <button class="btn btn-success btn-sm" id="btn-incrementa" type="button">+</button>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <input readonly type="tel" name="valor_unitario[]" class="form-control value-unit" value="<?php echo e(__moeda($product->valor_unitario)); ?>">
                                            </td>
                                            <td>
                                                <input readonly type="tel" name="subtotal_item[]" class="form-control subtotal-item" value="<?php echo e(__moeda($product->valor_unitario * $product->quantidade)); ?>">
                                            </td>
                                            <td class="text-center">
                                                <button type="button" class="btn btn-danger btn-sm btn-delete-row"><i class="ri-delete-bin-line"></i></button>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                    <!-- COLUNA DIREITA - Totalizadores e Ações -->
                    <div class="col-md-4">
                        <!-- Total da Venda -->
                        <div class="card widget-compact div-pagamento mb-pdv">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div class="flex-grow-1 overflow-hidden">
                                        <h5 class="text-muted text-uppercase fs-13 mt-0 text-center">TOTAL DA VENDA</h5>
                                    </div>
                                    <div class="avatar-sm flex-shrink-0">
                                        <span class="avatar-title text-bg-dark rounded rounded-3 fs-3 widget-icon-box-avatar shadow">
                                            <i class="ri-shopping-cart-fill"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="text-center">
                                    <h2 class="fw-bold text-success mt-2">
                                        <?php if(isset($item)): ?>
                                        <strong class="total-venda" style="font-size: 2rem;"><?php echo e(__moeda($item->valor_total)); ?></strong>
                                        <?php else: ?>
                                        <strong class="total-venda" style="font-size: 2rem;">0,00</strong>
                                        <?php endif; ?>
                                    </h2>
                                </div>
                                
                                <!-- Atalhos compactos abaixo do total -->
                                <div class="d-flex justify-content-between bg-light py-1 px-2 rounded mt-1" style="font-size: 0.7rem">
                                    <span><b>F1:</b> Ajuda</span>
                                    <span><b>F2:</b> Código</span>
                                    <span><b>F4:</b> Finalizar</span>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Desconto e Acréscimo (TAMANHO REDUZIDO) -->
                        <div class="card widget-compact div-pagamento mb-pdv">
                            <div class="card-body py-1 valores-pequenos">
                                <div class="row g-0">
                                    <div class="col-6">
                                        <div class="d-flex flex-column align-items-center">
                                            <h5 class="small text-muted">DESCONTO</h5>
                                            <h3 id="valor_desconto">R$ <?php echo e(isset($item) ? __moeda($item->desconto) : '0,00'); ?></h3>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="d-flex flex-column align-items-center">
                                            <h5 class="small text-muted">ACRÉSCIMO</h5>
                                            <h3 id="valor_acrescimo">R$ <?php echo e(isset($item) ? __moeda($item->acrescimo) : '0,00'); ?></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Badge de Crédito do Cliente (apenas informativo) -->
                        <div class="card widget-compact mb-pdv d-none" id="badge-credito-cliente">
                            <div class="card-body py-2">
                                <div class="alert alert-info mb-0 py-2 text-center">
                                    <i class="ri-wallet-3-line me-1"></i>
                                    <strong>Crédito Disponível:</strong> 
                                    <span id="valor-credito-disponivel">R$ 0,00</span>
                                    <br>
                                    <small class="text-muted">Aplique na tela de pagamentos</small>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Botão de Pagamento -->
                        <div class="card widget-compact mb-pdv">
                            <div class="card-body">
                                <button type="button" id="btn-efetuar-pagamento" class="btn btn-secondary active btn-lg w-100">
                                    <i class="ri-bank-card-line align-middle me-1"></i> Efetuar Pagamento [F4]
                                </button>
                            </div>
                        </div>
                        
                                <!-- Ações de Caixa -->
                                <div class="card widget-compact mb-pdv">
                                    <div class="card-body p-2">
                                        <h5 class="text-muted text-uppercase small mb-1 text-center">AÇÕES DO CAIXA</h5>
                                        <div class="row g-1">
                                            <!-- Recebimento sozinho -->    
                                            <div class="col-12">
                                                <button type="button" id="btn-recebimento" class="btn btn-primary btn-lg w-100 mb-1">
                                                    <i class="ri-money-dollar-circle-line align-middle me-1"></i> Recebimento
                                                </button>
                                            </div>

                                            <!-- Sangria e Suprimento lado a lado -->
                                            <div class="col-6">
                                                <button type="button" data-bs-toggle="modal" data-bs-target="#sangria_caixa" class="btn btn-warning btn-lg w-100 mb-1">
                                                    <i class="ri-arrow-down-circle-line align-middle me-1"></i> Sangria
                                                </button>
                                            </div>
                                            <div class="col-6">
                                                <button type="button" data-bs-toggle="modal" data-bs-target="#suprimento_caixa" class="btn btn-success btn-lg w-100 mb-1">
                                                    <i class="ri-arrow-up-circle-line align-middle me-1"></i> Suprimento
                                                </button>
                                            </div>

                                            <!-- Suspender e Vendas Suspensas lado a lado -->
                                            <div class="col-6">
                                                <?php if($isVendaSuspensa == 0): ?>
                                                <button type="button" id="btn-suspender" class="btn btn-secondary btn-lg w-100 mb-1">
                                                    <i class="ri-timer-line align-middle me-1"></i> Suspender
                                                </button>
                                                <?php else: ?>
                                                <a href="<?php echo e(route('frontbox.create')); ?>" class="btn btn-light btn-lg w-100 mb-1">
                                                    <i class="ri-refresh-line"></i> Nova Venda
                                                </a>
                                                <?php endif; ?>
                                            </div>
                                            <div class="col-6">
                                                <?php if(!isset($item)): ?>
                                                <button type="button" class="btn btn-info btn-lg w-100 mb-1 btn-vendas-suspensas" data-bs-toggle="modal" data-bs-target="#vendas_suspensas">
                                                    <i class="ri-time-fill align-middle me-1"></i> V. Suspensas
                                                </button>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <!-- Botão Buscar Pré-venda acima do botão Sair -->
                                        <div class="row g-1 mt-1">
                                            <div class="col-12">
                                                <button type="button" class="btn btn-dark btn-lg w-100" id="btn-buscar-pre-venda" onclick="abrirBuscaPreVenda()">
                                                    <i class="ri-search-line align-middle me-1"></i> Buscar Pré-venda
                                                </button>
                                            </div>
                                        </div>
                                        <!-- Botão Sair abaixo de Buscar Pré-venda -->
                                        <div class="row g-1 mt-1">
                                            <div class="col-12">
                                                <a class="btn btn-danger btn-lg w-100" id="btn-sair-pdv" href="<?php echo e(route('frontbox.index')); ?>">
                                                    <i class="ri-logout-box-line align-middle me-1"></i> Sair
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Aba de Pagamentos (compactada) -->
            <div class="tab-pane fade" id="tab-pagamentos" role="tabpanel" aria-labelledby="tab-pagamentos-tab">
                <div class="pagamento-tab-content">
                    <!-- Valor Total da Venda (versão compacta) -->
                    <div class="row mb-2">
                        <div class="col-12">
                            <div class="card border-left-success shadow-sm total-venda-card fade-in">
                                <div class="card-body py-2">
                                    <div class="row align-items-center">
                                        <div class="col-md-4">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-0">
                                                <i class="ri-money-dollar-circle-line me-1"></i> Valor Total da Venda
                                            </div>
                                            <div class="h1 mb-0 font-weight-bold text-success" id="painel-total-venda">
                                                <?php if(isset($item)): ?>
                                                <?php echo e(__moeda($item->valor_total)); ?>

                                                <?php else: ?>
                                                <span class="total-venda">0,00</span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-md-4 text-center">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-0">
                                                Valor Recebido
                                            </div>
                                            <div class="h1 mb-0 font-weight-bold text-primary" id="valor-recebido-total">
                                                R$ 0,00
                                            </div>
                                        </div>
                                        <div class="col-md-4 text-end">
                                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-0">
                                                Troco
                                            </div>
                                            <div class="h1 mb-0 font-weight-bold text-danger" id="valor-troco">
                                                R$ 0,00
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mb-2">
                        <!-- Cliente e Vendedor (versão compacta) -->
                        <div class="col-md-6 mb-1">
                            <div class="card shadow-sm">
                                <div class="card-body py-2">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="flex-grow-1 overflow-hidden">
                                            <h6 class="text-muted text-uppercase m-0">Cliente</h6>
                                            <?php if(isset($cliente)): ?>
                                            <div class="cliente_selecionado"><?php echo e($cliente->razao_social); ?></div>
                                            <?php else: ?>
                                            <div class="cliente_selecionado">--</div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="avatar-sm flex-shrink-0">
                                            <button type="button" class="avatar-title text-bg-success rounded fs-5 widget-icon-box-avatar shadow btn-selecionar_cliente" 
                                                    data-bs-toggle="modal" data-bs-target="#cliente" data-return-tab="#tab-pagamentos">
                                                <i class="ri-group-line"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-1">
                            <div class="card shadow-sm">
                                <div class="card-body py-2">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="flex-grow-1 overflow-hidden">
                                            <h6 class="text-muted text-uppercase m-0">Vendedor</h6>
                                            <?php if(isset($funcionario)): ?>
                                            <div class="funcionario_selecionado"><?php echo e($funcionario->nome); ?></div>
                                            <?php else: ?>
                                            <div class="funcionario_selecionado">--</div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="avatar-sm flex-shrink-0">
                                            <button type="button" class="avatar-title text-bg-warning rounded fs-5 widget-icon-box-avatar"
                                                    data-bs-toggle="modal" data-bs-target="#funcionario" data-return-tab="#tab-pagamentos">
                                                <i class="ri-user-2-line"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Painel de Pagamentos (versão compacta) -->
                    <div class="row g-2 align-items-stretch">
                       

                        <!-- Painel: Valores Adicionais -->
                        <div class="col-md-6">
                            <div class="card shadow-sm h-100">
                                <div class="card-header py-2">
                                    <h6 class="m-0 font-weight-bold text-primary">Valores Adicionais</h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <!-- Desconto -->
                                        <div class="col-md-6">
                                            <div class="card">
                                                <div class="card-body py-2">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div class="flex-grow-1 overflow-hidden">
                                                            <h6 class="text-muted text-uppercase fs-13 m-0">Desconto</h6>
                                                            <h5 id="valor_desconto_pdv1" class="m-0">R$ 0,00</h5>
                                                        </div>
                                                        <div class="flex-shrink-0">
                                                            <button type="button" onclick="setaDesconto()" class="btn btn-sm btn-primary rounded">
                                                                <i class="ri-checkbox-indeterminate-line"></i> Aplicar
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Acréscimo -->
                                        <div class="col-md-6">
                                            <div class="card">
                                                <div class="card-body py-2">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div class="flex-grow-1 overflow-hidden">
                                                            <h6 class="text-muted text-uppercase fs-13 m-0">Acréscimo</h6>
                                                            <h5 id="valor_acrescimo_pdv1" class="m-0">R$ 0,00</h5>
                                                        </div>
                                                        <div class="flex-shrink-0">
                                                            <button type="button" onclick="setaAcrescimo()" class="btn btn-sm btn-warning rounded">
                                                                <i class="ri-add-box-line"></i> Aplicar
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Crédito do Cliente -->
                                    <div class="row mt-2" id="secao-credito-cliente" style="display: none;">
                                        <div class="col-12">
                                            <div class="card border-info">
                                                <div class="card-body py-2">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div class="flex-grow-1">
                                                            <h6 class="text-info text-uppercase fs-13 m-0">
                                                                <i class="ri-wallet-3-line me-1"></i> Crédito do Cliente
                                                            </h6>
                                                            <h5 id="valor-credito-cliente-pagamento" class="m-0 text-info">R$ 0,00</h5>
                                                        </div>
                                                        <div class="flex-shrink-0">
                                                            <button type="button" id="btn-aplicar-credito" class="btn btn-sm btn-info rounded">
                                                                <i class="ri-check-line"></i> Aplicar Crédito
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Observação -->
                                    <div class="row mt-2">
                                        <div class="col-12">
                                            <div class="alert alert-info p-1 mb-0">
                                                <small><i class="ri-information-line"></i> Para adicionar <strong>desconto</strong> ou <strong>acréscimo</strong> à venda, clique em "Aplicar". Você pode informar valores absolutos ou percentuais (ex: %10 para 10%).</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                         <!-- Painel: Adicionar Forma de Pagamento -->
                        <div class="col-md-6">
                            <div class="card shadow-sm h-100">
                                <div class="card-header py-2">
                                    <h6 class="m-0 font-weight-bold text-primary">Adicionar Forma de Pagamento</h6>
                                </div>
                                <div class="card-body py-2">
                                    <!-- Tipo de Pagamento -->
                                    <div class="row mb-2">
                                        <div class="col-md-6">
                                            <label class="form-label small mb-0">Tipo de Pagamento</label>
                                            <select name="tipo_pagamento_atual" id="tipo_pagamento_atual" class="form-select form-select-sm">
                                                <option value="">Selecione</option>
                                                <?php $__currentLoopData = $tiposPagamento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>"><?php echo e($tipo); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label small mb-0">Valor (R$)</label>
                                            <input type="text" id="valor_pagamento_atual" class="form-control form-control-sm moeda" placeholder="0,00">
                                        </div>
                                    </div>

                                    <!-- Campos específicos para cada tipo de pagamento (compactados) -->
                                    <!-- Cartão -->
                                    <div class="row mb-2 campos-especificos campos-cartao d-none">
                                        <div class="col-md-6">
                                            <label class="form-label small mb-0">Bandeira</label>
                                            <select id="bandeira_cartao" class="form-select form-select-sm">
                                                <option value="">Selecione</option>
                                                <option value="mastercard">Mastercard</option>
                                                <option value="visa">Visa</option>
                                                <option value="elo">Elo</option>
                                                <option value="american">American Express</option>
                                                <option value="hipercard">Hipercard</option>
                                                <option value="outros">Outros</option>
                                            </select>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label small mb-0">Código de Autorização</label>
                                            <input type="text" id="cod_autorizacao" class="form-control form-control-sm" placeholder="Opcional">
                                        </div>
                                    </div>

                                    <!-- Pagamento a Prazo -->
                                    <div class="row mb-2 campos-especificos campos-prazo d-none">
                                        <div class="col-md-4">
                                            <div class="form-check mt-2">
                                                <input class="form-check-input" type="checkbox" id="tem_parcelamento">
                                                <label class="form-check-label small" for="tem_parcelamento">
                                                    Parcelado
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-8 div-data-vencimento">
                                            <label class="form-label small mb-0">Data de Vencimento</label>
                                            <input type="date" id="data_vencimento_atual" class="form-control form-control-sm data_vencimento_padrao">
                                        </div>
                                    </div>

                                    <!-- Parcelamento -->
                                    <div class="row mb-2 campos-especificos campos-parcelamento d-none">
                                        <div class="col-md-4">
                                            <label class="form-label small mb-0">Quantidade de Parcelas</label>
                                            <input type="number" id="qtd_parcelas" class="form-control form-control-sm" min="2" max="48" value="2">
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label small mb-0">Data do 1° Pagamento</label>
                                            <input type="date" id="data_primeiro_pagamento" class="form-control form-control-sm data_atual">
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label small mb-0">Periodicidade (dias)</label>
                                            <input type="number" id="periodicidade" class="form-control form-control-sm" min="1" value="30">
                                        </div>
                                    </div>

                                    <!-- Botão -->
                                    <div class="row">
                                        <div class="col-md-12 text-end">
                                            <button type="button" id="adicionar-pagamento" class="btn btn-success btn-sm">
                                                <i class="ri-add-line"></i> Adicionar Pagamento
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>

                    
                    <!-- Lista de Pagamentos Adicionados (compactada) -->
                    <div class="row mb-2">
                        <div class="col-md-12">
                            <div class="card shadow-sm">
                                <div class="card-header py-2 d-flex justify-content-between align-items-center">
                                    <h6 class="m-0 font-weight-bold text-primary">Pagamentos Registrados</h6>
                                    <div>
                                        <span class="badge bg-warning text-dark p-1" id="valor-restante-badge">
                                            Valor Restante: <span id="valor-restante">R$ 0,00</span>
                                        </span>
                                    </div>
                                </div>
                                <div id="mensagem-pagamento" class="text-center my-1"></div>
                                <div class="card-body py-1">
                                    <div class="table-responsive lista-pagamentos-box">
                                        <table class="table table-bordered table-sm" id="tabela-pagamentos">
                                            <thead>
                                                <tr>
                                                    <th>Tipo</th>
                                                    <th>Valor</th>
                                                    <th>Detalhes</th>
                                                    <th>Ações</th>
                                                </tr>
                                            </thead>
                                            <tbody id="lista-pagamentos">
                                                <!-- Pagamentos serão adicionados aqui via JavaScript -->
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="alert alert-info mt-1 py-1 d-none" id="sem-pagamentos">
                                        <i class="ri-information-line"></i> Nenhum pagamento registrado. Adicione pelo menos uma forma de pagamento.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mb-2">
                        <!-- Observação (compactada) -->
                        <div class="col-md-12">
                            <div class="card shadow-sm">
                                <div class="card-body py-1">
                                    <label class="form-label small mb-0">Observação</label>
                                    <textarea id="observacao" class="form-control form-control-sm" rows="1"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <button type="button" class="btn btn-secondary btn-lg w-100 py-2 text-center h-100" id="btn-voltar-vendas" style="font-size: 1.1rem; line-height: 1.5;">
                                <span class="d-flex align-items-center justify-content-center h-100">
                                    <i class="ri-arrow-go-back-line me-1" style="font-size: 1.4rem; vertical-align: middle;"></i> Voltar para venda
                                </span>
                            </button>
                        </div>
                        <div class="col-md-6">
                            <?php if(isset($item) && $isVendaSuspensa == 0): ?>
                            <button type="button" class="btn btn-success btn-lg w-100 py-2 text-center h-100" id="editar_venda_tab" style="font-size: 1.1rem; line-height: 1.5;">
                                <span class="d-flex align-items-center justify-content-center h-100">
                                    <i class="ri-checkbox-line me-1" style="font-size: 1.4rem; vertical-align: middle;"></i> Editar venda
                                </span>
                            </button>
                            <?php else: ?>
                            <button type="button" class="btn btn-success btn-block w-100 py-2 text-center h-100" id="finalizar_venda_tab" style="font-size: 1.1rem; line-height: 1.5;">
                                <span class="d-flex align-items-center justify-content-center h-100">
                                    <i class="ri-checkbox-line me-1" style="font-size: 1.4rem; vertical-align: middle;"></i> Finalizar venda
                                </span>
                            </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Nova Aba de Recebimentos -->
<div class="tab-pane fade" id="tab-recebimentos" role="tabpanel" aria-labelledby="tab-recebimentos-tab">
    <div class="row">
        <div class="col-12 mb-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="card-title mb-0">Recebimentos</h5>
                        <button id="btn-voltar-vendas-recebimentos" class="btn btn-sm btn-secondary">
                            <i class="ri-arrow-left-line"></i> Voltar
                        </button>
                    </div>
                    
                    <!-- Formulário de Busca -->
                    <div class="row mb-4 justify-content-center">
                        <div class="col-md-9">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="card-title mb-3">Buscar Cliente</h6>
                                    <div class="row g-2">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="cpf_cnpj_recebimento" class="form-label mb-1">Por CPF/CNPJ</label>
                                                <div class="input-group">
                                                    <input type="text" class="form-control" id="cpf_cnpj_recebimento" 
                                                          placeholder="Digite o CPF/CNPJ do cliente" maxlength="18"
                                                          autocomplete="off">
                                                    <button class="btn btn-primary" id="btn-buscar-recebimentos" type="button">
                                                        <i class="ri-search-line"></i> Buscar
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="cliente_id_recebimento" class="form-label mb-1">Por Nome</label>
                                                <select class="form-control select2" id="cliente_id_recebimento" 
                                                    data-placeholder="Pesquisar cliente por nome">
                                                    <option value="">Selecione ou digite para buscar</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <small class="form-text text-muted mt-2">Utilize uma das opções para buscar os lançamentos em aberto do cliente</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Área de resultado após busca -->
                    <div id="resultado-recebimentos" class="mt-4" style="display: none;">
                        <!-- Informações do cliente -->
                        <div class="card mb-3">
                            <div class="card-header bg-light py-2">
                                <h6 class="mb-0">Informações do Cliente</h6>
                            </div>
                            <div class="card-body py-3">
                                <div class="row">
                                    <div class="col-md-6">
                                        <p class="mb-2"><strong>Nome:</strong> <span id="cliente-nome">-</span></p>
                                        <p class="mb-2"><strong>CPF/CNPJ:</strong> <span id="cliente-cpf-cnpj">-</span></p>
                                    </div>
                                    <div class="col-md-6">
                                        <p class="mb-2"><strong>Telefone:</strong> <span id="cliente-telefone">-</span></p>
                                        <p class="mb-2"><strong>Saldo Disponível:</strong> <span id="cliente-saldo" class="text-success fw-bold">-</span></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Lançamentos em aberto -->
                        <div class="card">
                            <div class="card-header bg-light py-2">
                                <h6 class="mb-0">Lançamentos em Aberto</h6>
                            </div>
                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover mb-0">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width: 40px;">✔</th> <!-- NOVA COLUNA DE SELEÇÃO -->
                                                <th>Descrição</th>
                                                <th>Vencimento</th>
                                                <th>Valor</th>
                                                <th>Situação</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tabela-lancamentos">
                                            <!-- Os resultados serão inseridos aqui via JavaScript -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex justify-content-end p-3">
                        <button type="button" id="btn-receber-selecionados" class="btn btn-success" disabled>
                            <i class="ri-money-dollar-circle-line"></i> Receber Selecionada(s)
                        </button>
                    </div>
                    </div>
                    
                    <!-- Mensagem inicial -->
                    <div id="mensagem-inicial-recebimentos" class="text-center p-5">
                        <i class="ri-search-line" style="font-size: 48px; color: #ccc;"></i>
                        <h5 class="mt-3">Busque um cliente pelo CPF/CNPJ ou Nome</h5>
                        <p class="text-muted">Utilize uma das opções acima para buscar os lançamentos em aberto do cliente</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('modals._pagamento_multiplo', ['not_submit' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._finalizar_venda', ['not_submit' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._funcionario', ['not_submit' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._cartao_credito', ['not_submit' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._variacao', ['not_submit' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._lista_precos', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._vendas_suspensas', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._tef_consulta', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('modals._modal_pix', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._fatura_venda', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('modals._observacao_pdv', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._cliente', ['cashback' => 1], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._sangria', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('modals._suprimento', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('js'); ?>
<script src="/js/frente_caixa.js" type=""></script>
<script type="text/javascript" src="/js/mousetrap.js"></script>
<script type="text/javascript" src="/js/controla_conta_empresa.js"></script>
<script src="/js/novo_cliente.js"></script>
<script src="/js/theme_toggle.js"></script>

<script type="text/javascript">
    // Variáveis para impressão definidas pelo servidor
    var sangriaId = "<?php echo e(session('sangria_id')); ?>";
    var suprimentoId = "<?php echo e(session('suprimento_id')); ?>";
    var sangriaUrl = "<?php echo e(route('sangria.print', ['id' => '___ID___'])); ?>".replace('___ID___', sangriaId);
    var suprimentoUrl = "<?php echo e(route('suprimento.print', ['id' => '___ID___'])); ?>".replace('___ID___', suprimentoId);

    // Variáveis para desconto e acréscimo
    var DESCONTO = 0;
    var VALORACRESCIMO = 0;
    var PERCENTUALMAXDESCONTO = 0; // Valor definido de forma segura
    
    // Função global para obter o valor base da venda (sem desconto/acréscimo)
    function getValorBase() {
        // Tenta pegar o valor da classe total-venda (que contém o valor base)
        let valorTexto = $('.total-venda').text().trim();
        
        // Se ainda não encontrar, tenta em outros elementos possíveis
        if (!valorTexto || valorTexto === '') {
            valorTexto = $('.total').text().trim();
        }
        
        // Se ainda não conseguir, retorna valor padrão para evitar NaN
        if (!valorTexto || valorTexto === '') {
            console.error('Não foi possível encontrar o valor base da venda');
            return 0;
        }
        
        // Limpa e converte o texto para número
        valorTexto = valorTexto.replace(/[^\d,]/g, '').replace('.', '').replace(',', '.');
        let valorNumerico = parseFloat(valorTexto);
        
        console.log('Valor base encontrado:', valorTexto);
        
        return valorNumerico || 0;
    }
    
    // Função global para obter o valor total da venda (com desconto/acréscimo)
    function getValorTotal() {
        // Obtém o valor base da venda
        let valorBase = getValorBase();
        
        // Aplica desconto e acréscimo
        let valorTotal = valorBase - DESCONTO + VALORACRESCIMO;
        
        // Log para debug
        console.log('getValorTotal - Valor base:', valorBase, 'Desconto:', DESCONTO, 'Acréscimo:', VALORACRESCIMO, 'Total:', valorTotal);
        
        return valorTotal;
    }
    
    // Função para converter número para formato de moeda
    function convertFloatToMoeda(value) {
        // Garantir que value é um número
        if (value === undefined || value === null || isNaN(value)) {
            console.log("Valor inválido para conversão:", value);
            return "0,00";
        }
        // Garantir que value é um número
        value = parseFloat(value);
        console.log("Convertendo valor para formato moeda:", value);
        return value.toFixed(2).replace('.', ',').replace(/(\d)(?=(\d{3})+\,)/g, "$1.");
    }
    
    // Função para formatar números em moeda brasileira
    function formatarMoeda(valor) {
        return valor.toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });
    }
    
    // Função para atualizar o valor total exibido
    function atualizarValorTotal() {
        // Pega o valor base da venda (sem desconto/acréscimo)
        var valorBase = getValorBase();
        // Calcula o valor final (base - desconto + acréscimo)
        var valorFinal = valorBase - DESCONTO + VALORACRESCIMO;
        // Formata o valor final
        var valorFormatado = convertFloatToMoeda(valorFinal);
        // Atualiza o painel de valor total (aba de pagamentos)
        $('#painel-total-venda').text(valorFormatado);
        // Removido: não atualizar o card principal da venda (.total-venda)
        // ... resto do código ...
        // Atualiza também o restante se a função existir
        if (typeof atualizarListaPagamentos === 'function') {
            atualizarListaPagamentos();
        } else if (typeof calcularValorRestante === 'function') {
            var valorRestante = calcularValorRestante();
            $('#valor-restante').text(`R$ ${formatarMoeda(valorRestante)}`);
        }
        return valorFinal;
    }
    
    // Função para aplicar desconto
    function setaDesconto() {
        let valorTotal = getValorTotal();
        if (valorTotal <= 0) {
            swal("Erro", "Total da venda é igual a zero", "warning");
            return;
        }
        
        swal({
            title: "Valor desconto?",
            text: "Informe o valor ou percentual de desconto (ex: %10 para 10%)",
            content: "input",
            button: {
                text: "Aplicar",
                closeModal: false,
            },
        }).then((valor) => {
            if (valor) {
                let desconto = valor;
                if (desconto.substring(0, 1) == "%") {
                    let perc = desconto.substring(1, desconto.length);
                    // Usa o valor total sem descontos/acréscimos para calcular percentual
                    let valorBase = valorTotal + DESCONTO - VALORACRESCIMO;
                    DESCONTO = valorBase * (perc / 100);
                    
                    if (PERCENTUALMAXDESCONTO > 0) {
                        if (perc > PERCENTUALMAXDESCONTO) {
                            swal.close();
                            setTimeout(() => {
                                swal(
                                    "Erro",
                                    "Máximo de desconto permitido é de " +
                                    PERCENTUALMAXDESCONTO +
                                    "%",
                                    "error"
                                );
                                DESCONTO = 0;
                                $("#valor_desconto_pdv1").text("R$ 0,00");
                            }, 300);
                            return;
                        }
                    }
                } else {
                    desconto = desconto.replace(",", ".");
                    DESCONTO = parseFloat(desconto);
                    
                    if (PERCENTUALMAXDESCONTO > 0) {
                        // Usa o valor total sem descontos/acréscimos para validar percentual máximo
                        let valorBase = valorTotal + DESCONTO - VALORACRESCIMO;
                        let percDesconto = (DESCONTO / valorBase) * 100;
                        
                        if (percDesconto > PERCENTUALMAXDESCONTO) {
                            swal.close();
                            setTimeout(() => {
                                swal(
                                    "Erro",
                                    "Máximo de desconto permitido é de " + PERCENTUALMAXDESCONTO + "%",
                                    "error"
                                );
                                DESCONTO = 0;
                                $("#valor_desconto_pdv1").text("R$ 0,00");
                            }, 300);
                            return;
                        }
                    }
                }
                
                if (desconto.length == 0) DESCONTO = 0;
                console.log("Valor de desconto a ser exibido:", DESCONTO);
                let textoDesconto = "R$ " + convertFloatToMoeda(DESCONTO);
                console.log("Texto de desconto formatado:", textoDesconto);
                
                // Atualiza ambos os elementos para garantir consistência
                $("#valor_desconto_pdv1").text(textoDesconto);
                $("#valor_desconto").text(textoDesconto);
                console.log("Valores de desconto atualizados");
                
                // Atualiza o valor total e recalcula pagamentos
                atualizarValorTotal();
            }
            swal.close();
        });
    }

    // Função para aplicar acréscimo
    function setaAcrescimo() {
        let valorTotal = getValorTotal();
        if (valorTotal <= 0) {
            swal("Erro", "Total da venda é igual a zero", "warning");
            return;
        }
        
        swal({
            title: "Valor acréscimo?",
            text: "Informe o valor ou percentual de acréscimo (ex: %10 para 10%)",
            content: "input",
            button: {
                text: "Aplicar",
                closeModal: false,
            },
        }).then((valor) => {
            if (valor) {
                let acrescimo = valor;
                // Usa o valor total sem descontos/acréscimos para calcular
                let valorBase = valorTotal + DESCONTO - VALORACRESCIMO;
                
                if (acrescimo.substring(0, 1) == "%") {
                    let perc = acrescimo.substring(1, acrescimo.length);
                    VALORACRESCIMO = valorBase * (perc / 100);
                } else {
                    acrescimo = acrescimo.replace(",", ".");
                    VALORACRESCIMO = parseFloat(acrescimo);
                }
                
                if (acrescimo.length == 0) VALORACRESCIMO = 0;
                console.log("Valor de acréscimo a ser exibido:", VALORACRESCIMO);
                let textoAcrescimo = "R$ " + convertFloatToMoeda(VALORACRESCIMO);
                console.log("Texto de acréscimo formatado:", textoAcrescimo);
                
                // Atualiza ambos os elementos para garantir consistência
                $("#valor_acrescimo_pdv1").text(textoAcrescimo);
                $("#valor_acrescimo").text(textoAcrescimo);
                console.log("Valores de acréscimo atualizados");
                
                // Atualiza o valor total e recalcula pagamentos
                atualizarValorTotal();
            }
            swal.close();
        });
    }

    // Função para mostrar dicas extras sobre o uso do PDV
    function mostrarDicaQuantidade() {
        // Exibe a dica independentemente da configuração de sessionStorage
        toastr.info(
            '<div class="pdv-dicas">' +
            '<ul style="padding-left: 15px; margin-bottom: 0;">' +
            '<li><strong>Quantidade + *</strong>: Define quantidade (Ex: 5*)</li>' +
            '<li><strong>Enter</strong>: Adiciona produto pelo código</li>' +
            '<li><strong>F2</strong>: Ativa/desativa leitor</li>' +
            '<li><strong>F4</strong>: Finaliza venda</li>' +
            '<li><strong>F7</strong>: Limpa quantidade</li>' +
            '</ul>' +
            '</div>',
            '<i class="ri-information-line me-1"></i> Atalhos do PDV',
            {
                timeOut: 15000,
                extendedTimeOut: 7000,
                closeButton: true,
                progressBar: true,
                positionClass: "toast-top-center",
                closeHtml: '<button><i class="ri-close-line"></i></button>'
            }
        );
    }
    
    // Função para rolar a grid de produtos até o último item adicionado
    function scrollToLastAddedProduct() {
        const tableContainer = document.querySelector('.tabela-produtos-pdv');
        if (tableContainer) {
            // Rola até o final da tabela
            tableContainer.scrollTop = tableContainer.scrollHeight;
        }
    }

    // Executa quando o documento estiver pronto
    $(document).ready(function() {
        // Configuração dos atalhos de teclado
        // F2: Focar no campo de código de barras
        Mousetrap.bind('f2', function() {
            $('#codBarras').focus();
            return false; // Evita o comportamento padrão da tecla
        });
        
        // F4: Ativar o painel de pagamento (se o botão estiver habilitado)
        Mousetrap.bind('f4', function() {
            // Simulamos um clique no botão de efetuar pagamento, que já tem a validação
            $('#btn-efetuar-pagamento').click();
            return false; // Evita o comportamento padrão da tecla
        });
        
        // Foca no campo de código de barras quando a página é carregada
        setTimeout(function() {
            $('#codBarras').focus();
        }, 500);
        
        // Atualiza quando algum produto for adicionado e rola para o último item
        $('.btn-add-item').on('click', function() {
            setTimeout(function() {
                scrollToLastAddedProduct();
            }, 300);
        });
        
        // Atualiza o valor total no painel de pagamento quando ele for aberto
        $('#btn-efetuar-pagamento').on('click', function(event) {
            // Captura o valor atual da venda
            var valorTexto = $('.total-venda').text().trim();
            var valorLimpo = valorTexto.replace(/[^\d,]/g, '').replace(',', '.');
            var valorTotal = parseFloat(valorLimpo) || 0;
            
            console.log('Verificando valor total:', valorTexto, '→', valorLimpo, '→', valorTotal);
            
            if (valorTotal > 0) {
                // Aplica desconto e acréscimo ao valor total
                valorTotal = valorTotal - DESCONTO + VALORACRESCIMO;
                valorTexto = convertFloatToMoeda(valorTotal);
                
                // Atualiza o valor no painel de pagamento
                $('#painel-total-venda').text(valorTexto);
                console.log('Valor total atualizado no painel (com desconto/acréscimo):', valorTexto);
                
                // Abre o painel de pagamento usando jQuery
                $('#painel-efetuar-pagamento').offcanvas('show');
            } else {
                // Mostra mensagem que é necessário adicionar itens à venda
                toastr.warning('É necessário adicionar itens à venda para efetuar o pagamento.');
            }
        });
        
        // Controla a exibição do campo de data de vencimento com base no tipo de pagamento
        $('.tp-pag').on('change', function() {
            var tipoPagamento = $(this).val();
            if(tipoPagamento === '06') {  // Crediário
                $('.div-vencimento').removeClass('d-none');
                
                // Se o cliente não estiver selecionado, mostra alerta
                if($('.cliente_selecionado').text() === '--') {
                    toastr.warning('É necessário selecionar um cliente para pagamento a crediário.');
                }
            } else {
                $('.div-vencimento').addClass('d-none');
            }
            
            // Controla a exibição do campo de dinheiro recebido e troco
            if(tipoPagamento === '01') {  // Dinheiro
                $('.div-troco').removeClass('d-none');
            } else {
                $('.div-troco').addClass('d-none');
            }
        });
        
        // Captura o ID do cliente quando selecionado
        $(document).on('selecionaCliente', function(e, cliente) {
            if (cliente && cliente.id) {
                $('.btn-selecionar_cliente').data('cliente-id', cliente.id);
                console.log('Cliente ID armazenado:', cliente.id);
            }
        });        
        // Botão específico para abrir o modal de finalização 
        $('#finalizar_venda_tab').on('click', function() {
            console.log("Botão de finalizar venda clicado");
            
            // Verificar se há pagamentos registrados
            if (pagamentosRegistrados && pagamentosRegistrados.length === 0) {
                swal('Atenção', 'Adicione pelo menos uma forma de pagamento para finalizar a venda', 'warning');
                return;
            }
            
            // Verificar valor restante se houver pagamentos
            if (pagamentosRegistrados && pagamentosRegistrados.length > 0) {
                const valorRestante = calcularValorRestante();
                if (valorRestante > 0) {
                    swal('Atenção', `Ainda falta R$ ${formatarMoeda(valorRestante)} para completar o valor total da venda`, 'warning');
                    return;
                }
            }
            
            // Abre o modal de finalização
            $('#finalizar_venda').modal('show');
        });

        // Garantir que o botão de finalizar na tela principal também funcione
        $('#btn-finalizar').on('click', function() {
            $('#finalizar_venda').modal('show');
        });
        
        // Verificar se há sangria ou suprimento para abrir a impressão
        if (sangriaId) {
            setTimeout(function() {
                window.open(sangriaUrl, '_blank');
            }, 500);
        }
        
        if (suprimentoId) {
            setTimeout(function() {
                window.open(suprimentoUrl, '_blank');
            }, 500);
        }
        
        // Remover manipuladores antigos para evitar conflitos
        $('#btn-confirmar-sangria, #btn-confirmar-suprimento').off('click');
        
        // Implementação simples e direta do botão de sangria
        $('#btn-confirmar-sangria').on('click', function() {
            // Validação básica do valor
            var valor = $('#valor_sangria').val();
            if (!valor || valor === '' || parseFloat(valor.replace(/\./g, '').replace(',', '.')) <= 0) {
                toastr.error('Informe um valor válido para a sangria.');
                $('#valor_sangria').focus();
                return false;
            }
            
            // Desativar o botão para evitar duplo clique
            $(this).prop('disabled', true);
            
            // Submeter o formulário diretamente
            document.getElementById('form-sangria-submit').submit();
        });
        
        // Implementação simples e direta do botão de suprimento
        $('#btn-confirmar-suprimento').on('click', function() {
            // Validação básica do valor
            var valor = $('#valor_suprimento').val();
            if (!valor || valor === '' || parseFloat(valor.replace(/\./g, '').replace(',', '.')) <= 0) {
                toastr.error('Informe um valor válido para o suprimento.');
                $('#valor_suprimento').focus();
                return false;
            }
            
            // Validação do tipo de pagamento
            var tipoPagamento = $('#tipo_pagamento').val();
            if (!tipoPagamento || tipoPagamento === '') {
                toastr.error('O tipo de pagamento é obrigatório.');
                $('#tipo_pagamento').focus();
                return false;
            }
            
            // Desativar o botão para evitar duplo clique
            $(this).prop('disabled', true);
            
            // Submeter o formulário diretamente
            document.getElementById('form-suprimento-submit').submit();
        });
        
        // Desativar eventos AJAX que possam estar interferindo com o envio do formulário
        $('#form-sangria-submit, #form-suprimento-submit').off('submit');
        
        // Configurar eventos para exibir formulários de Sangria e Suprimento
        $('#btn-exibir-sangria').on('click', function() {
            console.log('Botão de exibir sangria clicado');
            $('#selecao-operacoes').addClass('d-none');
            $('#form-sangria').removeClass('d-none');
            // Focar no campo de valor
            setTimeout(function() {
                $('#valor_sangria').focus();
            }, 100);
        });
        
        $('#btn-exibir-suprimento').on('click', function() {
            console.log('Botão de exibir suprimento clicado');
            $('#selecao-operacoes').addClass('d-none');
            $('#form-suprimento').removeClass('d-none');
            // Focar no campo de valor
            setTimeout(function() {
                $('#valor_suprimento').focus();
            }, 100);
        });
        
        // Configurar botões de voltar
        $('#btn-voltar-sangria').on('click', function() {
            console.log('Botão de voltar sangria clicado');
            $('#form-sangria').addClass('d-none');
            $('#selecao-operacoes').removeClass('d-none');
            // Limpar campos
            $('#valor_sangria').val('');
            $('#obs_sangria').val('');
        });
        
        $('#btn-voltar-suprimento').on('click', function() {
            console.log('Botão de voltar suprimento clicado');
            $('#form-suprimento').addClass('d-none');
            $('#selecao-operacoes').removeClass('d-none');
            // Limpar campos
            $('#valor_suprimento').val('');
            $('#tipo_pagamento').val('');
            $('#obs_suprimento').val('');
        });
        
        // Quando a página carrega, rolar para o último item (caso já existam produtos)
        setTimeout(scrollToLastAddedProduct, 500);
        
        // Adicionar observador para monitorar quando novos produtos são adicionados à grid
        const observerTarget = document.querySelector('.table-itens tbody');
        if (observerTarget) {
            const observer = new MutationObserver(function(mutations) {
                mutations.forEach(function(mutation) {
                    if (mutation.type === 'childList' && mutation.addedNodes.length > 0) {
                        // Um novo produto foi adicionado à tabela
                        scrollToLastAddedProduct();
                    }
                });
            });
            
            // Configurar e iniciar o observador
            observer.observe(observerTarget, { childList: true });
        }
    });

    // Função para ir para a aba de pagamentos
    function irParaAbaPagamentos() {
        console.log("Tentando ir para aba de pagamentos");
        
        // Verificar valor total da venda - simplificando para garantir o comportamento correto
        var valorTexto = $('.total-venda').text().trim();
        console.log("Texto do valor total: '" + valorTexto + "'");
        
        // Remove símbolos e formata para converter corretamente
        valorTexto = valorTexto.replace(/[^\d,]/g, '').replace(',', '.');
        var valorTotal = parseFloat(valorTexto) || 0;
        
        console.log("Valor total convertido: " + valorTotal);
        
        // Verificação simples: se o valor total for menor ou igual a zero, mostrar mensagem
        if (valorTotal <= 0) {
            swal('Atenção', 'Adicione ao menos um produto para finalizar a venda', 'warning');
            return false;
        }
        
        // Se chegou aqui, o valor é válido - atualiza o valor no painel
        // Usar nossa função para atualizar o valor total com desconto/acréscimo
        atualizarValorTotal();
        
        // Muda para a aba de pagamentos de forma robusta
        $('#pdv-tabs a[href="#tab-pagamentos"]').tab('show');
        
        // Força a visibilidade da aba correta
        $('.tab-pane').removeClass('show active').hide();
        $('#tab-pagamentos').addClass('show active').show();
        
        // Atualiza os estados das tabs na navegação
        $('.nav-link').removeClass('active');
        $('#tab-pagamentos-tab').addClass('active');
        
        return true;
    }

    function irParaAbaRecebimentos() {
        console.log("Tentando ir para aba de recebimentos");

        var valorTexto = $('.total-venda').text().trim();
        console.log("Texto do valor total: '" + valorTexto + "'");

        valorTexto = valorTexto.replace(/[^\d,]/g, '').replace(',', '.');
        var valorTotal = parseFloat(valorTexto) || 0;

        console.log("Valor total convertido: " + valorTotal);

        if (valorTotal > 0) {
            swal({
                title: "Atenção",
                text: "Finalize a venda para efetuar o recebimento.",
                icon: "warning",
                button: "Entendi"
            }).then(() => {
                $('.tab-pane').removeClass('show active').hide();
                $('#tab-vendas').addClass('show active').show();
                
                // Atualiza os estados das tabs na navegação
                $('.nav-link').removeClass('active');
                $('#tab-vendas-tab').addClass('active');
            });
            return;
        }

        // Ação permitida: troca para aba de recebimentos
        $('#pdv-tabs a[href="#tab-recebimentos"]').tab('show');

        $('.tab-pane').removeClass('show active').hide();
        $('#tab-recebimentos').addClass('show active').show();

        $('.nav-link').removeClass('active');
        $('#tab-recebimentos-tab').addClass('active');
    }


    // Botão voltar para vendas
    $('#btn-voltar-vendas').on('click', function() {
        // Força a visibilidade da aba correta
        $('.tab-pane').removeClass('show active').hide();
        $('#tab-vendas').addClass('show active').show();
        
        // Atualiza os estados das tabs na navegação
        $('.nav-link').removeClass('active');
        $('#tab-vendas-tab').addClass('active');
    });

    // Efetuar pagamento com botão dedicado
    $('#btn-efetuar-pagamento').on('click', function(event) {
        irParaAbaPagamentos();
    });

    $('#btn-recebimento').on('click', function(event) {
        irParaAbaRecebimentos(); 
    });

    // Função para finalizar a venda da aba de pagamentos
    $('#finalizar_venda_tab').on('click', function() {
        // Mesma lógica do botão original de finalizar
        finalizarVenda();
    });

    // Função para editar a venda da aba de pagamentos
    $('#editar_venda_tab').on('click', function() {
        // Mesma lógica do botão original de editar
        editarVenda();
    });

    // Atalhos de teclado
    $(document).on('keydown', function(e) {
        // F4 = 115
        if (e.keyCode === 115) {
            e.preventDefault();
            irParaAbaPagamentos();
        }
    });

    // Botões específicos de navegação
    $('#btn-pagamento, #btn-finalizar, .btn-finalizar, .btn-pagamento').on('click', function() {
        irParaAbaPagamentos();
    });

    // Gerenciamento do novo painel de pagamentos
    $(document).ready(function() {
        // Definir as datas padrão
        const hoje = new Date();
        const dataVencimentoPadrao = new Date();
        dataVencimentoPadrao.setDate(hoje.getDate() + 30); // Padrão: hoje + 30 dias
        
        $('.data_atual').val(formatarData(hoje));
        $('.data_vencimento_padrao').val(formatarData(dataVencimentoPadrao));
        $('#data_primeiro_pagamento').val(formatarData(dataVencimentoPadrao));
        
        // Lista de tipos de pagamento e suas categorias
        const tiposPagamento = {
            // À vista (só valor)
            '01': { nome: 'Dinheiro', tipo: 'vista' },
            '17': { nome: 'PIX', tipo: 'vista' },
            '10': { nome: 'Vale Alimentação', tipo: 'vista' },
            '11': { nome: 'Vale Refeição', tipo: 'vista' },
            '02': { nome: 'Cheque', tipo: 'vista' },
            '13': { nome: 'Vale Presente', tipo: 'vista' },
            '14': { nome: 'Vale Combustível', tipo: 'vista' },
            '16': { nome: 'Depósito Bancário', tipo: 'vista' },
            
            // Cartão (valor + bandeira + autorização opcional)
            '04': { nome: 'Cartão de Débito', tipo: 'cartao' },
            '03': { nome: 'Cartão de Crédito', tipo: 'cartao' },
            
            // Prazo/parcelamento (valor + data vencimento + parcelamento opcional)
            '06': { nome: 'Crediário', tipo: 'prazo' },
            '05': { nome: 'Crédito Loja', tipo: 'prazo' },
            '15': { nome: 'Boleto', tipo: 'prazo' },
            '14': { nome: 'Duplicata Mercantil', tipo: 'prazo' },
            
            // TEF (manter como está)
            '07': { nome: 'Cartão de Crédito TEF', tipo: 'tef' },
            '08': { nome: 'Cartão de Débito TEF', tipo: 'tef' },
            '12': { nome: 'PIX TEF', tipo: 'tef' }
        };
        
        // Variáveis para controle de pagamentos
        let pagamentosRegistrados = [];
        let pagamentoId = 0;
        
        // Inicializar o valor restante no carregamento da página
        $(document).ready(function() {
            // Inicializa a exibição dos valores
            setTimeout(function() {
                const valorTotal = getValorTotal();
                if (valorTotal > 0) {
                    $('#valor-restante').text(`R$ ${formatarMoeda(valorTotal)}`);
                    $('#mensagem-pagamento').html('<span class="text-warning">Adicione pagamentos para cobrir o valor total da venda.</span>');
                }
            }, 500); // Pequeno delay para garantir que os elementos estão carregados
        });
        
        // Controle de campos específicos por tipo de pagamento
        $('#tipo_pagamento_atual').on('change', function() {
            const tipoPagamento = $(this).val();
            
            // Esconde todos os campos específicos
            $('.campos-especificos').addClass('d-none');
            
            if (!tipoPagamento) return;
            
            // Identifica o tipo de pagamento e mostra os campos correspondentes
            if (tiposPagamento[tipoPagamento]) {
                const tipo = tiposPagamento[tipoPagamento].tipo;
                
                switch(tipo) {
                    case 'cartao':
                        $('.campos-cartao').removeClass('d-none');
                        break;
                    case 'prazo':
                        $('.campos-prazo').removeClass('d-none');
                        $('#tem_parcelamento').prop('checked', false);
                        $('.campos-parcelamento').addClass('d-none');
                        break;
                    case 'tef':
                        // TEF possui tratamento especial - usar o modal existente
                        break;
                }
            }
            
            // Preenche o valor total restante por padrão
            setTimeout(function() {
                const valorRestante = calcularValorRestante();
                if (valorRestante > 0) {
                    $('#valor_pagamento_atual').val(formatarMoeda(valorRestante));
                }
            }, 100);
        });
        
        // Controle de parcelamento
        $('#tem_parcelamento').on('change', function() {
            if ($(this).is(':checked')) {
                $('.div-data-vencimento').addClass('d-none');
                $('.campos-parcelamento').removeClass('d-none');
            } else {
                $('.div-data-vencimento').removeClass('d-none');
                $('.campos-parcelamento').addClass('d-none');
            }
        });
        
        // Adicionar pagamento à lista
        $('#adicionar-pagamento').on('click', function() {
            console.log("Handler original do botão adicionar-pagamento acionado");
            
            const tipoPagamento = $('#tipo_pagamento_atual').val();
            const valorPagamento = $('#valor_pagamento_atual').val();
            
            // Validações básicas
            if (!tipoPagamento) {
                swal('Atenção', 'Selecione um tipo de pagamento', 'warning');
                return;
            }
            // Bloquear 'Sem Pagamento' se total da venda for maior que zero
            if (tipoPagamento === '90' && getValorTotal() > 0) {
                swal('Atenção', 'A forma de pagamento "Sem Pagamento" só pode ser usada quando o valor total da venda for zero.', 'warning');
                return;
            }
            // Permitir valor 0,00 apenas se for SEM PAGAMENTO (90) e total da venda for zero
            if (
                (!valorPagamento || parseFloat(valorPagamento.replace(/\./g, '').replace(',', '.')) <= 0)
                && !(tipoPagamento === '90' && getValorTotal() === 0)
            ) {
                swal('Atenção', 'Informe um valor válido para o pagamento', 'warning');
                return;
            }
            
            // Validação de cliente para pagamentos a prazo
            if ((tipoPagamento == '06' || tipoPagamento == '05' || tipoPagamento == '15') 
                && $('.cliente_selecionado').text() === '--') {
                swal('Atenção', 'Selecione um cliente para pagamento a prazo', 'warning');
                return;
            }
            
            // Criação do objeto de pagamento
            let valorNumerico = parseFloat(valorPagamento && valorPagamento.replace ? valorPagamento.replace(/\./g, '').replace(',', '.') : valorPagamento);
            if (isNaN(valorNumerico) || valorNumerico === null || valorNumerico === undefined) valorNumerico = 0;
            let detalhes = '';
            let pagamento = {
                id: pagamentoId++,
                tipo: tipoPagamento,
                tipoNome: $('#tipo_pagamento_atual option:selected').text(),
                valor: valorNumerico,
                valorFormatado: valorPagamento
            };
            
            // Dados específicos por tipo de pagamento
            if (tiposPagamento[tipoPagamento]) {
                const tipo = tiposPagamento[tipoPagamento].tipo;
                
                switch(tipo) {
                    case 'cartao':
                        const bandeira = $('#bandeira_cartao').val();
                        const codAutorizacao = $('#cod_autorizacao').val();
                        
                        pagamento.bandeira = bandeira;
                        pagamento.codAutorizacao = codAutorizacao;
                        
                        if (bandeira) {
                            detalhes += `Bandeira: ${bandeira}`;
                        }
                        if (codAutorizacao) {
                            detalhes += detalhes ? ` | Autorização: ${codAutorizacao}` : `Autorização: ${codAutorizacao}`;
                        }
                        break;
                        
                    case 'prazo':
                        const temParcelamento = $('#tem_parcelamento').is(':checked');
                        
                        if (temParcelamento) {
                            const qtdParcelas = $('#qtd_parcelas').val();
                            const dataPrimeiroPagamento = $('#data_primeiro_pagamento').val();
                            const periodicidade = $('#periodicidade').val();
                            
                            pagamento.parcelado = true;
                            pagamento.parcelas = qtdParcelas;
                            pagamento.dataPrimeiroPagamento = dataPrimeiroPagamento;
                            pagamento.periodicidade = periodicidade;
                            
                            detalhes = `${qtdParcelas}x de ${formatarMoeda(valorNumerico / qtdParcelas)} | Início: ${formatarDataBR(dataPrimeiroPagamento)}`;
                        } else {
                            const dataVencimento = $('#data_vencimento_atual').val();
                            
                            pagamento.parcelado = false;
                            pagamento.dataVencimento = dataVencimento;
                            
                            detalhes = `Vencimento: ${formatarDataBR(dataVencimento)}`;
                        }
                        break;
                }
            }
            
            pagamento.detalhes = detalhes;
            
            // Adiciona o pagamento à lista
            pagamentosRegistrados.push(pagamento);
            
            // IMPORTANTE: Sincroniza com a variável global usada pelo sistema
            window.pagamentosRegistradosPDV = pagamentosRegistrados;
            console.log("Pagamentos registrados na variável global:", window.pagamentosRegistradosPDV);
            
            // Adicionando inputs hidden ao formulário
            const $form = $('#form-pdv');
            
            // Remove inputs anteriores para evitar duplicação
            $form.find('input[name^="pagamentos"]').remove();
            
            // Adiciona inputs para cada pagamento
            window.pagamentosRegistradosPDV.forEach((pag, idx) => {
                // Dados básicos
                $form.append(`<input type="hidden" name="pagamentos[${idx}][tipo]" value="${pag.tipo}">`);
                $form.append(`<input type="hidden" name="pagamentos[${idx}][valor]" value="${pag.valor}">`);
                
                // Campos opcionais
                if (pag.bandeira) {
                    $form.append(`<input type="hidden" name="pagamentos[${idx}][bandeira]" value="${pag.bandeira}">`);
                }
                
                if (pag.codAutorizacao) {
                    $form.append(`<input type="hidden" name="pagamentos[${idx}][cod_autorizacao]" value="${pag.codAutorizacao}">`);
                }
                
                if (pag.dataVencimento) {
                    $form.append(`<input type="hidden" name="pagamentos[${idx}][data_vencimento]" value="${pag.dataVencimento}">`);
                }
                
                // Se for pagamento parcelado
                if (pag.parcelado) {
                    $form.append(`<input type="hidden" name="pagamentos[${idx}][parcelado]" value="1">`);
                    $form.append(`<input type="hidden" name="pagamentos[${idx}][parcelas]" value="${pag.parcelas}">`);
                    $form.append(`<input type="hidden" name="pagamentos[${idx}][data_primeiro_pagamento]" value="${pag.dataPrimeiroPagamento}">`);
                    $form.append(`<input type="hidden" name="pagamentos[${idx}][periodicidade]" value="${pag.periodicidade}">`);
                }
            });
            
            console.log("Inputs hidden adicionados ao formulário");
            
            // Continua com o código original
            // Atualiza a interface
            atualizarListaPagamentos();
            
            // Limpa os campos do formulário
            $('#tipo_pagamento_atual').val('');
            $('#valor_pagamento_atual').val('');
            $('.campos-especificos').addClass('d-none');
            $('#bandeira_cartao').val('');
            $('#cod_autorizacao').val('');
            $('#tem_parcelamento').prop('checked', false);
        });
        
        // Função para calcular o valor restante
        function calcularValorRestante() {
            // Usar a função getValorTotal que já existe no código
            let valorTotal = getValorTotal();
            let totalPago = pagamentosRegistrados.reduce((sum, item) => sum + parseFloat(item.valor), 0);
            
            // Aplicar arredondamento para evitar problemas de precisão de ponto flutuante
            totalPago = Math.round(totalPago * 100) / 100;
            valorTotal = Math.round(valorTotal * 100) / 100;
            
            let valorRestante = valorTotal - totalPago;
            
            // Evitar valores muito pequenos negativos por causa de arredondamento
            if (valorRestante > -0.01 && valorRestante < 0) {
                valorRestante = 0;
            }
            
            // Atualizar os valores exibidos
            $('#valor-total-venda').text('R$ ' + formatarMoeda(valorTotal));
            $('#valor-pago').text('R$ ' + formatarMoeda(totalPago));
            $('#valor-restante').text('R$ ' + formatarMoeda(valorRestante));
            
            // Calcular e exibir o troco se aplicável
            const troco = totalPago > valorTotal ? totalPago - valorTotal : 0;
            $('#valor-troco').text('R$ ' + formatarMoeda(troco));
            
            console.log("Calculando valor restante. Total da venda:", valorTotal, "Total pago:", totalPago, "Restante:", valorRestante);
            
            return valorRestante;
        }
        
        // Atualiza a lista de pagamentos na interface
        function atualizarListaPagamentos() {
            const $lista = $('#lista-pagamentos');
            const $semPagamentos = $('#sem-pagamentos');
            const $tabelaPagamentos = $('#tabela-pagamentos');
            const $finalizarBtn = $('#finalizar_venda_tab');
            
            // Atualiza o valor total primeiro
            atualizarValorTotal();
            
            // Limpa a lista atual
            $lista.empty();
            
            // Obtém o valor total da venda já com desconto/acréscimo
            const valorTotal = getValorTotal();
            console.log('Valor total para cálculo do restante:', valorTotal);
            
            if (pagamentosRegistrados.length === 0) {
                $semPagamentos.removeClass('d-none');
                $tabelaPagamentos.addClass('d-none');
                // Desabilita o botão quando não há pagamentos
                $finalizarBtn.prop('disabled', true);
                
                // Quando não há pagamentos, o valor restante é o valor total da venda
                $('#valor-recebido-total').text(`R$ 0,00`);
                $('#valor-restante').text(`R$ ${formatarMoeda(valorTotal)}`);
                
                const $valorRestanteBadge = $('#valor-restante-badge');
                $valorRestanteBadge.removeClass('bg-success text-white').addClass('bg-warning text-dark');
                
                // Mensagem informativa quando não há pagamentos
                $('#mensagem-pagamento').html('<span class="text-warning">Adicione pagamentos para cobrir o valor total da venda.</span>');
                
                return; // Encerra a função aqui, pois não há mais processamento necessário
            } else {
                $semPagamentos.addClass('d-none');
                $tabelaPagamentos.removeClass('d-none');
                
                // Adiciona cada pagamento à tabela
                pagamentosRegistrados.forEach(pagamento => {
                    const $row = $('<tr>');
                    $row.append(`<td>${pagamento.tipoNome}</td>`);
                    $row.append(`<td>R$ ${pagamento.valorFormatado}</td>`);
                    $row.append(`<td>${pagamento.detalhes || '-'}</td>`);
                    
                    const $acoes = $('<td>');
                    const $btnRemover = $('<button class="btn btn-sm btn-danger">').html('<i class="ri-delete-bin-line"></i>');
                    
                    $btnRemover.on('click', function() {
                        removerPagamento(pagamento.id);
                    });
                    
                    $acoes.append($btnRemover);
                    $row.append($acoes);
                    
                    $lista.append($row);
                });
            }
            
            // Atualiza o valor total recebido e o valor restante
            const valorPago = pagamentosRegistrados.reduce((total, p) => total + p.valor, 0);
            const valorRestante = calcularValorRestante();
            
            $('#valor-recebido-total').text(`R$ ${formatarMoeda(valorPago)}`);
            $('#valor-restante').text(`R$ ${formatarMoeda(valorRestante)}`);
            
            // Calcular e exibir o troco quando o valor recebido for maior que o valor total
            const valorTotalVenda = getValorTotal();
            const troco = valorPago > valorTotalVenda ? valorPago - valorTotalVenda : 0;
            $('#valor-troco').text(`R$ ${formatarMoeda(troco)}`);
            
            // Destacar visualmente o troco quando existir
            if (troco > 0) {
                $('#valor-troco').removeClass('text-gray-800').addClass('text-success');
                
                // Consideramos pagamento completo se o valor restante for zero ou muito próximo (tolerância de 0.01)
                if (valorRestante <= 0.01) {
                    $('#mensagem-pagamento').html('<span class="text-success">Pagamento completo. Troco disponível: R$ ' + formatarMoeda(troco) + '. Você já pode finalizar a venda.</span>');
                }
            } else {
                $('#valor-troco').removeClass('text-success').addClass('text-gray-800');
            }
            
            const $valorRestanteBadge = $('#valor-restante-badge');
            
            // Consideramos pagamento completo se o valor restante for zero ou muito próximo (tolerância de 0.01)
            if (valorRestante <= 0.01) {
                $valorRestanteBadge.removeClass('bg-warning').addClass('bg-success text-white');
                // Habilita o botão de finalizar venda quando o valor dos pagamentos for >= valor total
                $finalizarBtn.prop('disabled', false);
                // Adiciona mensagem informativa para o usuário
                $('#mensagem-pagamento').html('<span class="text-success">Pagamento completo. Você já pode finalizar a venda.</span>');
            } else {
                $valorRestanteBadge.removeClass('bg-success text-white').addClass('bg-warning text-dark');
                // Desabilita o botão quando o valor dos pagamentos for < valor total
                $finalizarBtn.prop('disabled', true);
                // Adiciona mensagem informativa para o usuário
                $('#mensagem-pagamento').html('<span class="text-warning">Adicione pagamentos suficientes para cobrir o valor total antes de finalizar.</span>');
            }
        }
        
        // Remove um pagamento da lista
        function removerPagamento(id) {
            pagamentosRegistrados = pagamentosRegistrados.filter(p => p.id !== id);
            atualizarListaPagamentos();
        }
        
        // Atualizar o botão de finalizar venda
        $('#finalizar_venda_tab').off('click').on('click', function() {
            if (pagamentosRegistrados.length === 0) {
                swal('Atenção', 'Adicione pelo menos uma forma de pagamento para finalizar a venda', 'warning');
                return;
            }
            
            const valorRestante = calcularValorRestante();
            // Consideramos pagamento completo se o valor restante for zero ou muito próximo (tolerância de 0.01)
            if (valorRestante > 0.01) {
                swal('Atenção', `Ainda falta R$ ${formatarMoeda(valorRestante)} para completar o valor total da venda`, 'warning');
                return;
            }
            
            // Preenche os dados para o modal de finalização existente
            const observacao = $("#observacao").val() || '';
            
            // Configurar para o modal usando os pagamentos registrados
            if (observacao) {
                $("input[name='observacao']").val(observacao);
            }
            
            // Armazena os pagamentos para uso no modal de finalização
            window.pagamentosRegistradosPDV = pagamentosRegistrados;
            
            // Abre o modal de finalização existente
            $('#modal_finalizar_venda').modal('show');
        });
        
        // Funções auxiliares
        function formatarData(data) {
            const dia = data.getDate().toString().padStart(2, '0');
            const mes = (data.getMonth() + 1).toString().padStart(2, '0');
            const ano = data.getFullYear();
            return `${ano}-${mes}-${dia}`;
        }
        
        function formatarDataBR(dataIso) {
            if (!dataIso) return '';
            const [ano, mes, dia] = dataIso.split('-');
            return `${dia}/${mes}/${ano}`;
        }
        
        // Inicializa a visualização
        atualizarListaPagamentos();
    });

    // Desabilitar navegação direta por clique nas abas
    $(document).ready(function() {
        // Desabilitar cliques nas abas
        $('.nav-link, [data-bs-toggle="tab"], [data-toggle="tab"]').off('click').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            return false;
        });
        
        // Remover atributos de toggle do bootstrap
        $('.nav-link, [data-bs-toggle="tab"], [data-toggle="tab"]').attr('data-bs-toggle', '').attr('data-toggle', '');
        
        // Adicionar classe visual para indicar que não é clicável
        $('.nav-link, [data-bs-toggle="tab"], [data-toggle="tab"]').addClass('disable-click');
        
        // Garantir que aba inicial esteja visível
        $('.tab-pane').hide();
        $('.tab-pane.active').show();
    });

    // Correção específica para garantir que o botão de finalizar abra o modal
    $(document).ready(function() {
        console.log("Adicionando event handler específico para botão de finalizar venda");
        
        // Usando delegação de eventos para garantir que funcione mesmo se o DOM mudar
        $(document).on('click', '#finalizar_venda_tab', function(e) {
            e.preventDefault();
            e.stopPropagation();
            console.log("Botão 'finalizar_venda_tab' clicado - abrindo modal");
            
            // Forçar abertura do modal diretamente
            $('#finalizar_venda').modal('show');
            
            return false;
        });
        
        // Verificar se o botão existe e adicionar log para diagnóstico
        setTimeout(function() {
            if ($('#finalizar_venda_tab').length) {
                console.log("Botão 'finalizar_venda_tab' encontrado no DOM");
            } else {
                console.error("Botão 'finalizar_venda_tab' NÃO encontrado no DOM");
            }
            
            if ($('#finalizar_venda').length) {
                console.log("Modal 'finalizar_venda' encontrado no DOM");
            } else {
                console.error("Modal 'finalizar_venda' NÃO encontrado no DOM");
            }
        }, 1000);
        
        // Enviar os dados dos múltiplos pagamentos ao backend - versão 1
        console.log("Inicializando tratamento de múltiplos pagamentos - versão 1");
        
        // Interceptar o submit do formulário quando clica em Documento Auxiliar ou Cupom Fiscal
        $(document).on('click', '#btn_nao_fiscal, .btn-fiscal', function(e) {
            e.preventDefault(); // Importante: prevenir o comportamento padrão
            console.log("Clique em botão de finalização de venda detectado - versão 1");
            
        });
    });

    document.addEventListener('DOMContentLoaded', function () {
        // Handler para o botão de recebimento
        const btnRecebimento = document.getElementById('btn-recebimento');
        
        if (btnRecebimento) {
            btnRecebimento.addEventListener('click', function () {
                // Primeiro esconde todas as abas
                $('.tab-pane').removeClass('show active').hide();
                
                // Ativa e mostra a aba de recebimentos
                $('#tab-recebimentos').addClass('show active').show();
                
                // Atualiza o estado da navegação
                $('.nav-link').removeClass('active');
                $('#tab-recebimentos-tab').addClass('active');
                
                // Foca no campo de CPF/CNPJ para facilitar a busca
                setTimeout(function() {
                    $('#cpf_cnpj_recebimento').focus();
                }, 300);
            });
        } else {
            console.error('Botão de recebimento não encontrado no DOM');
        }
    });

    // Inicializar variáveis e estados
    $(document).ready(function() {
        console.log("Inicializando painel de pagamentos...");
        
        // Definir datas padrão
        const hoje = new Date();
        const dataVencimentoPadrao = new Date();
        dataVencimentoPadrao.setDate(hoje.getDate() + 30); // Data padrão de vencimento: hoje + 30 dias
        
        // Data do primeiro pagamento para parcelamentos
        const dataPrimeiroPagamento = new Date();
        dataPrimeiroPagamento.setDate(hoje.getDate() + 30); // Definindo para hoje + 30 dias
        
        // Configurar campos de data
        $('.data_atual').val(formatarData(hoje));
        $('.data_vencimento_padrao').val(formatarData(dataVencimentoPadrao));
        $('#data_primeiro_pagamento').val(formatarData(dataPrimeiroPagamento));
        
        // ... existing code ...
    });

    // Funcionalidades da aba de Recebimentos
    $(document).ready(function() {
        console.log("Inicializando funcionalidades da aba de Recebimentos...");
        
        // Configurar o select2 para busca de clientes
        $('#cliente_id_recebimento').select2({
            placeholder: 'Digite o nome do cliente',
            allowClear: true,
            minimumInputLength: 3,
            ajax: {
                url: '<?php echo e(route("api.cliente.find")); ?>',
                dataType: 'json',
                delay: 250,
                type: 'POST', // Usando POST para busca de clientes
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: function (params) {
                    console.log('Enviando parâmetros de busca:', {
                        q: params.term,
                        empresa_id: '<?php echo e(request()->empresa_id); ?>'
                    });
                    return {
                        q: params.term,
                        empresa_id: '<?php echo e(request()->empresa_id); ?>'
                    };
                },
                beforeSend: function() {
                    console.log('Iniciando requisição para busca de clientes...');
                },
                processResults: function (data) {
                    console.log('Resposta da busca de clientes:', data);
                    // Verificar se a resposta contém um array (resultado normal)
                    // ou um objeto de erro
                    if (Array.isArray(data)) {
                        return {
                            results: $.map(data, function (item) {
                                return {
                                    text: item.razao_social,
                                    id: item.id
                                }
                            })
                        };
                    } else if (data.error) {
                        // Se houver um erro na resposta
                        console.error('Erro retornado pela API:', data.error);
                        return { results: [] };
                    } else {
                        // Caso a resposta não seja um array nem tenha propriedade error
                        console.warn('Resposta inesperada da API:', data);
                        return { results: [] };
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Erro na busca de clientes:', error);
                    console.error('Status:', status);
                    console.error('Resposta:', xhr.responseText);
                    
                    // Exibir uma notificação para o usuário
                    if ($('#select2-cliente_id_recebimento-results').length) {
                        $('#select2-cliente_id_recebimento-results').html('<li class="select2-results__option">Erro ao buscar clientes. Tente novamente.</li>');
                    }
                    return { results: [] };
                },
                cache: true
            }
        });
        
        // Quando um cliente for selecionado no select2
        $('#cliente_id_recebimento').on('select2:select', function (e) {
            const clienteId = e.params.data.id;
            if (!clienteId) return;
            
            // Limpar o campo de CPF/CNPJ
            $('#cpf_cnpj_recebimento').val('');
            
            // Buscar recebimentos do cliente pelo ID
            buscarRecebimentosPorId(clienteId);
        });
        
        // Função para buscar recebimentos por ID do cliente
        function buscarRecebimentosPorId(clienteId) {
            // Exibir indicador de carregamento
            $('#mensagem-inicial-recebimentos').html(
                '<div class="text-center p-5">' +
                    '<div class="spinner-border text-primary" role="status">' +
                        '<span class="visually-hidden">Carregando...</span>' +
                    '</div>' +
                    '<h5 class="mt-3">Buscando informações do cliente...</h5>' +
                    '<p class="text-muted">Aguarde enquanto consultamos os lançamentos em aberto</p>' +
                '</div>'
            );
            
            // Esconder a área de resultados durante a busca
            $('#resultado-recebimentos').hide();
            
            // Realizar a requisição AJAX para a API
            $.ajax({
                url: '<?php echo e(route("api.pdv.produto.find")); ?>'.replace('/produto/find', '/buscar-contas-receber-por-id'),
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    cliente_id: clienteId,
                    empresa_id: '<?php echo e(request()->empresa_id); ?>'
                },
                dataType: 'json',
                success: function(response) {
                    console.log('Resposta da API (busca por ID):', response);
                    
                    // Processamento igual ao da busca por CPF/CNPJ
                    if (response && response.success) {
                        // Preencher informações do cliente
                        const cliente = response.data.cliente;
                        $('#cliente-nome').text(cliente.nome);
                        $('#cliente-cpf-cnpj').text(cliente.cpf_cnpj);
                        $('#cliente-telefone').text(cliente.telefone || 'Não informado');
                        $('#cliente-saldo').text('R$ ' + formatarMoeda(cliente.saldo_disponivel));
                        
                        // Limpar e preencher a tabela de lançamentos
                        const contas = response.data.contas;
                        const $tabela = $('#tabela-lancamentos');
                        $tabela.empty();
                        
                        if (contas.length === 0) {
                            $tabela.html('<tr><td colspan="5" class="text-center py-3">Nenhum lançamento em aberto encontrado para este cliente.</td></tr>');
                        } else {
                            // Preencher a tabela com os lançamentos
                            contas.forEach(function(conta) {
                                const valorPendente = parseFloat(conta.valor_pendente);
                                
                                let html = '<tr>';
                                html += '<td class="text-center">';
                                html += '<input type="checkbox" class="form-check-input checkbox-recebimento" value="' + conta.id + '" data-id="' + conta.id + '" data-valor="' + valorPendente + '">';
                                html += '</td>';
                                html += '<td>' + (conta.descricao || 'Sem descrição') + '</td>';
                                html += '<td>' + conta.data_vencimento_formatada + ' <br><small class="text-muted">' + conta.dias_atraso + '</small></td>';
                                html += '<td>R$ ' + formatarMoeda(valorPendente) + '</td>';
                                html += '<td>' + conta.status_formatado + '</td>';
                                html += '</tr>';
                                
                                $tabela.append(html);
                            });
                            
                            // Adicionar event listener para checkboxes
                            $(document).on('change', '.checkbox-recebimento', function() {
                                atualizarBotaoReceber();
                            });
                        }
                        
                        // Mostrar a área de resultados e esconder mensagem inicial
                        $('#resultado-recebimentos').show();
                        $('#mensagem-inicial-recebimentos').hide();
                    } else {
                        // Se a busca falhou ou retornou success: false
                        let mensagem = response && response.message ? response.message : 'Não foi possível encontrar lançamentos para este cliente';
                        
                        let htmlFalha = '<div class="alert alert-warning text-center" role="alert">';
                        htmlFalha += '<i class="ri-error-warning-line" style="font-size: 48px;"></i>';
                        htmlFalha += '<h5 class="mt-3">Cliente não possui lançamentos</h5>';
                        htmlFalha += '<p>' + mensagem + '</p>';
                        htmlFalha += '<button class="btn btn-outline-primary mt-2" id="btn-tentar-novamente">';
                        htmlFalha += '<i class="ri-refresh-line"></i> Tentar Novamente';
                        htmlFalha += '</button>';
                        htmlFalha += '</div>';
                        
                        $('#mensagem-inicial-recebimentos').html(htmlFalha);
                        
                        // Handler para o botão de tentar novamente
                        $('#btn-tentar-novamente').on('click', function() {
                            resetarBuscaRecebimentos();
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Erro na busca de recebimentos por ID:', error);
                    console.error('Status:', status);
                    console.error('Resposta:', xhr.responseText);
                    
                    // Tentar extrair a mensagem de erro se disponível
                    let mensagemErro = 'Ocorreu um erro ao buscar os lançamentos. Por favor, tente novamente.';
                    
                    try {
                        const resposta = JSON.parse(xhr.responseText);
                        if (resposta && resposta.message) {
                            mensagemErro = resposta.message;
                        }
                    } catch (e) {
                        // Se não conseguir parsear a resposta, usa a mensagem padrão
                    }
                    
                    // Mensagem de erro
                    let htmlErro = '<div class="alert alert-danger text-center" role="alert">';
                    htmlErro += '<i class="ri-error-warning-line" style="font-size: 48px;"></i>';
                    htmlErro += '<h5 class="mt-3">Erro na Busca</h5>';
                    htmlErro += '<p>' + mensagemErro + '</p>';
                    htmlErro += '<button class="btn btn-outline-primary mt-2" id="btn-tentar-novamente">';
                    htmlErro += '<i class="ri-refresh-line"></i> Tentar Novamente';
                    htmlErro += '</button>';
                    htmlErro += '</div>';
                    
                    $('#mensagem-inicial-recebimentos').html(htmlErro);
                    
                    // Handler para o botão de tentar novamente
                    $('#btn-tentar-novamente').on('click', function() {
                        resetarBuscaRecebimentos();
                    });
                }
            });
        }
        
        // Função para resetar a busca de recebimentos
        function resetarBuscaRecebimentos() {
            let htmlInicial = '<i class="ri-search-line" style="font-size: 48px; color: #ccc;"></i>';
            htmlInicial += '<h5 class="mt-3">Busque um cliente pelo CPF/CNPJ ou Nome</h5>';
            htmlInicial += '<p class="text-muted">Utilize uma das opções acima para buscar os lançamentos em aberto do cliente</p>';
            
            $('#mensagem-inicial-recebimentos').html(htmlInicial);
            
            // Limpar os campos de busca
            $('#cpf_cnpj_recebimento').val('');
            $('#cliente_id_recebimento').val(null).trigger('change');
            
            // Focar no campo de CPF/CNPJ
            $('#cpf_cnpj_recebimento').focus();
        }
        
        // Função para formatar CPF/CNPJ enquanto digita
        $('#cpf_cnpj_recebimento').on('input', function() {
            let value = $(this).val().replace(/\D/g, '');
            
            if (value.length <= 11) {
                // CPF: formato 000.000.000-00
                if (value.length > 9) {
                    $(this).val(value.replace(/(\d{3})(\d{3})(\d{3})(\d{1,2})/, '$1.$2.$3-$4'));
                } else if (value.length > 6) {
                    $(this).val(value.replace(/(\d{3})(\d{3})(\d{1,3})/, '$1.$2.$3'));
                } else if (value.length > 3) {
                    $(this).val(value.replace(/(\d{3})(\d{1,3})/, '$1.$2'));
                } else {
                    $(this).val(value);
                }
            } else {
                // CNPJ: formato 00.000.000/0000-00
                if (value.length > 12) {
                    $(this).val(value.replace(/(\d{2})(\d{3})(\d{3})(\d{4})(\d{1,2})/, '$1.$2.$3/$4-$5'));
                } else if (value.length > 8) {
                    $(this).val(value.replace(/(\d{2})(\d{3})(\d{3})(\d{1,4})/, '$1.$2.$3/$4'));
                } else if (value.length > 5) {
                    $(this).val(value.replace(/(\d{2})(\d{3})(\d{1,3})/, '$1.$2.$3'));
                } else if (value.length > 2) {
                    $(this).val(value.replace(/(\d{2})(\d{1,3})/, '$1.$2'));
                } else {
                    $(this).val(value);
                }
            }
        });
        
        // Botão voltar da aba de recebimentos
        $('#btn-voltar-vendas-recebimentos').on('click', function() {
            console.log("Clique no botão voltar da aba de recebimentos");
            
            // Volta para a aba de vendas
            $('.tab-pane').removeClass('show active').hide();
            $('#tab-vendas').addClass('show active').show();
            
            // Atualiza os estados das tabs na navegação
            $('.nav-link').removeClass('active');
            $('#tab-vendas-tab').addClass('active');
            
            // Limpa os resultados da busca
            $('#resultado-recebimentos').hide();
            $('#mensagem-inicial-recebimentos').show();
            $('#cpf_cnpj_recebimento').val('');
        });
        
        // Funcionalidade de busca de recebimentos por CPF/CNPJ
        $('#btn-buscar-recebimentos').on('click', function() {
            buscarRecebimentos();
        });
        
        // Permitir busca ao pressionar Enter no campo de CPF/CNPJ
        $('#cpf_cnpj_recebimento').on('keypress', function(e) {
            if (e.which === 13) { // Código da tecla Enter
                e.preventDefault();
                buscarRecebimentos();
            }
        });
        
        // Função para buscar recebimentos
        function buscarRecebimentos() {
            const cpfCnpj = $('#cpf_cnpj_recebimento').val().trim();
            
            // Validação básica
            if (!cpfCnpj) {
                swal('Atenção', 'Informe o CPF/CNPJ do cliente para realizar a busca', 'warning');
                return;
            }
            
            // Exibir indicador de carregamento
            $('#mensagem-inicial-recebimentos').html(
                '<div class="text-center p-5">' +
                    '<div class="spinner-border text-primary" role="status">' +
                        '<span class="visually-hidden">Carregando...</span>' +
                    '</div>' +
                    '<h5 class="mt-3">Buscando informações do cliente...</h5>' +
                    '<p class="text-muted">Aguarde enquanto consultamos os lançamentos em aberto</p>' +
                '</div>'
            );
            
            // Esconder a área de resultados durante a busca
            $('#resultado-recebimentos').hide();
            
            // Realizar a requisição AJAX para a API
            $.ajax({
                url: '<?php echo e(route("api.pdv.produto.find")); ?>'.replace('/produto/find', '/buscar-contas-receber'),
                method: 'POST',
                data: {
                    cpf_cnpj: cpfCnpj,
                    empresa_id: '<?php echo e(request()->empresa_id); ?>'
                },
                dataType: 'json',
                success: function(response) {
                    console.log('Resposta da API:', response);
                    
                    // Se a busca foi bem sucedida
                    if (response.success) {
                        // Preencher informações do cliente
                        const cliente = response.data.cliente;
                        $('#cliente-nome').text(cliente.nome);
                        $('#cliente-cpf-cnpj').text(cliente.cpf_cnpj);
                        $('#cliente-telefone').text(cliente.telefone || 'Não informado');
                        $('#cliente-saldo').text('R$ ' + formatarMoeda(cliente.saldo_disponivel));
                        
                        // Limpar e preencher a tabela de lançamentos
                        const contas = response.data.contas;
                        const $tabela = $('#tabela-lancamentos');
                        $tabela.empty();
                        
                        if (contas.length === 0) {
                            $tabela.html('<tr><td colspan="5" class="text-center py-3">Nenhum lançamento em aberto encontrado para este cliente.</td></tr>');
                        } else {
                            // Preencher a tabela com os lançamentos
                            contas.forEach(function(conta) {
                                const valorPendente = parseFloat(conta.valor_pendente);
                                
                                let html = '<tr>';
                                html += '<td class="text-center">';
                                html += '<input type="checkbox" class="form-check-input checkbox-recebimento" value="' + conta.id + '" data-id="' + conta.id + '" data-valor="' + valorPendente + '">';
                                html += '</td>';
                                html += '<td>' + (conta.descricao || 'Sem descrição') + '</td>';
                                html += '<td>' + conta.data_vencimento_formatada + ' <br><small class="text-muted">' + conta.dias_atraso + '</small></td>';
                                html += '<td>R$ ' + formatarMoeda(valorPendente) + '</td>';
                                html += '<td>' + conta.status_formatado + '</td>';
                                html += '</tr>';
                                
                                $tabela.append(html);
                            });
                            
                            // Adicionar handlers para os botões de recebimento
                            $('.btn-receber-lancamento').on('click', function() {
                                const id = $(this).data('id');
                                const valor = $(this).data('valor');
                                const descricao = $(this).data('descricao');
                                
                                swal({
                                    title: "Receber Lançamento",
                                    text: "Deseja receber o valor de R$ " + formatarMoeda(valor) + " referente a \"" + descricao + "\"?",
                                    icon: "info",
                                    buttons: {
                                        cancel: "Cancelar",
                                        confirm: "Confirmar Recebimento"
                                    }
                                }).then((confirmou) => {
                                    if (confirmou) {
                                        // Aqui implementaremos o recebimento no futuro
                                        swal("Funcionalidade em Desenvolvimento", "O módulo de recebimento de lançamentos está sendo implementado.", "info");
                                    }
                                });
                            });
                        }
                        
                        // Mostrar a área de resultados e esconder mensagem inicial
                        $('#resultado-recebimentos').show();
                        $('#mensagem-inicial-recebimentos').hide();
                    } else {
                        // Se a busca falhou (cliente não encontrado)
                        let htmlFalha = '<div class="alert alert-warning text-center" role="alert">';
                        htmlFalha += '<i class="ri-error-warning-line" style="font-size: 48px;"></i>';
                        htmlFalha += '<h5 class="mt-3">Cliente não encontrado</h5>';
                        htmlFalha += '<p>Não foi possível encontrar um cliente com o CPF/CNPJ <strong>' + cpfCnpj + '</strong>.</p>';
                        htmlFalha += '<p>A busca foi realizada considerando tanto o formato digitado quanto sem pontuação.</p>';
                        htmlFalha += '<button class="btn btn-outline-primary mt-2" id="btn-tentar-novamente">';
                        htmlFalha += '<i class="ri-refresh-line"></i> Tentar Novamente';
                        htmlFalha += '</button>';
                        htmlFalha += '</div>';
                        
                        $('#mensagem-inicial-recebimentos').html(htmlFalha);
                        
                        // Handler para o botão de tentar novamente
                        $('#btn-tentar-novamente').on('click', function() {
                            let htmlInicial = '<i class="ri-search-line" style="font-size: 48px; color: #ccc;"></i>';
                            htmlInicial += '<h5 class="mt-3">Busque um cliente pelo CPF/CNPJ</h5>';
                            htmlInicial += '<p class="text-muted">Informe o CPF/CNPJ do cliente para visualizar seus lançamentos em aberto</p>';
                            
                            $('#mensagem-inicial-recebimentos').html(htmlInicial);
                            
                            // Limpar o campo de busca
                            $('#cpf_cnpj_recebimento').val('').focus();
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Erro na busca de recebimentos:', error);
                    
                    // Mensagem de erro
                    let htmlErro = '<div class="alert alert-danger text-center" role="alert">';
                    htmlErro += '<i class="ri-error-warning-line" style="font-size: 48px;"></i>';
                    htmlErro += '<h5 class="mt-3">Erro na Busca</h5>';
                    htmlErro += '<p>Ocorreu um erro ao buscar os lançamentos. Por favor, tente novamente.</p>';
                    htmlErro += '<button class="btn btn-outline-primary mt-2" id="btn-tentar-novamente">';
                    htmlErro += '<i class="ri-refresh-line"></i> Tentar Novamente';
                    htmlErro += '</button>';
                    htmlErro += '</div>';
                    
                    $('#mensagem-inicial-recebimentos').html(htmlErro);
                    
                    // Handler para o botão de tentar novamente
                    $('#btn-tentar-novamente').on('click', function() {
                        let htmlInicial = '<i class="ri-search-line" style="font-size: 48px; color: #ccc;"></i>';
                        htmlInicial += '<h5 class="mt-3">Busque um cliente pelo CPF/CNPJ</h5>';
                        htmlInicial += '<p class="text-muted">Informe o CPF/CNPJ do cliente para visualizar seus lançamentos em aberto</p>';
                        
                        $('#mensagem-inicial-recebimentos').html(htmlInicial);
                        
                        // Limpar o campo de busca
                        $('#cpf_cnpj_recebimento').val('').focus();
                    });
                }
            });
        }
    });
    
    // Função para atualizar o estado do botão de receber com base nas seleções
    function atualizarBotaoReceber() {
        const selecionados = $('.checkbox-recebimento:checked').length;
        const botao = $('#btn-receber-selecionados');

        if (selecionados > 0) {
            botao.prop('disabled', false);
        } else {
            botao.prop('disabled', true);
        }
    }
    
    // Event listener para quando os checkboxes de recebimento mudarem
    $(document).on('change', '.checkbox-recebimento', function() {
        atualizarBotaoReceber();
    });
    
    // Botão para receber contas selecionadas
    $('#btn-receber-selecionados').on('click', function() {
        const contasSelecionadas = [];
        
        // Coletar IDs das contas selecionadas
        $('.checkbox-recebimento:checked').each(function() {
            contasSelecionadas.push($(this).val());
        });
        
        if (contasSelecionadas.length === 0) {
            swal('Atenção', 'Selecione pelo menos uma conta para receber', 'warning');
            return;
        }
        
        // Criar um formulário dinâmico para enviar os IDs das contas
        const form = $('<form></form>').attr({
            method: 'POST',
            action: '<?php echo e(route("conta-receber.recebe-select")); ?>',
            id: 'form-receber-selecionados'
        });
        
        // Adicionar token CSRF
        form.append($('<input>').attr({
            type: 'hidden',
            name: '_token',
            value: '<?php echo e(csrf_token()); ?>'
        }));
        
        // Adicionar IDs das contas
        contasSelecionadas.forEach(function(id) {
            form.append($('<input>').attr({
                type: 'hidden',
                name: 'item_recebe_paga[]',
                value: id
            }));
        });
        
        // Adicionar o formulário ao corpo do documento e enviar
        $('body').append(form);
        $('#form-receber-selecionados').submit();
    });

    $(document).on('click', '#btn-sair-pdv', function(e) {
    if ($('.table-itens tbody tr').length > 0) {
        e.preventDefault();
        swal("Atenção", "Ainda existem itens no carrinho. Remova todos os itens antes de sair do PDV!", "warning");
        return false;
    }
    // ... existing code (deixa o comportamento padrão se não houver itens) ...
});

    
</script>
<?php $__env->stopSection(); ?>



<!-- Botão de alternância de tema (dark/light) -->
<!-- <button id="theme-toggle-btn" class="btn btn-light" aria-label="Alternar tema claro/escuro" style="position: fixed; top: 10px; right: 10px; z-index: 99999;">
    TESTE
</button> -->
<?php /**PATH C:\xampp\htdocs\erp_dev\resources\views/front_box/_forms.blade.php ENDPATH**/ ?>